/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.vegetation;

import com.teammetallurgy.atum.init.AtumItems;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;

public class DateBlock
extends BushBlock
implements IGrowable {
    public static final IntegerProperty AGE = BlockStateProperties.field_208170_W;
    private static final VoxelShape STEM = Block.func_208617_a((double)7.0, (double)10.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape BOUNDING_BOX = Block.func_208617_a((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);

    public DateBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151585_k).func_200947_a(SoundType.field_185850_c).func_226896_b_().func_200944_c());
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
    }

    public float func_176195_g(BlockState state, IBlockReader world, BlockPos pos) {
        if ((Integer)state.func_177229_b((IProperty)AGE) != 3) {
            return 0.25f;
        }
        return 0.35f;
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        if ((Integer)state.func_177229_b((IProperty)AGE) == 0) {
            return STEM;
        }
        return BOUNDING_BOX;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        if (!world.field_72995_K) {
            super.func_225534_a_(state, world, pos, rand);
            if (!world.isAreaLoaded(pos, 1)) {
                return;
            }
            if ((Integer)state.func_177229_b((IProperty)AGE) != 7 && ForgeHooks.onCropsGrowPre((World)world, (BlockPos)pos, (BlockState)state, (world.field_73012_v.nextDouble() <= (double)0.12f ? 1 : 0) != 0)) {
                world.func_180501_a(pos, (BlockState)state.func_177231_a((IProperty)AGE), 2);
                ForgeHooks.onCropsGrowPost((World)world, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        if (state.func_177230_c() == this) {
            BlockState stateUp = world.func_180495_p(pos.func_177984_a());
            return stateUp.func_177230_c().func_203417_a(BlockTags.field_206952_E);
        }
        return super.func_200014_a_(world.func_180495_p(pos.func_177977_b()), (IBlockReader)world, pos);
    }

    @Nonnull
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult rayTraceResult) {
        if ((Integer)state.func_177229_b((IProperty)AGE) == 7) {
            DateBlock.func_220075_c((BlockState)state, (World)world, (BlockPos)pos);
            return world.func_175656_a(pos, this.func_176223_P()) ? ActionResultType.SUCCESS : ActionResultType.PASS;
        }
        return ActionResultType.PASS;
    }

    @Nonnull
    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)AtumItems.DATE);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> container) {
        container.func_206894_a(new IProperty[]{AGE});
    }

    public boolean func_176473_a(@Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, boolean isClient) {
        return (Integer)state.func_177229_b((IProperty)AGE) != 7;
    }

    public boolean func_180670_a(@Nonnull World world, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        return true;
    }

    public void func_225535_a_(@Nonnull ServerWorld world, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        int maxAge;
        int growth = (Integer)state.func_177229_b((IProperty)AGE) + MathHelper.func_76136_a((Random)rand, (int)1, (int)2);
        if (growth > (maxAge = 7)) {
            growth = maxAge;
        }
        if ((Integer)state.func_177229_b((IProperty)AGE) != 7) {
            world.func_180501_a(pos, (BlockState)this.func_176223_P().func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(growth)), 2);
        }
    }
}

