/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.vegetation;

import com.teammetallurgy.atum.init.AtumBiomes;
import com.teammetallurgy.atum.init.AtumBlocks;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.StemBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.ToolType;

public class FertileSoilBlock
extends Block
implements IGrowable {
    public FertileSoilBlock() {
        super(Block.Properties.func_200949_a((Material)Material.field_151577_b, (MaterialColor)MaterialColor.field_151661_c).func_200944_c().func_200943_b(0.5f).func_200947_a(SoundType.field_185849_b).harvestTool(ToolType.SHOVEL).harvestLevel(0));
    }

    public int func_200011_d(BlockState state, @Nonnull IBlockReader reader, @Nonnull BlockPos pos) {
        return 255;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (!world.field_72995_K) {
            if (!world.isAreaLoaded(pos, 3)) {
                return;
            }
            if (!this.hasWater((World)world, pos)) {
                if (world.func_226691_t_(pos) != AtumBiomes.OASIS) {
                    world.func_180501_a(pos, AtumBlocks.SAND.func_176223_P(), 2);
                }
            } else if (Block.func_208061_a((VoxelShape)world.func_180495_p(pos.func_177984_a()).func_196952_d((IBlockReader)world, pos), (Direction)Direction.DOWN)) {
                if (world.field_73012_v.nextDouble() >= 0.5) {
                    world.func_180501_a(pos, AtumBlocks.SAND.func_176223_P(), 2);
                }
            } else if (world.func_201696_r(pos.func_177984_a()) >= 9) {
                for (int i = 0; i < 4; ++i) {
                    BlockPos posGrow = pos.func_177982_a(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                    if (posGrow.func_177956_o() >= 0 && posGrow.func_177956_o() < 256 && !world.func_175667_e(posGrow) || !this.hasWater((World)world, posGrow)) {
                        return;
                    }
                    BlockState stateUp = world.func_180495_p(posGrow.func_177984_a());
                    BlockState stateGrow = world.func_180495_p(posGrow);
                    if (stateGrow.func_177230_c() != AtumBlocks.SAND || world.func_201696_r(posGrow.func_177984_a()) < 4 || stateUp.func_200016_a((IBlockReader)world, pos.func_177984_a()) > 2) continue;
                    world.func_175656_a(posGrow, AtumBlocks.FERTILE_SOIL.func_176223_P());
                }
            }
        }
    }

    private boolean hasWater(World world, BlockPos pos) {
        for (BlockPos Mutable2 : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-6, -1, -6), (BlockPos)pos.func_177982_a(6, 4, 6))) {
            if (world.func_180495_p(Mutable2).func_185904_a() != Material.field_151586_h) continue;
            return true;
        }
        return false;
    }

    public boolean canSustainPlant(@Nonnull BlockState state, @Nonnull IBlockReader world, BlockPos pos, @Nonnull Direction direction, IPlantable plantable) {
        BlockState plant = plantable.getPlant(world, pos.func_177972_a(direction));
        PlantType plantType = plantable.getPlantType(world, pos.func_177984_a());
        boolean hasWater = world.func_180495_p(pos.func_177974_f()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177976_e()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177978_c()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177968_d()).func_185904_a() == Material.field_151586_h;
        switch (plantType) {
            case Plains: {
                return true;
            }
            case Beach: {
                return hasWater;
            }
            case Crop: {
                return plant.func_177230_c() instanceof StemBlock;
            }
        }
        return super.canSustainPlant(state, world, pos, direction, plantable);
    }

    public boolean func_176473_a(@Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(@Nonnull World world, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        return true;
    }

    public void func_225535_a_(@Nonnull ServerWorld world, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        BlockPos posUp = pos.func_177984_a();
        block0: for (int amount = 0; amount < 36; ++amount) {
            BlockPos up = posUp;
            int amountCheck = 0;
            while (true) {
                if (amountCheck >= amount / 16) {
                    BlockState grassState;
                    if (!world.func_175623_d(up) || !(rand.nextDouble() <= 75.0) || !AtumBlocks.OASIS_GRASS.func_196260_a(grassState = AtumBlocks.OASIS_GRASS.func_176223_P(), (IWorldReader)world, up)) continue block0;
                    world.func_180501_a(up, grassState, 3);
                    continue block0;
                }
                if (world.func_180495_p((up = up.func_177982_a(rand.nextInt(3) - 1, (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, rand.nextInt(3) - 1)).func_177977_b()).func_177230_c() != AtumBlocks.FERTILE_SOIL || world.func_180495_p(up).func_215686_e((IBlockReader)world, up)) continue block0;
                ++amountCheck;
            }
        }
    }
}

