/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.client.particle;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nonnull;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RaFireParticle
extends SpriteTexturedParticle {
    private final float flameScale;

    private RaFireParticle(World world, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, IAnimatedSprite spriteSet) {
        super(world, xCoord, yCoord, zCoord, xSpeed, ySpeed, zSpeed);
        this.field_187129_i = this.field_187129_i * (double)0.01f + xSpeed;
        this.field_187130_j = this.field_187130_j * (double)0.01f + ySpeed;
        this.field_187131_k = this.field_187131_k * (double)0.01f + zSpeed;
        this.field_187126_f += (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.05f);
        this.field_187127_g += (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.05f);
        this.field_187128_h += (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.05f);
        this.flameScale = this.field_70544_f;
        this.field_70552_h = 1.0f;
        this.field_70553_i = 1.0f;
        this.field_70551_j = 1.0f;
        this.field_70547_e = (int)(8.0 / (Math.random() * 0.8 + 0.2)) + 4;
        this.func_217566_b(spriteSet);
    }

    @Nonnull
    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217602_b;
    }

    public void func_187110_a(double x, double y, double z) {
        this.func_187108_a(this.func_187116_l().func_72317_d(x, y, z));
        this.func_187118_j();
    }

    public void func_225606_a_(IVertexBuilder builder, ActiveRenderInfo renderInfo, float partialTicks) {
        float f = ((float)this.field_70546_d + partialTicks) / (float)this.field_70547_e;
        this.field_70544_f = this.flameScale * (1.0f - f * f * 0.5f);
        super.func_225606_a_(builder, renderInfo, partialTicks);
    }

    public int func_189214_a(float partialTick) {
        float f = ((float)this.field_70546_d + partialTick) / (float)this.field_70547_e;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        int i = super.func_189214_a(partialTick);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        this.field_187129_i *= (double)0.96f;
        this.field_187130_j *= (double)0.96f;
        this.field_187131_k *= (double)0.96f;
        if (this.field_187132_l) {
            this.field_187129_i *= (double)0.7f;
            this.field_187131_k *= (double)0.7f;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite spriteSet;

        public Factory(IAnimatedSprite sprite) {
            this.spriteSet = sprite;
        }

        public Particle makeParticle(@Nonnull BasicParticleType particleType, @Nonnull World world, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed) {
            return new RaFireParticle(world, xCoord, yCoord, zCoord, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }
}

