/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.client.render.entity.mobs;

import com.google.common.collect.Maps;
import com.teammetallurgy.atum.client.model.entity.CamelModel;
import com.teammetallurgy.atum.entity.animal.CamelEntity;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.texture.LayeredTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CamelRender
extends MobRenderer<CamelEntity, CamelModel<CamelEntity>> {
    private static final Map<String, ResourceLocation> CACHE = Maps.newHashMap();
    private static final ResourceLocation GIRAFI = new ResourceLocation("atum", "textures/entity/camel_girafi.png");

    public CamelRender(EntityRendererManager renderManager) {
        super(renderManager, new CamelModel(), 0.7f);
    }

    @Nonnull
    public ResourceLocation getEntityTexture(@Nonnull CamelEntity camel) {
        String textureName = camel.getTexture();
        ResourceLocation location = CACHE.get(textureName);
        if (location == null) {
            DyeColor color;
            ItemStack armor;
            String customName;
            location = new ResourceLocation(textureName);
            String[] texturePath = new String[3];
            texturePath[0] = new ResourceLocation("atum", "textures/entity/camel_" + camel.getVariant()) + ".png";
            if (camel.func_145818_k_() && camel.func_200201_e() != null && (customName = camel.func_200201_e().func_150254_d()).equalsIgnoreCase("girafi")) {
                texturePath[0] = GIRAFI.toString();
            }
            if (!(armor = camel.getArmor()).func_190926_b()) {
                CamelEntity.ArmorType armorType = CamelEntity.ArmorType.getByItemStack(armor);
                texturePath[1] = armorType.getTextureName();
            }
            if ((color = camel.getColor()) != null) {
                texturePath[2] = new ResourceLocation("atum", "textures/entity/camel_carpet/camel_carpet_" + color.func_176610_l()) + ".png";
            }
            Minecraft.func_71410_x().func_110434_K().func_229263_a_(location, (Texture)new LayeredTexture(texturePath));
            CACHE.put(textureName, location);
        }
        return location;
    }
}

