/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.teammetallurgy.atum.blocks.beacon.tileentity.RadiantBeaconTileEntity;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.BeaconTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.tileentity.BeaconTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RadiantBeaconRender
extends TileEntityRenderer<RadiantBeaconTileEntity> {
    private static final ResourceLocation BEAM = new ResourceLocation("textures/entity/beacon_beam.png");

    public RadiantBeaconRender(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(RadiantBeaconTileEntity radiantBeacon, float partialTicks, @Nonnull MatrixStack matrixStack, @Nonnull IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        if (radiantBeacon.func_145831_w() != null) {
            this.renderBeacon(matrixStack, buffer, partialTicks, radiantBeacon.func_174907_n(), radiantBeacon.func_145831_w().func_82737_E());
        }
    }

    private void renderBeacon(MatrixStack matrixStack, IRenderTypeBuffer buffer, float partialTicks, List<BeaconTileEntity.BeamSegment> beamSegments, long totalWorldTime) {
        int height = 0;
        for (int i = 0; i < beamSegments.size(); ++i) {
            BeaconTileEntity.BeamSegment segment = beamSegments.get(i);
            BeaconTileEntityRenderer.func_228842_a_((MatrixStack)matrixStack, (IRenderTypeBuffer)buffer, (ResourceLocation)BEAM, (float)partialTicks, (float)1.0f, (long)totalWorldTime, (int)height, (int)(i == beamSegments.size() - 1 ? 1024 : segment.func_177264_c()), (float[])segment.func_177263_b(), (float)0.2f, (float)0.25f);
            height += segment.func_177264_c();
        }
    }

    public boolean isGlobalRenderer(RadiantBeaconTileEntity te) {
        return true;
    }
}

