/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.entity.animal;

import com.teammetallurgy.atum.entity.ai.goal.BegGoal;
import com.teammetallurgy.atum.entity.ai.goal.FollowOwnerWithoutSaddleGoal;
import com.teammetallurgy.atum.entity.ai.goal.SitWithCheckGoal;
import com.teammetallurgy.atum.entity.animal.CamelEntity;
import com.teammetallurgy.atum.entity.undead.UndeadBaseEntity;
import com.teammetallurgy.atum.init.AtumEntities;
import com.teammetallurgy.atum.init.AtumItems;
import com.teammetallurgy.atum.init.AtumLootTables;
import com.teammetallurgy.atum.inventory.container.entity.AlphaDesertWolfContainer;
import com.teammetallurgy.atum.network.NetworkHandler;
import com.teammetallurgy.atum.network.packet.OpenWolfGuiPacket;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.NonTamedTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SaddleItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

@Mod.EventBusSubscriber(modid="atum")
public class DesertWolfEntity
extends TameableEntity
implements IJumpingMount,
IInventoryChangedListener,
INamedContainerProvider {
    private static final DataParameter<Float> DATA_HEALTH_ID = EntityDataManager.func_187226_a(DesertWolfEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> BEGGING = EntityDataManager.func_187226_a(DesertWolfEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> COLLAR_COLOR = EntityDataManager.func_187226_a(DesertWolfEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SADDLED = EntityDataManager.func_187226_a(DesertWolfEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<ItemStack> ARMOR_STACK = EntityDataManager.func_187226_a(DesertWolfEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("0b3da7ef-52bf-47c9-9829-862ffa35b418");
    private String texturePath;
    private Inventory desertWolfInventory;
    private float headRotationCourse;
    private float headRotationCourseWild;
    private boolean isWet;
    private boolean isShaking;
    private float timeWolfIsShaking;
    private float prevTimeWolfIsShaking;
    private int angryTimer;
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(DesertWolfEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final IAttribute JUMP_STRENGTH = new RangedAttribute(null, "wolf.jumpStrength", 0.7, 0.0, 2.0).func_111117_a("Jump Strength").func_111112_a(true);
    private boolean isWolfJumping;
    private float jumpPower;
    private static long lastAlphaTime = 0L;
    private LazyOptional<?> itemHandler = null;

    public DesertWolfEntity(EntityType<? extends DesertWolfEntity> entityType, World world) {
        super(entityType, world);
        this.setAngry(true);
        this.func_70903_f(false);
        this.field_70728_aV = 6;
        this.field_70138_W = 1.1f;
        this.initInventory();
    }

    protected void func_184651_r() {
        this.field_70911_d = new SitWithCheckGoal(this, !this.isAlpha());
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, DesertWolfEntity.class, 8.0f, 0.6, 1.0, avoid -> avoid instanceof DesertWolfEntity && ((DesertWolfEntity)((Object)avoid)).isAlpha() && !this.isAlpha() && this.func_70909_n()));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, LlamaEntity.class, 24.0f, 0.6, 1.2));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, CamelEntity.class, 24.0f, 0.6, 1.2, avoid -> avoid != null && !this.isAlpha()));
        this.field_70714_bg.func_75776_a(4, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.4f));
        this.field_70714_bg.func_75776_a(5, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowOwnerWithoutSaddleGoal(this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.4));
        this.field_70714_bg.func_75776_a(9, (Goal)new BegGoal(this, 8.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 0, false, false, target -> !this.func_70909_n()));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, UndeadBaseEntity.class, 10, false, false, target -> !this.func_70909_n()));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(4, (Goal)new NonTamedTargetGoal((TameableEntity)this, AnimalEntity.class, false, entity -> entity instanceof SheepEntity || entity instanceof RabbitEntity || entity instanceof FoxEntity));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractSkeletonEntity.class, 10, false, false, target -> !this.func_70909_n()));
    }

    @Nullable
    public ILivingEntityData func_213386_a(@Nonnull IWorld world, @Nonnull DifficultyInstance difficulty, @Nonnull SpawnReason spawnReason, @Nullable ILivingEntityData livingdata, @Nullable CompoundNBT nbt) {
        livingdata = super.func_213386_a(world, difficulty, spawnReason, livingdata, nbt);
        if (this.field_70146_Z.nextDouble() <= 0.25 && System.currentTimeMillis() > lastAlphaTime + 100L) {
            this.setVariant(1);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.getWolfMaxHealth());
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.getWolfAttack());
            this.func_70606_j(this.getWolfMaxHealth());
            this.field_70728_aV = 12;
            lastAlphaTime = System.currentTimeMillis();
            this.field_70911_d = null;
        } else {
            this.setVariant(0);
        }
        return livingdata;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(JUMP_STRENGTH);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.getWolfMaxHealth());
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(this.getWolfAttack());
    }

    public void func_70624_b(@Nullable LivingEntity livingBase) {
        super.func_70624_b(livingBase);
        if (livingBase == null) {
            this.setAngry(false);
        } else if (!this.func_70909_n()) {
            this.setAngry(true);
        }
    }

    protected void func_70619_bc() {
        this.field_70180_af.func_187227_b(DATA_HEALTH_ID, (Object)Float.valueOf(this.func_110143_aJ()));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_HEALTH_ID, (Object)Float.valueOf(this.func_110143_aJ()));
        this.field_70180_af.func_187214_a(BEGGING, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(COLLAR_COLOR, (Object)DyeColor.GREEN.func_196059_a());
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(SADDLED, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(ARMOR_STACK, (Object)ItemStack.field_190927_a);
    }

    public static boolean canSpawn(EntityType<? extends DesertWolfEntity> animal, IWorld world, SpawnReason spawnReason, BlockPos pos, Random random) {
        return pos.func_177956_o() > 62 && world.func_201672_e().func_82736_K().func_223586_b(GameRules.field_223601_d) && world.func_175710_j(pos) && AtumEntities.canAnimalSpawn(animal, world, spawnReason, pos, random);
    }

    protected void func_180429_a(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.15f, 1.0f);
    }

    protected SoundEvent func_184639_G() {
        if (this.isAngry()) {
            return SoundEvents.field_187861_gG;
        }
        if (this.field_70146_Z.nextInt(3) == 0) {
            return this.func_70909_n() && ((Float)this.field_70180_af.func_187225_a(DATA_HEALTH_ID)).floatValue() < 10.0f ? SoundEvents.field_187871_gL : SoundEvents.field_187865_gI;
        }
        return SoundEvents.field_187857_gE;
    }

    protected SoundEvent func_184601_bQ(@Nonnull DamageSource damageSource) {
        return SoundEvents.field_187863_gH;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187859_gF;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    @Nonnull
    protected ResourceLocation func_184647_J() {
        if (this.isAlpha()) {
            return AtumLootTables.DESERT_WOLF_ALPHA;
        }
        return AtumLootTables.DESERT_WOLF;
    }

    public void func_70645_a(@Nonnull DamageSource cause) {
        this.isWet = false;
        this.isShaking = false;
        this.prevTimeWolfIsShaking = 0.0f;
        this.timeWolfIsShaking = 0.0f;
        if (!this.field_70170_p.field_72995_K && this.desertWolfInventory != null) {
            for (int i = 0; i < this.desertWolfInventory.func_70302_i_(); ++i) {
                ItemStack slotStack = this.desertWolfInventory.func_70301_a(i);
                if (slotStack.func_190926_b()) continue;
                this.func_70099_a(slotStack, 0.0f);
            }
        }
        super.func_70645_a(cause);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.isWet && !this.isShaking && !this.func_70781_l() && this.field_70122_E) {
            this.isShaking = true;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
            this.field_70170_p.func_72960_a((Entity)this, (byte)8);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70180_af.func_187223_a()) {
            this.field_70180_af.func_187230_e();
            this.texturePath = null;
        }
        this.headRotationCourseWild = this.headRotationCourse;
        if (this.angryTimer > 0) {
            this.setAngry(false);
            if (this.func_70638_az() instanceof PlayerEntity) {
                this.func_70624_b(null);
                this.func_70604_c(null);
            }
            if (!this.isAngry()) {
                --this.angryTimer;
            }
            if (this.func_70909_n()) {
                this.angryTimer = 0;
            }
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL && !this.func_70909_n()) {
            this.func_70106_y();
        }
        this.headRotationCourse = this.isBegging() ? (this.headRotationCourse += (1.0f - this.headRotationCourse) * 0.4f) : (this.headRotationCourse += (0.0f - this.headRotationCourse) * 0.4f);
        if (this.func_70026_G()) {
            this.isWet = true;
            this.isShaking = false;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
        } else if ((this.isWet || this.isShaking) && this.isShaking) {
            if (this.timeWolfIsShaking == 0.0f) {
                this.func_184185_a(SoundEvents.field_187867_gJ, this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
            this.prevTimeWolfIsShaking = this.timeWolfIsShaking;
            this.timeWolfIsShaking += 0.05f;
            if (this.prevTimeWolfIsShaking >= 2.0f) {
                this.isWet = false;
                this.isShaking = false;
                this.prevTimeWolfIsShaking = 0.0f;
                this.timeWolfIsShaking = 0.0f;
            }
            if (this.timeWolfIsShaking > 0.4f) {
                float y = (float)this.func_174813_aQ().field_72338_b;
                int shakingTime = (int)(MathHelper.func_76126_a((float)((this.timeWolfIsShaking - 0.4f) * (float)Math.PI)) * 7.0f);
                Vec3d motion = this.func_213322_ci();
                for (int j = 0; j < shakingTime; ++j) {
                    float f1 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.func_213311_cf() * 0.5f;
                    float f2 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.func_213311_cf() * 0.5f;
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218422_X, this.func_226277_ct_() + (double)f1, (double)(y + 0.8f), this.func_226281_cx_() + (double)f2, motion.field_72450_a, motion.field_72448_b, motion.field_72449_c);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getTexture() {
        if (this.texturePath == null) {
            this.texturePath = this.isAngry() ? "angry" : "tamed";
            ItemStack armor = this.getArmor();
            if (!armor.func_190926_b()) {
                ArmorType armorType = ArmorType.getByItemStack(armor);
                this.texturePath = this.texturePath + "_" + armorType.getName();
            }
            if (this.isSaddled()) {
                this.texturePath = this.texturePath + "_saddled";
            }
        }
        return this.texturePath;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isWolfWet() {
        return this.isWet;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShadingWhileWet(float shading) {
        return 0.75f + (this.prevTimeWolfIsShaking + (this.timeWolfIsShaking - this.prevTimeWolfIsShaking) * shading) / 2.0f * 0.25f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShakeAngle(float p_70923_1_, float p_70923_2_) {
        float f = (this.prevTimeWolfIsShaking + (this.timeWolfIsShaking - this.prevTimeWolfIsShaking) * p_70923_1_ + p_70923_2_) / 1.8f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return MathHelper.func_76126_a((float)(f * (float)Math.PI)) * MathHelper.func_76126_a((float)(f * (float)Math.PI * 11.0f)) * 0.15f * (float)Math.PI;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getInterestedAngle(float angle) {
        return (this.headRotationCourseWild + (this.headRotationCourse - this.headRotationCourseWild) * angle) * 0.15f * (float)Math.PI;
    }

    protected float func_213348_b(@Nonnull Pose pose, EntitySize size) {
        return size.field_220316_b * 0.8f;
    }

    public float func_213355_cm() {
        return this.isAlpha() ? 1.6f : super.func_213355_cm();
    }

    public int func_70646_bf() {
        return this.func_70906_o() ? 20 : super.func_70646_bf();
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (this.field_70911_d != null) {
            this.field_70911_d.func_75270_a(false);
        }
        if (entity != null && !(entity instanceof PlayerEntity) && !(entity instanceof ArrowEntity)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(@Nonnull Entity entity) {
        boolean shouldAttack = entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (shouldAttack) {
            this.func_174815_a((LivingEntity)this, entity);
        }
        return shouldAttack;
    }

    public void func_70903_f(boolean tamed) {
        super.func_70903_f(tamed);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.getWolfMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.getWolfAttack());
    }

    public boolean func_184645_a(PlayerEntity player, @Nonnull Hand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        Item item = heldStack.func_77973_b();
        if (this.func_70909_n()) {
            if (!heldStack.func_190926_b()) {
                boolean holdsSaddle;
                DyeColor color;
                if (item.func_219971_r()) {
                    if (item.func_219967_s() != null && item.func_219967_s().func_221467_c() && ((Float)this.field_70180_af.func_187225_a(DATA_HEALTH_ID)).floatValue() < this.func_110138_aP()) {
                        if (!player.field_71075_bZ.field_75098_d) {
                            heldStack.func_190918_g(1);
                        }
                        this.func_70691_i(item.func_219967_s().func_221466_a());
                        return true;
                    }
                } else if (heldStack.func_77973_b() instanceof DyeItem && (color = ((DyeItem)item).func_195962_g()) != this.getCollarColor()) {
                    this.setCollarColor(color);
                    if (!player.field_71075_bZ.field_75098_d) {
                        heldStack.func_190918_g(1);
                    }
                    return true;
                }
                boolean holdsArmor = ArmorType.isArmor(heldStack);
                boolean bl = holdsSaddle = !this.func_70631_g_() && !this.isSaddled() && heldStack.func_77973_b() instanceof SaddleItem;
                if (holdsArmor || holdsSaddle) {
                    this.openGUI(player);
                    return true;
                }
            }
            if (!this.func_70631_g_()) {
                if (player.func_213453_ef()) {
                    this.openGUI(player);
                    return true;
                }
                if (this.func_184207_aI()) {
                    return super.func_184645_a(player, hand);
                }
            }
            if (!(this.field_70170_p.field_72995_K || this.func_70877_b(heldStack) && !(this.func_110143_aJ() >= this.func_110138_aP()))) {
                if (this.isAlpha() && !this.func_184207_aI()) {
                    this.mountTo(player);
                    return true;
                }
                if (!this.isAlpha() && this.func_152114_e((LivingEntity)player)) {
                    this.field_70911_d.func_75270_a(!this.func_70906_o());
                    this.field_70703_bu = false;
                    this.field_70699_by.func_75499_g();
                    this.func_70624_b(null);
                    return true;
                }
            }
        } else if (heldStack.func_77973_b().func_206844_a(Tags.Items.BONES) || heldStack.func_77973_b() == Items.field_179558_bo || heldStack.func_77973_b() == Items.field_179559_bp) {
            if (!player.field_71075_bZ.field_75098_d) {
                heldStack.func_190918_g(1);
            }
            if (this.isAngry() && !this.field_70170_p.field_72995_K) {
                this.angryTimer = this.isAlpha() && this.field_70146_Z.nextDouble() <= 0.5 || !this.isAlpha() ? 200 : 0;
            } else if (!this.isAngry() && this.angryTimer > 0 && !this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(2) == 0 && !ForgeEventFactory.onAnimalTame((AnimalEntity)this, (PlayerEntity)player)) {
                    this.func_193101_c(player);
                    this.field_70699_by.func_75499_g();
                    this.func_70624_b(null);
                    if (!this.isAlpha()) {
                        this.field_70911_d.func_75270_a(true);
                    }
                    this.func_70606_j(40.0f);
                    this.func_70908_e(true);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.func_70908_e(false);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return true;
        }
        return this.func_70909_n() && super.func_184645_a(player, hand);
    }

    public boolean func_70906_o() {
        if (this.isAlpha()) {
            return false;
        }
        return super.func_70906_o();
    }

    protected boolean func_70610_aX() {
        return super.func_70610_aX() && this.func_184207_aI() && this.isSaddled();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void openInventoryOverride(GuiOpenEvent event) {
        ClientPlayerEntity player;
        if (event.getGui() instanceof ContainerScreen && (player = Minecraft.func_71410_x().field_71439_g) != null && player.func_184187_bx() instanceof DesertWolfEntity) {
            DesertWolfEntity desertWolf = (DesertWolfEntity)player.func_184187_bx();
            if (player.func_110124_au() == player.func_110124_au() && desertWolf.isAlpha() && desertWolf.func_184207_aI()) {
                NetworkHandler.sendToServer(new OpenWolfGuiPacket(desertWolf.func_145782_y()));
                event.setCanceled(true);
            }
        }
    }

    private void openGUI(PlayerEntity player) {
        if (!this.field_70170_p.field_72995_K && (!this.func_184207_aI() || this.func_184196_w((Entity)player)) && this.func_70909_n() && player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, buf -> buf.writeInt(this.func_145782_y()));
        }
    }

    public Inventory getInventory() {
        return this.desertWolfInventory;
    }

    private void initInventory() {
        Inventory inventory = this.desertWolfInventory;
        this.desertWolfInventory = new Inventory(2);
        if (inventory != null) {
            inventory.func_110132_b((IInventoryChangedListener)this);
            for (int j = 0; j < 2; ++j) {
                ItemStack slotStack = inventory.func_70301_a(j);
                if (slotStack.func_190926_b()) continue;
                this.desertWolfInventory.func_70299_a(j, slotStack.func_77946_l());
            }
        }
        this.desertWolfInventory.func_110134_a((IInventoryChangedListener)this);
        this.updateSlots();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((IInventory)this.desertWolfInventory));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 8) {
            this.isShaking = true;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
        } else {
            super.func_70103_a(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getTailRotation() {
        if (this.isAngry()) {
            return 1.5393804f;
        }
        if (!this.func_184207_aI()) {
            return this.func_70909_n() ? (0.55f - (this.func_110138_aP() - ((Float)this.field_70180_af.func_187225_a(DATA_HEALTH_ID)).floatValue()) * 0.02f) * (float)Math.PI : 0.62831855f;
        }
        return 1.5f;
    }

    public boolean func_70877_b(@Nonnull ItemStack stack) {
        Item item = stack.func_77973_b();
        return item.func_219971_r() && item.func_219967_s() != null && item.func_219967_s().func_221467_c();
    }

    public int func_70641_bl() {
        return 6;
    }

    public boolean isAngry() {
        return ((Byte)this.field_70180_af.func_187225_a(field_184755_bv) & 2) != 0;
    }

    private void setAngry(boolean angry) {
        byte tamed = (Byte)this.field_70180_af.func_187225_a(field_184755_bv);
        if (angry) {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(tamed | 2)));
        } else {
            this.field_70180_af.func_187227_b(field_184755_bv, (Object)((byte)(tamed & 0xFFFFFFFD)));
        }
    }

    public DyeColor getCollarColor() {
        return DyeColor.func_196056_a((int)((Integer)this.field_70180_af.func_187225_a(COLLAR_COLOR)));
    }

    private void setCollarColor(DyeColor color) {
        this.field_70180_af.func_187227_b(COLLAR_COLOR, (Object)color.func_196059_a());
    }

    public boolean isSaddled() {
        return (Boolean)this.field_70180_af.func_187225_a(SADDLED);
    }

    private void setSaddled(boolean saddled) {
        if (saddled) {
            this.field_70180_af.func_187227_b(SADDLED, (Object)Boolean.TRUE);
        } else {
            this.field_70180_af.func_187227_b(SADDLED, (Object)Boolean.FALSE);
        }
    }

    public DesertWolfEntity createChild(@Nonnull AgeableEntity ageable) {
        DesertWolfEntity desertWolf = (DesertWolfEntity)AtumEntities.DESERT_WOLF.func_200721_a(this.field_70170_p);
        if (desertWolf != null) {
            UUID uuid = this.func_184753_b();
            if (uuid != null) {
                desertWolf.func_184754_b(uuid);
                desertWolf.func_70903_f(true);
                desertWolf.setAngry(false);
                desertWolf.func_70691_i(8.0f);
            }
            return desertWolf;
        }
        return null;
    }

    public void setBegging(boolean beg) {
        this.field_70180_af.func_187227_b(BEGGING, (Object)beg);
    }

    private boolean isBegging() {
        return (Boolean)this.field_70180_af.func_187225_a(BEGGING);
    }

    public boolean func_70878_b(@Nonnull AnimalEntity otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!this.func_70909_n()) {
            return false;
        }
        if (!(otherAnimal instanceof DesertWolfEntity)) {
            return false;
        }
        DesertWolfEntity desertWolf = (DesertWolfEntity)otherAnimal;
        if (!desertWolf.func_70909_n()) {
            return false;
        }
        if (desertWolf.func_70906_o()) {
            return false;
        }
        return this.func_70880_s() && desertWolf.func_70880_s();
    }

    public boolean func_142018_a(@Nonnull LivingEntity target, @Nonnull LivingEntity owner) {
        if (!(target instanceof CreeperEntity) && !(target instanceof GhastEntity)) {
            DesertWolfEntity desertWolf;
            if (target instanceof DesertWolfEntity && (desertWolf = (DesertWolfEntity)target).func_70909_n() && desertWolf.func_70902_q() == owner) {
                return false;
            }
            if (target instanceof PlayerEntity && owner instanceof PlayerEntity && !((PlayerEntity)owner).func_96122_a((PlayerEntity)target)) {
                return false;
            }
            if (target instanceof AbstractHorseEntity && ((AbstractHorseEntity)target).func_110248_bS()) {
                return false;
            }
            return !(target instanceof CatEntity) || !((CatEntity)target).func_70909_n();
        }
        return false;
    }

    @SubscribeEvent
    public void onTarget(LivingSetAttackTargetEvent event) {
        if (event.getTarget() instanceof DesertWolfEntity && event.getEntityLiving() instanceof DesertWolfEntity && ((DesertWolfEntity)event.getTarget()).func_70909_n() && ((DesertWolfEntity)event.getEntityLiving()).func_70909_n()) {
            ((DesertWolfEntity)event.getEntityLiving()).func_70624_b(null);
        }
    }

    public boolean func_184652_a(@Nonnull PlayerEntity player) {
        return !this.isAngry() && super.func_184652_a(player);
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("Variant", this.getVariant());
        super.func_213281_b(compound);
        compound.func_74757_a("Angry", this.isAngry());
        compound.func_74774_a("CollarColor", (byte)this.getCollarColor().func_196059_a());
        compound.func_74757_a("Saddle", this.isSaddled());
        if (this.angryTimer > 0) {
            compound.func_74768_a("AngryTimer", this.angryTimer);
        }
        if (!this.desertWolfInventory.func_70301_a(0).func_190926_b()) {
            compound.func_218657_a("SaddleItem", (INBT)this.desertWolfInventory.func_70301_a(0).func_77955_b(new CompoundNBT()));
        }
        if (!this.desertWolfInventory.func_70301_a(1).func_190926_b()) {
            compound.func_218657_a("ArmorItem", (INBT)this.desertWolfInventory.func_70301_a(1).func_77955_b(new CompoundNBT()));
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        ItemStack armorStack;
        ItemStack saddleStack;
        this.setVariant(compound.func_74762_e("Variant"));
        super.func_70037_a(compound);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.getWolfMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.getWolfAttack());
        this.setAngry(compound.func_74767_n("Angry"));
        this.setSaddled(compound.func_74767_n("Saddle"));
        this.angryTimer = compound.func_74762_e("AngryTimer");
        if (compound.func_150297_b("CollarColor", 99)) {
            this.setCollarColor(DyeColor.func_196056_a((int)compound.func_74762_e("CollarColor")));
        }
        if (compound.func_150297_b("SaddleItem", 10) && (saddleStack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("SaddleItem"))).func_77973_b() instanceof SaddleItem) {
            this.desertWolfInventory.func_70299_a(0, saddleStack);
        }
        if (compound.func_150297_b("ArmorItem", 10) && !(armorStack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("ArmorItem"))).func_190926_b() && this.isArmor(armorStack)) {
            this.desertWolfInventory.func_70299_a(1, armorStack);
        }
        this.updateSlots();
    }

    private void updateSlots() {
        this.setArmorStack(this.desertWolfInventory.func_70301_a(1));
        if (!this.field_70170_p.field_72995_K) {
            this.setSaddled(!this.desertWolfInventory.func_70301_a(0).func_190926_b());
        }
    }

    private void setArmorStack(@Nonnull ItemStack stack) {
        ArmorType armorType = ArmorType.getByItemStack(stack);
        this.field_70180_af.func_187227_b(ARMOR_STACK, (Object)stack);
        if (!this.field_70170_p.field_72995_K) {
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_188479_b(ARMOR_MODIFIER_UUID);
            int protection = armorType.getProtection();
            if (protection != 0) {
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111121_a(new AttributeModifier(ARMOR_MODIFIER_UUID, "Desert wolf armor bonus", (double)protection, AttributeModifier.Operation.ADDITION).func_111168_a(false));
            }
        }
    }

    @Nonnull
    public ItemStack getArmor() {
        return (ItemStack)this.field_70180_af.func_187225_a(ARMOR_STACK);
    }

    public void func_76316_a(@Nonnull IInventory invBasic) {
        this.updateSlots();
    }

    public boolean func_174820_d(int inventorySlot, @Nonnull ItemStack stack) {
        int slot = inventorySlot - 400;
        if (slot >= 0 && slot < 2 && slot < this.desertWolfInventory.func_70302_i_()) {
            if (slot == 0 && !(stack.func_77973_b() instanceof SaddleItem)) {
                return false;
            }
            if (slot != 1 || this.isArmor(stack)) {
                this.desertWolfInventory.func_70299_a(slot, stack);
                this.updateSlots();
                return true;
            }
            return false;
        }
        return false;
    }

    private void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
        this.texturePath = null;
    }

    private int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean func_82171_bF() {
        return true;
    }

    public double func_70042_X() {
        return super.func_70042_X() + 0.07;
    }

    public void func_184232_k(@Nonnull Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float cos = MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180)));
            float sin = MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180)));
            passenger.func_70107_b(this.func_226277_ct_() + (double)(0.4f * sin), this.func_226278_cu_() + this.func_70042_X() + passenger.func_70033_W(), this.func_226281_cx_() - (double)(0.4f * cos));
        }
    }

    private void mountTo(PlayerEntity player) {
        player.field_70177_z = this.field_70177_z;
        player.field_70125_A = this.field_70125_A;
        if (!this.field_70170_p.field_72995_K) {
            player.func_184220_m((Entity)this);
        }
    }

    public void func_213352_e(@Nonnull Vec3d travelVec) {
        if (this.func_70089_S()) {
            if (this.func_184207_aI() && this.func_82171_bF() && this.isSaddled()) {
                LivingEntity livingBase = (LivingEntity)this.func_184179_bs();
                if (livingBase != null) {
                    this.field_70126_B = this.field_70177_z = livingBase.field_70177_z;
                    this.field_70125_A = livingBase.field_70125_A * 0.5f;
                    this.func_70101_b(this.field_70177_z, this.field_70125_A);
                    this.field_70759_as = this.field_70761_aq = this.field_70177_z;
                    float strafe = livingBase.field_70702_br * 0.5f;
                    float forward = livingBase.field_191988_bg;
                    if (forward <= 0.0f) {
                        forward *= 0.25f;
                    }
                    if (this.jumpPower > 0.0f && !this.isJumping() && this.field_70122_E) {
                        EffectInstance jumpBoost;
                        double wolfJumpStrength = this.getWolfJumpStrength() * (double)this.jumpPower;
                        double jumpY = this.func_70644_a(Effects.field_76430_j) ? wolfJumpStrength + ((jumpBoost = this.func_70660_b(Effects.field_76430_j)) != null ? (double)((float)(jumpBoost.func_76458_c() + 1) * 0.1f) : 0.0) : wolfJumpStrength;
                        Vec3d motion = this.func_213322_ci();
                        this.func_213293_j(motion.field_72450_a, jumpY, motion.field_72449_c);
                        this.setWolfJumping(true);
                        this.field_70160_al = true;
                        if (forward > 0.0f) {
                            float f2 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                            float f3 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                            this.func_213317_d(this.func_213322_ci().func_72441_c((double)(-0.4f * f2 * this.jumpPower), 0.0, (double)(0.4f * f3 * this.jumpPower)));
                            this.func_184185_a(SoundEvents.field_187720_cs, 0.4f, 1.0f);
                        }
                        this.jumpPower = 0.0f;
                    }
                    this.field_70747_aH = this.func_70689_ay() * 0.1f;
                    if (this.func_184186_bw()) {
                        this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 0.8f);
                        super.func_213352_e(new Vec3d((double)strafe, travelVec.field_72448_b, (double)forward));
                    } else if (livingBase instanceof PlayerEntity) {
                        this.func_213317_d(Vec3d.field_186680_a);
                    }
                    if (this.field_70122_E) {
                        this.jumpPower = 0.0f;
                        this.setWolfJumping(false);
                    }
                }
            } else {
                this.field_70747_aH = 0.02f;
                super.func_213352_e(travelVec);
            }
        }
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        if (this.isAlpha() && distance > 5.0f) {
            return super.func_225503_b_(distance, damageMultiplier);
        }
        if (!this.isAlpha() && distance > 2.5f) {
            return super.func_225503_b_(distance, damageMultiplier);
        }
        return false;
    }

    private boolean isJumping() {
        return this.isWolfJumping;
    }

    private void setWolfJumping(boolean jumping) {
        this.isWolfJumping = jumping;
    }

    private double getWolfJumpStrength() {
        return this.func_110148_a(JUMP_STRENGTH).func_111126_e();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_110206_u(int jumpPower) {
        if (this.isAlpha()) {
            if (jumpPower < 0) {
                jumpPower = 0;
            }
            this.jumpPower = jumpPower >= 90 ? 1.0f : 0.4f + 0.4f * (float)jumpPower / 90.0f;
        }
    }

    public boolean func_184776_b() {
        return this.isSaddled();
    }

    public void func_184775_b(int jumpPower) {
    }

    public void func_184777_r_() {
    }

    public boolean isAlpha() {
        return this.getVariant() == 1;
    }

    private float getWolfMaxHealth() {
        if (this.func_70909_n()) {
            if (this.isAlpha()) {
                return 36.0f;
            }
            return 20.0f;
        }
        if (this.isAlpha()) {
            return 24.0f;
        }
        return 12.0f;
    }

    private double getWolfAttack() {
        if (this.isAlpha()) {
            return 8.0;
        }
        return 4.0;
    }

    public boolean isArmor(@Nonnull ItemStack stack) {
        return ArmorType.isArmor(stack);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (this.func_70089_S() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.itemHandler != null) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Nullable
    public Container createMenu(int windowID, @Nonnull PlayerInventory playerInventory, @Nonnull PlayerEntity player) {
        return new AlphaDesertWolfContainer(windowID, playerInventory, this.func_145782_y());
    }

    public static enum ArmorType {
        NONE(0),
        IRON(5, "iron"),
        GOLD(7, "gold"),
        DIAMOND(11, "diamond");

        private final String textureName;
        private final String typeName;
        private final int protection;

        private ArmorType(int armorStrength) {
            this.protection = armorStrength;
            this.typeName = null;
            this.textureName = null;
        }

        private ArmorType(int armorStrength, String typeName) {
            this.protection = armorStrength;
            this.typeName = typeName;
            this.textureName = new ResourceLocation("atum", "textures/entity/armor/desert_wolf_armor_" + typeName + ".png").toString();
        }

        public int getProtection() {
            return this.protection;
        }

        public String getName() {
            return this.typeName;
        }

        public String getTextureName() {
            return this.textureName;
        }

        public static ArmorType getByItemStack(@Nonnull ItemStack stack) {
            Item item = stack.func_77973_b();
            if (item == AtumItems.DESERT_WOLF_IRON_ARMOR) {
                return IRON;
            }
            if (item == AtumItems.DESERT_WOLF_GOLD_ARMOR) {
                return GOLD;
            }
            if (item == AtumItems.DESERT_WOLF_DIAMOND_ARMOR) {
                return DIAMOND;
            }
            return NONE;
        }

        public static boolean isArmor(@Nonnull ItemStack stack) {
            return ArmorType.getByItemStack(stack) != NONE;
        }
    }
}

