/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.entity.stone;

import com.teammetallurgy.atum.entity.bandit.BanditBaseEntity;
import com.teammetallurgy.atum.entity.undead.UndeadBaseEntity;
import com.teammetallurgy.atum.init.AtumItems;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;

public class StoneBaseEntity
extends MonsterEntity {
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(StoneBaseEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Byte> PLAYER_CREATED = EntityDataManager.func_187226_a(StoneBaseEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private int homeCheckTimer;

    public StoneBaseEntity(EntityType<? extends StoneBaseEntity> entityType, World world) {
        super(entityType, world);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(4, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.applyEntityAI();
    }

    private void applyEntityAI() {
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, input -> !this.isPlayerCreated()));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, StoneBaseEntity.class, 10, true, false, input -> input instanceof StoneBaseEntity && (!((StoneBaseEntity)((Object)input)).isPlayerCreated() && this.isPlayerCreated() || ((StoneBaseEntity)((Object)input)).isPlayerCreated() && !this.isPlayerCreated())));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, UndeadBaseEntity.class, true));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, BanditBaseEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MonsterEntity.class, 10, true, false, input -> input != null && this.isPlayerCreated() && !(input instanceof StoneBaseEntity) && input.func_70668_bt() == CreatureAttribute.field_223223_b_));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.15);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    void setFriendlyAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(24.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(PLAYER_CREATED, (Object)0);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld world, DifficultyInstance difficulty, SpawnReason spawnReason, @Nullable ILivingEntityData livingdata, @Nullable CompoundNBT nbt) {
        if (this.isPlayerCreated()) {
            this.setFriendlyAttributes();
        }
        return super.func_213386_a(world, difficulty, spawnReason, livingdata, nbt);
    }

    void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70180_af.func_187223_a()) {
            this.field_70180_af.func_187230_e();
        }
    }

    public void func_70106_y() {
        if (this.field_70170_p.field_72995_K || !this.isPlayerCreated() || this.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL) {
            super.func_70106_y();
        }
    }

    protected void func_70619_bc() {
        if (--this.homeCheckTimer <= 0) {
            this.homeCheckTimer = 70 + this.field_70146_Z.nextInt(50);
            if (!this.func_213394_dL()) {
                this.func_213390_a(new BlockPos((Entity)this), 16);
            }
        }
        super.func_70619_bc();
    }

    protected boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        if (heldStack.func_77973_b() == AtumItems.KHNUMITE) {
            if (!player.field_71075_bZ.field_75098_d) {
                heldStack.func_190918_g(1);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_70691_i(5.0f);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public boolean func_70687_e(@Nonnull EffectInstance potionEffect) {
        return potionEffect.func_188419_a() != Effects.field_76436_u && super.func_70687_e(potionEffect);
    }

    public void func_70653_a(@Nonnull Entity entity, float strength, double xRatio, double zRatio) {
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return !this.isPlayerCreated();
    }

    protected int func_70682_h(int air) {
        return air;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187902_gb;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187843_fX;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187835_fT;
    }

    @Nonnull
    protected SoundEvent func_184588_d(int height) {
        return height > 4 ? SoundEvents.field_187735_cx : SoundEvents.field_187841_fW;
    }

    public int func_70627_aG() {
        return 120;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_180429_a(@Nonnull BlockPos pos, BlockState state) {
        this.func_184185_a(SoundEvents.field_187902_gb, 0.15f, 1.0f);
    }

    public static boolean isValidLightLevel(IWorld world, @Nonnull BlockPos pos, Random random) {
        return world.func_226658_a_(LightType.SKY, pos) == 0 && world.func_201696_r(pos) <= random.nextInt(10);
    }

    public static boolean canSpawn(EntityType<? extends StoneBaseEntity> stoneBase, IWorld world, SpawnReason spawnReason, BlockPos pos, Random random) {
        return StoneBaseEntity.isValidLightLevel(world, pos, random) && StoneBaseEntity.func_223324_d(stoneBase, (IWorld)world, (SpawnReason)spawnReason, (BlockPos)pos, (Random)random);
    }

    boolean isPlayerCreated() {
        return ((Byte)this.field_70180_af.func_187225_a(PLAYER_CREATED) & 1) != 0;
    }

    public void setPlayerCreated(boolean playerCreated) {
        byte b = (Byte)this.field_70180_af.func_187225_a(PLAYER_CREATED);
        if (playerCreated) {
            this.field_70180_af.func_187227_b(PLAYER_CREATED, (Object)((byte)(b | 1)));
        } else {
            this.field_70180_af.func_187227_b(PLAYER_CREATED, (Object)((byte)(b & 0xFFFFFFFE)));
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
        compound.func_74757_a("PlayerCreated", this.isPlayerCreated());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
        this.setPlayerCreated(compound.func_74767_n("PlayerCreated"));
    }
}

