/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.entity.undead;

import com.google.common.collect.Maps;
import com.teammetallurgy.atum.Atum;
import com.teammetallurgy.atum.blocks.stone.limestone.chest.tileentity.SarcophagusTileEntity;
import com.teammetallurgy.atum.entity.ai.goal.OpenAnyDoorGoal;
import com.teammetallurgy.atum.entity.undead.MummyEntity;
import com.teammetallurgy.atum.entity.undead.UndeadBaseEntity;
import com.teammetallurgy.atum.init.AtumEffects;
import com.teammetallurgy.atum.init.AtumEntities;
import com.teammetallurgy.atum.items.artifacts.horus.HorusAscensionItem;
import com.teammetallurgy.atum.items.tools.ScepterItem;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class PharaohEntity
extends UndeadBaseEntity {
    private static final String[] PREFIXES = new String[]{"Ama", "Ata", "Ato", "Bak", "Cal", "Djet", "Eje", "For", "Gol", "Gut", "Hop", "Hor", "Huni", "Iam", "Jor", "Kal", "Khas", "Khor", "Lat", "Mal", "Not", "Oap", "Pra", "Qo", "Ras", "Shas", "Thoth", "Tui", "Uld", "Ver", "Wot", "Xo", "Yat", "Zyt", "Khep"};
    private static final String[] SUFFIXES = new String[]{"Ahat", "Amesh", "Amon", "Anut", "Baroom", "Chanta", "Erant", "Funam", "Daresh", "Djer", "Hotesh", "Khaden", "Kron", "Gorkum", "Ialenter", "Ma'at", "Narmer", "Radeem", "Jaloom", "Lepsha", "Quor", "Oleshet", "Peput", "Talat", "Ulam", "Veresh", "Ranesh", "Snef", "Wollolo", "Hathor", "Intef", "Neferk", "Khatne", "Tepy", "Moret"};
    private static final String[] NUMERALS = new String[]{"I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X", "XI", "XII", "XIII", "XIV", "XV"};
    private static final DataParameter<Integer> PREFIX = EntityDataManager.func_187226_a(PharaohEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SUFFIX = EntityDataManager.func_187226_a(PharaohEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> NUMERAL = EntityDataManager.func_187226_a(PharaohEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Optional<BlockPos>> SARCOPHAGUS_POS = EntityDataManager.func_187226_a(PharaohEntity.class, (IDataSerializer)DataSerializers.field_187201_k);
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.YELLOW, BossInfo.Overlay.NOTCHED_10).func_186743_c(true);
    private int stage;
    private int suffixID = 0;
    private int prefixID = 0;
    private int numID = 0;
    private int regenTime = 0;
    private int berserkTimer;
    private float berserkDamage;
    private String texturePath;

    public PharaohEntity(EntityType<? extends PharaohEntity> entityType, World world) {
        super(entityType, world);
        this.func_70606_j(this.func_110138_aP());
        this.field_70728_aV = 250;
        this.stage = 0;
        this.func_98053_h(false);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    protected boolean hasSkinVariants() {
        return true;
    }

    @Override
    protected int getVariantAmount() {
        return God.values().length - 1;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new OpenAnyDoorGoal((MobEntity)this, false));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
    }

    @Override
    protected void func_175456_n() {
        super.func_175456_n();
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(300.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(36.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(10.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PREFIX, (Object)0);
        this.field_70180_af.func_187214_a(SUFFIX, (Object)0);
        this.field_70180_af.func_187214_a(NUMERAL, (Object)0);
        this.field_70180_af.func_187214_a(SARCOPHAGUS_POS, Optional.empty());
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_191268_hm;
    }

    @Override
    protected boolean shouldBurnInDay() {
        return false;
    }

    protected void func_180481_a(@Nonnull DifficultyInstance difficulty) {
        ScepterItem scepter = ScepterItem.getScepter(God.getGod(this.getVariant()));
        if (scepter != null) {
            this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)scepter));
        }
    }

    public boolean func_98052_bS() {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getTexture() {
        if (this.texturePath == null) {
            this.texturePath = new ResourceLocation("atum", "textures/entity/pharaoh_" + God.getGod(this.getVariant()).getName()) + ".png";
        }
        return this.texturePath;
    }

    @Override
    protected void setVariant(int variant) {
        super.setVariant(variant);
        this.texturePath = null;
    }

    @Override
    protected void setVariantAbilities(DifficultyInstance difficulty, int variant) {
        super.setVariantAbilities(difficulty, variant);
        this.prefixID = this.field_70146_Z.nextInt(PREFIXES.length);
        this.suffixID = this.field_70146_Z.nextInt(SUFFIXES.length);
        this.numID = this.field_70146_Z.nextInt(NUMERALS.length);
        this.setPharaohName(this.prefixID, this.suffixID, this.numID);
        this.func_180481_a(difficulty);
        this.func_180483_b(difficulty);
    }

    private BlockPos getSarcophagusPos() {
        return ((Optional)this.field_70180_af.func_187225_a(SARCOPHAGUS_POS)).orElse(null);
    }

    public void setSarcophagusPos(BlockPos pos) {
        this.field_70180_af.func_187227_b(SARCOPHAGUS_POS, Optional.ofNullable(pos));
    }

    public boolean func_184222_aU() {
        return false;
    }

    public boolean func_213392_I() {
        return true;
    }

    public void func_70645_a(@Nonnull DamageSource source) {
        Entity killer;
        BlockPos sarcophagusPos;
        if (!this.field_70170_p.field_72995_K && (sarcophagusPos = this.getSarcophagusPos()) != null) {
            TileEntity tileEntity = this.field_70170_p.func_175625_s(sarcophagusPos);
            if (tileEntity instanceof SarcophagusTileEntity) {
                ((SarcophagusTileEntity)tileEntity).setOpenable();
                for (Direction horizontal : Direction.Plane.HORIZONTAL) {
                    TileEntity tileEntityOffset = this.field_70170_p.func_175625_s(sarcophagusPos.func_177972_a(horizontal));
                    if (!(tileEntityOffset instanceof SarcophagusTileEntity)) continue;
                    ((SarcophagusTileEntity)tileEntityOffset).setOpenable();
                }
            } else {
                Atum.LOG.error("Unable to find sarcophagus coordinates for " + this.func_200200_C_() + " on " + sarcophagusPos);
            }
        }
        if (source.field_76373_n.equals("player")) {
            PlayerEntity slayer = (PlayerEntity)source.func_76346_g();
            if (!this.field_70170_p.field_72995_K && slayer != null) {
                List players = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v();
                for (PlayerEntity player : players) {
                    player.func_145747_a(this.func_200200_C_().func_150258_a(" ").func_150257_a((ITextComponent)new TranslationTextComponent("chat.atum.kill_pharaoh", new Object[0])).func_150258_a(" " + slayer.func_146103_bH().getName()).func_211709_a(new TextFormatting[]{God.getGod(this.getVariant()).getColor()}));
                }
            }
        }
        if ((killer = source.func_76346_g()) instanceof PlayerEntity) {
            ((PlayerEntity)killer).func_195064_c(new EffectInstance(AtumEffects.MARKED_FOR_DEATH, 2400, 0, false, false, true));
        }
        super.func_70645_a(source);
    }

    public void func_184178_b(@Nonnull ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(@Nonnull ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    @Nonnull
    public ITextComponent func_200200_C_() {
        int p = (Integer)this.field_70180_af.func_187225_a(PREFIX);
        int s = (Integer)this.field_70180_af.func_187225_a(SUFFIX);
        int n = (Integer)this.field_70180_af.func_187225_a(NUMERAL);
        return new TranslationTextComponent(this.func_200600_R().func_210760_d(), new Object[0]).func_150258_a(" ").func_150257_a((ITextComponent)new TranslationTextComponent("entity.atum.pharaoh." + PREFIXES[p], new Object[0])).func_150257_a((ITextComponent)new TranslationTextComponent("entity.atum.pharaoh." + SUFFIXES[s].toLowerCase(Locale.ENGLISH), new Object[0])).func_150258_a(" " + NUMERALS[n]);
    }

    public void func_70653_a(@Nonnull Entity entity, float strength, double xRatio, double zRatio) {
        if (God.getGod(this.getVariant()) != God.PTAH) {
            super.func_70653_a(entity, strength *= 0.2f, xRatio, zRatio);
        }
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        if (super.func_70097_a(source, amount)) {
            if (this.func_110143_aJ() < this.func_110138_aP() * 0.75f && this.stage == 0) {
                ++this.stage;
                this.spawnGuards(this.func_180425_c());
            } else if (this.stage == 1 && this.func_110143_aJ() < this.func_110138_aP() * 0.5f) {
                ++this.stage;
                this.spawnGuards(this.func_180425_c());
            } else if (this.stage == 2 && this.func_110143_aJ() < this.func_110138_aP() * 0.25f) {
                ++this.stage;
                this.spawnGuards(this.func_180425_c());
            }
            return true;
        }
        return false;
    }

    public boolean func_70652_k(@Nonnull Entity entity) {
        if (!super.func_70652_k(entity)) {
            return false;
        }
        if (entity instanceof LivingEntity && !this.field_70170_p.field_72995_K) {
            LivingEntity entityLiving = (LivingEntity)entity;
            switch (God.getGod(this.getVariant())) {
                case ANPUT: {
                    entityLiving.func_195064_c(new EffectInstance(Effects.field_76438_s, 80, 1));
                    break;
                }
                case ANUBIS: {
                    entityLiving.func_195064_c(new EffectInstance(Effects.field_82731_v, 60, 1));
                    break;
                }
                case GEB: {
                    entityLiving.func_195064_c(new EffectInstance(Effects.field_76421_d, 60, 1));
                    break;
                }
                case HORUS: {
                    entityLiving.func_195064_c(new EffectInstance(Effects.field_76419_f, 60, 1));
                    break;
                }
                case NUIT: {
                    entityLiving.func_195064_c(new EffectInstance(Effects.field_76440_q, 60));
                    break;
                }
                case RA: {
                    entityLiving.func_70015_d(4);
                    break;
                }
                case SETH: {
                    entityLiving.func_195064_c(new EffectInstance(Effects.field_76436_u, 100, 1));
                    break;
                }
                case SHU: {
                    HorusAscensionItem.knockUp(entityLiving, (LivingEntity)this, this.field_70146_Z);
                    break;
                }
                case TEFNUT: {
                    entityLiving.func_195064_c(new EffectInstance(Effects.field_76431_k, 60));
                    break;
                }
            }
        }
        return true;
    }

    @SubscribeEvent
    public void onBerserk(LivingHurtEvent event) {
        if (event.getSource().func_76346_g() == this && God.getGod(this.getVariant()) == God.MONTU) {
            if (this.berserkTimer == 0) {
                event.setAmount(event.getAmount());
                this.berserkDamage = event.getAmount() / 10.0f + event.getAmount();
                this.berserkTimer = 80;
            } else {
                this.berserkDamage += event.getAmount() / 10.0f;
                event.setAmount(this.berserkDamage);
                this.berserkTimer = 80;
            }
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setBossInfo(this.getVariant());
        }
        if (this.field_70170_p.func_175659_aa().func_151525_a() == 0) {
            TileEntity te;
            if (this.getSarcophagusPos() != null && (te = this.field_70170_p.func_175625_s(this.getSarcophagusPos())) instanceof SarcophagusTileEntity) {
                ((SarcophagusTileEntity)te).hasSpawned = false;
            }
            this.func_70106_y();
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    @Override
    public void func_70636_d() {
        if (this.regenTime++ > 60) {
            this.regenTime = 0;
            this.func_70691_i(God.getGod(this.getVariant()) == God.ISIS ? 2.0f : 1.0f);
        }
        if (God.getGod(this.getVariant()) == God.MONTU && this.berserkTimer > 1) {
            --this.berserkTimer;
        }
        if (this.berserkTimer == 1) {
            this.berserkDamage = 0.0f;
            this.berserkTimer = 0;
        }
        super.func_70636_d();
    }

    @Override
    public void func_213281_b(@Nonnull CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("prefix", this.prefixID);
        compound.func_74768_a("suffix", this.suffixID);
        compound.func_74768_a("numeral", this.numID);
        BlockPos sarcophagusPos = this.getSarcophagusPos();
        if (sarcophagusPos != null) {
            compound.func_74768_a("sarcophagus_x", sarcophagusPos.func_177958_n());
            compound.func_74768_a("sarcophagus_y", sarcophagusPos.func_177956_o());
            compound.func_74768_a("sarcophagus_z", sarcophagusPos.func_177952_p());
        }
    }

    @Override
    public void func_70037_a(@Nonnull CompoundNBT compound) {
        super.func_70037_a(compound);
        this.prefixID = compound.func_74762_e("prefix");
        this.suffixID = compound.func_74762_e("suffix");
        this.numID = compound.func_74762_e("numeral");
        if (compound.func_74764_b("sarcophagus_x")) {
            int x = compound.func_74762_e("sarcophagus_x");
            int y = compound.func_74762_e("sarcophagus_y");
            int z = compound.func_74762_e("sarcophagus_z");
            this.field_70180_af.func_187227_b(SARCOPHAGUS_POS, Optional.of(new BlockPos(x, y, z)));
        } else {
            this.field_70180_af.func_187227_b(SARCOPHAGUS_POS, Optional.empty());
        }
        this.setPharaohName(compound.func_74762_e("prefix"), compound.func_74762_e("suffix"), compound.func_74762_e("numeral"));
    }

    private void setPharaohName(int prefix, int suffix, int numeral) {
        this.field_70180_af.func_187227_b(PREFIX, (Object)prefix);
        this.field_70180_af.func_187227_b(SUFFIX, (Object)suffix);
        this.field_70180_af.func_187227_b(NUMERAL, (Object)numeral);
    }

    public void spawnGuards(BlockPos pos) {
        Direction facing = Direction.func_176731_b((int)(MathHelper.func_76128_c((double)((double)(this.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3)).func_176734_d();
        this.trySpawnMummy(pos, facing);
        this.trySpawnMummy(pos, facing.func_176746_e().func_176746_e());
    }

    private void trySpawnMummy(BlockPos pos, Direction facing) {
        MummyEntity mummy;
        BlockState state;
        BlockPos base = pos.func_177967_a(facing, 1);
        if (WorldEntitySpawner.func_222266_a((IBlockReader)this.field_70170_p, (BlockPos)base, (BlockState)(state = this.field_70170_p.func_180495_p(pos)), (IFluidState)state.func_204520_s()) && (mummy = (MummyEntity)AtumEntities.MUMMY.func_200721_a(this.field_70170_p)) != null) {
            mummy.func_213386_a((IWorld)this.field_70170_p, this.field_70170_p.func_175649_E(base), SpawnReason.TRIGGERED, null, null);
            mummy.func_70012_b(base.func_177958_n(), base.func_177956_o(), base.func_177952_p(), this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_217376_c((Entity)mummy);
            }
            mummy.func_70656_aK();
            return;
        }
        for (int i = 0; i < 4; ++i) {
            MummyEntity mummy2;
            BlockPos newPos;
            Direction offset = Direction.func_176731_b((int)((5 - i) % 4));
            if (offset == facing.func_176734_d() || !WorldEntitySpawner.func_222266_a((IBlockReader)this.field_70170_p, (BlockPos)base, (BlockState)(state = this.field_70170_p.func_180495_p(newPos = base.func_177972_a(offset))), (IFluidState)state.func_204520_s()) || (mummy2 = (MummyEntity)AtumEntities.MUMMY.func_200721_a(this.field_70170_p)) == null) continue;
            mummy2.func_213386_a((IWorld)this.field_70170_p, this.field_70170_p.func_175649_E(base), SpawnReason.TRIGGERED, null, null);
            mummy2.func_70012_b(newPos.func_177958_n(), newPos.func_177956_o(), newPos.func_177952_p(), this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_217376_c((Entity)mummy2);
            }
            mummy2.func_70656_aK();
            return;
        }
    }

    private void setBossInfo(int variant) {
        this.bossInfo.func_186739_a(this.func_145748_c_().func_150255_a(new Style().func_150238_a(God.getGod(variant).getColor())));
    }

    public static enum God {
        ANPUT("anput", TextFormatting.BLACK),
        ANUBIS("anubis", TextFormatting.DARK_PURPLE),
        ATUM("atum", TextFormatting.DARK_AQUA),
        GEB("geb", TextFormatting.GOLD),
        HORUS("horus", TextFormatting.AQUA),
        ISIS("isis", TextFormatting.LIGHT_PURPLE),
        MONTU("montu", TextFormatting.DARK_RED),
        NUIT("nuit", TextFormatting.GRAY),
        PTAH("ptah", TextFormatting.YELLOW),
        RA("ra", TextFormatting.DARK_RED),
        SETH("seth", TextFormatting.GREEN),
        SHU("shu", TextFormatting.BLUE),
        TEFNUT("tefnut", TextFormatting.DARK_BLUE);

        static Map<Integer, God> MAP;
        private final String name;
        private final TextFormatting color;

        private God(String name, TextFormatting color) {
            this.name = name;
            this.color = color;
        }

        public String getName() {
            return this.name;
        }

        public TextFormatting getColor() {
            return this.color;
        }

        public static God getGod(int godType) {
            God god;
            if (MAP == null) {
                MAP = Maps.newHashMap();
                for (God g : God.values()) {
                    MAP.put(g.ordinal(), g);
                }
            }
            return (god = MAP.get(godType)) == null ? ANPUT : god;
        }
    }
}

