/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.init;

import com.google.common.collect.ImmutableSet;
import com.teammetallurgy.atum.blocks.stone.limestone.LimestoneBlock;
import com.teammetallurgy.atum.blocks.wood.DeadwoodLogBlock;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.misc.AtumConfig;
import com.teammetallurgy.atum.world.gen.carver.AtumCarvers;
import com.teammetallurgy.atum.world.gen.feature.AnputsFingersFeature;
import com.teammetallurgy.atum.world.gen.feature.BonusCrateFeature;
import com.teammetallurgy.atum.world.gen.feature.DeadwoodFeature;
import com.teammetallurgy.atum.world.gen.feature.DirtyBoneFossilsFeature;
import com.teammetallurgy.atum.world.gen.feature.LakeFeature;
import com.teammetallurgy.atum.world.gen.feature.LimestoneDungeonsFeature;
import com.teammetallurgy.atum.world.gen.feature.LimestoneSpikeFeature;
import com.teammetallurgy.atum.world.gen.feature.OasisPondFeature;
import com.teammetallurgy.atum.world.gen.feature.PalmFeature;
import com.teammetallurgy.atum.world.gen.feature.StartStructureFeature;
import com.teammetallurgy.atum.world.gen.feature.config.DoubleBlockStateFeatureConfig;
import com.teammetallurgy.atum.world.gen.feature.config.PalmConfig;
import com.teammetallurgy.atum.world.gen.structure.girafitomb.GirafiTombStructure;
import com.teammetallurgy.atum.world.gen.structure.lighthouse.LighthouseStructure;
import com.teammetallurgy.atum.world.gen.structure.mineshaft.AtumMineshaftConfig;
import com.teammetallurgy.atum.world.gen.structure.mineshaft.AtumMineshaftStructure;
import com.teammetallurgy.atum.world.gen.structure.pyramid.PyramidStructure;
import com.teammetallurgy.atum.world.gen.structure.ruins.RuinStructure;
import com.teammetallurgy.atum.world.gen.structure.tomb.TombStructure;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.pattern.BlockMatcher;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.IProperty;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.ColumnBlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.LiquidsConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.feature.ReplaceBlockConfig;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.foliageplacer.AcaciaFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.DepthAverageConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="atum", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AtumFeatures {
    private static final List<Feature<?>> FEATURES = new ArrayList();
    public static final Feature<DoubleBlockStateFeatureConfig> OASIS_POND = AtumFeatures.register("oasis_pond", new OasisPondFeature(DoubleBlockStateFeatureConfig::deserializeDouble));
    public static final Feature<BlockStateFeatureConfig> SURFACE_LAVA_LAKE = AtumFeatures.register("surface_lava_lake", new LakeFeature(BlockStateFeatureConfig::func_227271_a_));
    public static final Feature<PalmConfig> PALM_TREE = AtumFeatures.register("palm_tree", new PalmFeature(PalmConfig::deserializePalm));
    public static final BonusCrateFeature BONUS_CRATE = AtumFeatures.register("bonus_crate", new BonusCrateFeature(NoFeatureConfig::func_214639_a));
    public static final StartStructureFeature START_STRUCTURE = AtumFeatures.register("start_structure", new StartStructureFeature(NoFeatureConfig::func_214639_a));
    public static final DirtyBoneFossilsFeature DIRTY_BONE_FOSSILS = AtumFeatures.register("dirty_bone_fossil", new DirtyBoneFossilsFeature(NoFeatureConfig::func_214639_a));
    public static final LimestoneDungeonsFeature LIMESTONE_DUNGEONS = AtumFeatures.register("limestone_dungeon", new LimestoneDungeonsFeature(NoFeatureConfig::func_214639_a));
    public static final DeadwoodFeature DEADWOOD_FEATURE = AtumFeatures.register("deadwood_tree", new DeadwoodFeature(TreeFeatureConfig::func_227338_a_));
    public static final Feature<NoFeatureConfig> LIMESTONE_SPIKE = AtumFeatures.register("limestone_spike", new LimestoneSpikeFeature(NoFeatureConfig::func_214639_a));
    public static final Feature<BlockClusterFeatureConfig> ANPUTS_FINGERS = AtumFeatures.register("anputs_fingers", new AnputsFingersFeature(BlockClusterFeatureConfig::func_227300_a_));
    public static final Structure<NoFeatureConfig> GIRAFI_TOMB = AtumFeatures.register("girafi_tomb", new GirafiTombStructure(NoFeatureConfig::func_214639_a));
    public static final Structure<NoFeatureConfig> LIGHTHOUSE = AtumFeatures.register("lighthouse", new LighthouseStructure(NoFeatureConfig::func_214639_a));
    public static final Structure<NoFeatureConfig> TOMB = AtumFeatures.register("tomb", new TombStructure(NoFeatureConfig::func_214639_a));
    public static final Structure<NoFeatureConfig> RUIN = AtumFeatures.register("ruin", new RuinStructure(NoFeatureConfig::func_214639_a));
    public static final Structure<NoFeatureConfig> PYRAMID = AtumFeatures.register("pyramid", new PyramidStructure(NoFeatureConfig::func_214639_a));
    public static final Structure<AtumMineshaftConfig> MINESHAFT = AtumFeatures.register("mineshaft", new AtumMineshaftStructure(AtumMineshaftConfig::deserialize));
    public static final BlockClusterFeatureConfig OASIS_GRASS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(AtumBlocks.OASIS_GRASS.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(30).func_227322_d_();
    public static final BlockClusterFeatureConfig DEAD_GRASS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(AtumBlocks.DEAD_GRASS.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(2).func_227322_d_();
    public static final BlockClusterFeatureConfig ANPUTS_FINGERS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(AtumBlocks.ANPUTS_FINGERS.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227322_d_();
    public static final BlockClusterFeatureConfig PAPYRUS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(AtumBlocks.PAPYRUS.func_176223_P()), (BlockPlacer)new ColumnBlockPlacer(1, 2)).func_227315_a_(124).func_227318_b_(1).func_227321_c_(0).func_227323_d_(1).func_227317_b_().func_227320_c_().func_227322_d_();
    public static final PalmConfig PALM_TREE_CONFIG = new PalmConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(AtumBlocks.PALM_LOG.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(AtumBlocks.PALM_LEAVES.func_176223_P()), (FoliagePlacer)new AcaciaFoliagePlacer(0, 0)).baseHeight(5).heightRandA(2).heightRandB(1).trunkHeight(1).ignoreVines().date(0.1).ophidianTongue(0.6).setSapling((IPlantable)AtumBlocks.PALM_SAPLING).build();
    public static final PalmConfig PALM_TREE_CONFIG_SAPLING = new PalmConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(AtumBlocks.PALM_LOG.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(AtumBlocks.PALM_LEAVES.func_176223_P()), (FoliagePlacer)new AcaciaFoliagePlacer(0, 0)).baseHeight(5).heightRandA(2).heightRandB(1).trunkHeight(1).ignoreVines().date(0.1).ophidianTongue(0.0).setSapling((IPlantable)AtumBlocks.PALM_SAPLING).build();
    public static final PalmConfig DEAD_PALM_TREE_CONFIG = new PalmConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider((BlockState)AtumBlocks.DEADWOOD_LOG.func_176223_P().func_206870_a((IProperty)DeadwoodLogBlock.HAS_SCARAB, (Comparable)Boolean.valueOf(true))), (BlockStateProvider)new SimpleBlockStateProvider(AtumBlocks.DEADWOOD_LEAVES.func_176223_P()), (FoliagePlacer)new AcaciaFoliagePlacer(0, 0)).baseHeight(5).heightRandA(2).heightRandB(1).trunkHeight(1).ignoreVines().date(0.0).ophidianTongue(0.0).setSapling(null).build();
    public static final LiquidsConfig WATER_SPRING_CONFIG = new LiquidsConfig(Fluids.field_204546_a.func_207188_f(), true, 4, 1, (Set)ImmutableSet.of((Object)AtumBlocks.LIMESTONE));
    public static final LiquidsConfig LAVA_SPRING_CONFIG = new LiquidsConfig(Fluids.field_204547_b.func_207188_f(), true, 4, 1, (Set)ImmutableSet.of((Object)AtumBlocks.LIMESTONE));
    public static final BlockClusterFeatureConfig SHRUB_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(AtumBlocks.SHRUB.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(3).func_227322_d_();
    public static final BlockClusterFeatureConfig WEED_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(AtumBlocks.WEED.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(3).func_227322_d_();

    private static <C extends IFeatureConfig, F extends Feature<C>> F register(String name, F feature) {
        feature.setRegistryName(new ResourceLocation("atum", name));
        FEATURES.add(feature);
        return feature;
    }

    @SubscribeEvent
    public static void registerFeature(RegistryEvent.Register<Feature<?>> event) {
        for (Feature<?> feature : FEATURES) {
            event.getRegistry().register(feature);
        }
    }

    public static class Default {
        public static final OreFeatureConfig.FillerBlockType NATURAL_STONE = OreFeatureConfig.FillerBlockType.create((String)"ATUM_NATURAL_STONE", (String)"atum_natural_stone", (Predicate)new BlockMatcher(AtumBlocks.LIMESTONE));

        public static void addCarvers(Biome biome) {
            biome.func_203609_a(GenerationStage.Carving.AIR, Biome.func_203606_a(AtumCarvers.CAVE, (ICarverConfig)new ProbabilityConfig(0.14285715f)));
            biome.func_203609_a(GenerationStage.Carving.AIR, Biome.func_203606_a(AtumCarvers.CANYON, (ICarverConfig)new ProbabilityConfig(0.02f)));
        }

        public static void addSprings(Biome biome) {
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202295_ao.func_225566_b_((IFeatureConfig)WATER_SPRING_CONFIG).func_227228_a_(Placement.field_215029_o.func_227446_a_((IPlacementConfig)new CountRangeConfig(14, 8, 8, 50))));
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202295_ao.func_225566_b_((IFeatureConfig)LAVA_SPRING_CONFIG).func_227228_a_(Placement.field_215030_p.func_227446_a_((IPlacementConfig)new CountRangeConfig(8, 8, 16, 256))));
        }

        public static void addMaterialPockets(Biome biome) {
            if ((Integer)AtumConfig.WORLD_GEN.sandCount.get() > 0) {
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(NATURAL_STONE, AtumBlocks.SAND.func_176223_P(), ((Integer)AtumConfig.WORLD_GEN.sandVeinSize.get()).intValue())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(((Integer)AtumConfig.WORLD_GEN.sandCount.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.sandBottomOffset.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.sandTopOffset.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.sandMaxHeight.get()).intValue()))));
            }
            if ((Integer)AtumConfig.WORLD_GEN.limestoneGravelCount.get() > 0) {
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(NATURAL_STONE, AtumBlocks.LIMESTONE_GRAVEL.func_176223_P(), ((Integer)AtumConfig.WORLD_GEN.limestoneGravelVeinSize.get()).intValue())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(((Integer)AtumConfig.WORLD_GEN.limestoneGravelCount.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.limestoneGravelBottomOffset.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.limestoneGravelTopOffset.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.limestoneGravelMaxHeight.get()).intValue()))));
            }
            if ((Integer)AtumConfig.WORLD_GEN.marlCount.get() > 0) {
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(NATURAL_STONE, AtumBlocks.MARL.func_176223_P(), ((Integer)AtumConfig.WORLD_GEN.marlVeinSize.get()).intValue())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(((Integer)AtumConfig.WORLD_GEN.marlCount.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.marlBottomOffset.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.marlTopOffset.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.marlMaxHeight.get()).intValue()))));
            }
        }

        public static void addStoneVariants(Biome biome) {
            if ((Integer)AtumConfig.WORLD_GEN.alabasterCount.get() > 0) {
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(NATURAL_STONE, AtumBlocks.ALABASTER.func_176223_P(), ((Integer)AtumConfig.WORLD_GEN.alabasterVeinSize.get()).intValue())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(((Integer)AtumConfig.WORLD_GEN.alabasterCount.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.alabasterBottomOffset.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.alabasterTopOffset.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.alabasterMaxHeight.get()).intValue()))));
            }
            if ((Integer)AtumConfig.WORLD_GEN.porphyryCount.get() > 0) {
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(NATURAL_STONE, AtumBlocks.PORPHYRY.func_176223_P(), ((Integer)AtumConfig.WORLD_GEN.porphyryVeinSize.get()).intValue())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(((Integer)AtumConfig.WORLD_GEN.porphyryCount.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.porphyryBottomOffset.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.porphyryTopOffset.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.porphyryMaxHeight.get()).intValue()))));
            }
        }

        public static void addOres(Biome biome) {
            if ((Integer)AtumConfig.WORLD_GEN.coalCount.get() > 0) {
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(NATURAL_STONE, AtumBlocks.COAL_ORE.func_176223_P(), ((Integer)AtumConfig.WORLD_GEN.coalVeinSize.get()).intValue())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(((Integer)AtumConfig.WORLD_GEN.coalCount.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.coalBottomOffset.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.coalTopOffset.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.coalMaxHeight.get()).intValue()))));
            }
            if ((Integer)AtumConfig.WORLD_GEN.ironCount.get() > 0) {
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(NATURAL_STONE, AtumBlocks.IRON_ORE.func_176223_P(), ((Integer)AtumConfig.WORLD_GEN.ironVeinSize.get()).intValue())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(((Integer)AtumConfig.WORLD_GEN.ironCount.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.ironBottomOffset.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.ironTopOffset.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.ironMaxHeight.get()).intValue()))));
            }
            if ((Integer)AtumConfig.WORLD_GEN.goldCount.get() > 0) {
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(NATURAL_STONE, AtumBlocks.GOLD_ORE.func_176223_P(), ((Integer)AtumConfig.WORLD_GEN.goldVeinSize.get()).intValue())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(((Integer)AtumConfig.WORLD_GEN.goldCount.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.goldBottomOffset.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.goldTopOffset.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.goldMaxHeight.get()).intValue()))));
            }
            if ((Integer)AtumConfig.WORLD_GEN.redstoneCount.get() > 0) {
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(NATURAL_STONE, AtumBlocks.REDSTONE_ORE.func_176223_P(), ((Integer)AtumConfig.WORLD_GEN.redstoneVeinSize.get()).intValue())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(((Integer)AtumConfig.WORLD_GEN.redstoneCount.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.redstoneBottomOffset.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.redstoneTopOffset.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.redstoneMaxHeight.get()).intValue()))));
            }
            if ((Integer)AtumConfig.WORLD_GEN.diamondCount.get() > 0) {
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(NATURAL_STONE, AtumBlocks.DIAMOND_ORE.func_176223_P(), ((Integer)AtumConfig.WORLD_GEN.diamondVeinSize.get()).intValue())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(((Integer)AtumConfig.WORLD_GEN.diamondCount.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.diamondBottomOffset.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.diamondTopOffset.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.diamondMaxHeight.get()).intValue()))));
            }
            if ((Integer)AtumConfig.WORLD_GEN.lapisCount.get() > 0) {
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(NATURAL_STONE, AtumBlocks.LAPIS_ORE.func_176223_P(), ((Integer)AtumConfig.WORLD_GEN.lapisVeinSize.get()).intValue())).func_227228_a_(Placement.field_215035_u.func_227446_a_((IPlacementConfig)new DepthAverageConfig(((Integer)AtumConfig.WORLD_GEN.lapisCount.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.lapisBaseline.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.lapisSpread.get()).intValue()))));
            }
            if ((Integer)AtumConfig.WORLD_GEN.khnumiteCount.get() > 0) {
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(NATURAL_STONE, AtumBlocks.KHNUMITE_RAW.func_176223_P(), ((Integer)AtumConfig.WORLD_GEN.khnumiteVeinSize.get()).intValue())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(((Integer)AtumConfig.WORLD_GEN.khnumiteCount.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.khnumiteBottomOffset.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.khnumiteTopOffset.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.khnumiteMaxHeight.get()).intValue()))));
            }
            if ((Integer)AtumConfig.WORLD_GEN.boneOreCount.get() > 0) {
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(NATURAL_STONE, AtumBlocks.BONE_ORE.func_176223_P(), ((Integer)AtumConfig.WORLD_GEN.boneOreVeinSize.get()).intValue())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(((Integer)AtumConfig.WORLD_GEN.boneOreCount.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.boneOreBottomOffset.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.boneOreTopOffset.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.boneOreMaxHeight.get()).intValue()))));
            }
            if ((Integer)AtumConfig.WORLD_GEN.relicOreCount.get() > 0) {
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(NATURAL_STONE, AtumBlocks.RELIC_ORE.func_176223_P(), ((Integer)AtumConfig.WORLD_GEN.relicOreVeinSize.get()).intValue())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(((Integer)AtumConfig.WORLD_GEN.relicOreCount.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.relicOreBottomOffset.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.relicOreTopOffset.get()).intValue(), ((Integer)AtumConfig.WORLD_GEN.relicOreMaxHeight.get()).intValue()))));
            }
        }

        public static void addEmeraldOre(Biome biome) {
            if (((Boolean)AtumConfig.WORLD_GEN.emeraldEnabled.get()).booleanValue()) {
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202294_an.func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(AtumBlocks.LIMESTONE.func_176223_P(), AtumBlocks.EMERALD_ORE.func_176223_P())).func_227228_a_(Placement.field_215004_C.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
            }
        }

        public static void addInfestedLimestone(Biome biome) {
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(NATURAL_STONE, (BlockState)AtumBlocks.LIMESTONE.func_176223_P().func_206870_a((IProperty)LimestoneBlock.HAS_SCARAB, (Comparable)Boolean.valueOf(true)), 10)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(8, 0, 11, 80))));
        }

        public static void addShrubs(Biome biome) {
            if ((Integer)AtumConfig.WORLD_GEN.shrubFrequency.get() > 0) {
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)SHRUB_CONFIG).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(((Integer)AtumConfig.WORLD_GEN.shrubFrequency.get()).intValue()))));
                biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)WEED_CONFIG).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(((Integer)AtumConfig.WORLD_GEN.shrubFrequency.get()).intValue()))));
            }
        }

        public static void addFossils(Biome biome) {
            if ((Integer)AtumConfig.WORLD_GEN.fossilsChance.get() > 0) {
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, DIRTY_BONE_FOSSILS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215025_k.func_227446_a_((IPlacementConfig)new ChanceConfig(((Integer)AtumConfig.WORLD_GEN.fossilsChance.get()).intValue()))));
            }
        }

        public static void addDungeon(Biome biome) {
            if ((Integer)AtumConfig.WORLD_GEN.dungeonChance.get() > 0) {
                biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, LIMESTONE_DUNGEONS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215007_F.func_227446_a_((IPlacementConfig)new ChanceConfig(((Integer)AtumConfig.WORLD_GEN.dungeonChance.get()).intValue()))));
            }
        }

        public static void addDeadwoodTrees(Biome biome, int count, float extraChance, int extraCount) {
            biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, DEADWOOD_FEATURE.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider((BlockState)AtumBlocks.DEADWOOD_LOG.func_176223_P().func_206870_a((IProperty)DeadwoodLogBlock.HAS_SCARAB, (Comparable)Boolean.valueOf(true))), (BlockStateProvider)new SimpleBlockStateProvider(AtumBlocks.DEADWOOD_BRANCH.func_176223_P())).func_225568_b_()).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(count, extraChance, extraCount))));
        }

        public static void addTomb(Biome biome) {
            biome.func_226711_a_(TOMB.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, TOMB.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
        }

        public static void addPyramid(Biome biome) {
            if (((Boolean)AtumConfig.WORLD_GEN.pyramidEnabled.get()).booleanValue()) {
                biome.func_226711_a_(PYRAMID.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
                biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, PYRAMID.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
            }
        }

        public static void addRuins(Biome biome) {
            if (((Boolean)AtumConfig.WORLD_GEN.ruinsEnabled.get()).booleanValue()) {
                biome.func_226711_a_(RUIN.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
                biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, RUIN.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e));
            }
        }

        public static void addMineshaft(Biome biome, boolean isSurface) {
            if ((Double)AtumConfig.WORLD_GEN.mineshaftProbability.get() > 0.0) {
                int chance = new Random().nextInt(100);
                AtumMineshaftStructure.Type type = chance > 50 ? (isSurface ? AtumMineshaftStructure.Type.LIMESTONE_SURFACE : AtumMineshaftStructure.Type.LIMESTONE) : (isSurface ? AtumMineshaftStructure.Type.DEADWOOD_SURFACE : AtumMineshaftStructure.Type.DEADWOOD);
                AtumMineshaftConfig config = new AtumMineshaftConfig((Double)AtumConfig.WORLD_GEN.mineshaftProbability.get(), type);
                biome.func_226711_a_(MINESHAFT.func_225566_b_((IFeatureConfig)config));
                biome.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, MINESHAFT.func_225566_b_((IFeatureConfig)config));
            }
        }
    }
}

