/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.items;

import com.google.common.base.Preconditions;
import com.teammetallurgy.atum.Atum;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.CauldronBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class LootItem
extends Item {
    public static final NonNullList<LootEntry> LOOT_ENTRIES = NonNullList.func_191196_a();

    public LootItem(Item.Properties properties) {
        super(properties.func_200916_a(Atum.GROUP));
    }

    public Item getLootItem(Type type, Quality quality) {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("atum", "loot_" + quality.func_176610_l() + "_" + type.func_176610_l()));
    }

    public static Type getType(Item item) {
        if (!(item instanceof LootItem)) {
            Atum.LOG.error("Item is not a loot artifact");
        } else {
            for (Quality quality : Quality.values()) {
                Preconditions.checkNotNull((Object)item.getRegistryName(), (Object)"registryName");
                Type type = Type.byString(item.getRegistryName().func_110623_a().replace("loot_", "").replace(quality.func_176610_l(), "").replace("_", ""));
                if (type == null) continue;
                return type;
            }
        }
        return Type.IDOL;
    }

    public static Quality getQuality(Item item) {
        if (!(item instanceof LootItem)) {
            Atum.LOG.error("Item is not a loot artifact");
        } else {
            for (Type type : Type.values()) {
                Preconditions.checkNotNull((Object)item.getRegistryName(), (Object)"registryName");
                Quality quality = Quality.byString(item.getRegistryName().func_110623_a().replace("loot_", "").replace(type.func_176610_l(), "").replace("_", ""));
                if (quality == null) continue;
                return quality;
            }
        }
        return Quality.DIRTY;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entityItem) {
        World world = entityItem.field_70170_p;
        BlockState state = world.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)entityItem.func_226277_ct_()), MathHelper.func_76128_c((double)entityItem.func_226278_cu_()), MathHelper.func_76128_c((double)entityItem.func_226281_cx_())));
        if ((state.func_204520_s().func_206884_a(FluidTags.field_206959_a) || state.func_177230_c() instanceof CauldronBlock && (Integer)state.func_177229_b((IProperty)CauldronBlock.field_176591_a) > 0) && stack.func_77973_b() instanceof LootItem && String.valueOf(stack.func_77973_b().getRegistryName()).contains("dirty") && !world.field_72995_K) {
            while (stack.func_190916_E() > 0) {
                Item item = this.getLootItem(LootItem.getType(stack.func_77973_b()), ((LootEntry)WeightedRandom.func_76271_a((Random)LootItem.field_77697_d, LootItem.LOOT_ENTRIES)).quality);
                if (field_77697_d.nextFloat() <= 0.1f) {
                    stack.func_190918_g(1);
                    world.func_184148_a(null, entityItem.func_226277_ct_(), entityItem.func_226278_cu_(), entityItem.func_226281_cx_(), SoundEvents.field_187635_cQ, entityItem.func_184176_by(), 0.8f, 0.8f + entityItem.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                    continue;
                }
                world.func_217376_c((Entity)new ItemEntity(world, entityItem.func_226277_ct_(), entityItem.func_226278_cu_(), entityItem.func_226281_cx_(), new ItemStack((IItemProvider)item)));
                world.func_184148_a(null, entityItem.func_226277_ct_(), entityItem.func_226278_cu_(), entityItem.func_226281_cx_(), SoundEvents.field_187604_bf, entityItem.func_184176_by(), 0.8f, 0.8f + entityItem.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                stack.func_190918_g(1);
            }
        }
        return super.onEntityItemUpdate(stack, entityItem);
    }

    public static class LootEntry
    extends WeightedRandom.Item {
        final Quality quality;

        public LootEntry(Quality quality, int weight) {
            super(weight);
            this.quality = quality;
        }
    }

    public static enum Quality implements IStringSerializable
    {
        DIRTY("dirty", 0),
        SILVER("silver", 48),
        GOLD("gold", 25),
        SAPPHIRE("sapphire", 20),
        RUBY("ruby", 15),
        EMERALD("emerald", 10),
        DIAMOND("diamond", 5);

        private final String unlocalizedName;
        private final int weight;

        private Quality(String name, int lootWeight) {
            this.unlocalizedName = name;
            this.weight = lootWeight;
        }

        public static Quality byString(String name) {
            for (Quality quality : Quality.values()) {
                if (!quality.func_176610_l().equals(name)) continue;
                return quality;
            }
            return null;
        }

        public int getWeight() {
            return this.weight;
        }

        @Nonnull
        public String func_176610_l() {
            return this.unlocalizedName;
        }
    }

    public static enum Type implements IStringSerializable
    {
        IDOL("idol"),
        NECKLACE("necklace"),
        RING("ring"),
        BROOCH("broach"),
        SCEPTER("scepter");

        private final String unlocalizedName;

        private Type(String name) {
            this.unlocalizedName = name;
        }

        public static Type byString(String name) {
            for (Type type : Type.values()) {
                if (!type.func_176610_l().equals(name)) continue;
                return type;
            }
            return null;
        }

        @Nonnull
        public String func_176610_l() {
            return this.unlocalizedName;
        }
    }
}

