/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.items.artifacts.nuit;

import com.teammetallurgy.atum.init.AtumItems;
import com.teammetallurgy.atum.init.AtumParticles;
import com.teammetallurgy.atum.items.tools.KhopeshItem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.Rarity;
import net.minecraft.item.UseAction;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="atum")
public class NuitsIreItem
extends KhopeshItem {
    private boolean isOffhand = false;
    private static boolean isBlocking = false;

    public NuitsIreItem() {
        super((IItemTier)ItemTier.DIAMOND, new Item.Properties().func_208103_a(Rarity.RARE));
        this.func_185043_a(new ResourceLocation("blocking"), new IItemPropertyGetter(){

            @OnlyIn(value=Dist.CLIENT)
            public float call(@Nonnull ItemStack stack, @Nullable World world, @Nullable LivingEntity entity) {
                return entity != null && entity.func_184587_cr() && entity.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(@Nonnull ItemStack stack) {
        return true;
    }

    @Nonnull
    public UseAction func_77661_b(@Nonnull ItemStack stack) {
        return UseAction.BLOCK;
    }

    public int func_77626_a(@Nonnull ItemStack stack) {
        return this.isOffhand ? 72000 : 0;
    }

    public boolean isShield(@Nonnull ItemStack stack, @Nullable LivingEntity entity) {
        return this.isOffhand;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        if (hand == Hand.OFF_HAND) {
            player.func_184598_c(Hand.OFF_HAND);
            this.isOffhand = true;
            return new ActionResult(ActionResultType.SUCCESS, (Object)player.func_184586_b(Hand.OFF_HAND));
        }
        this.isOffhand = false;
        return super.func_77659_a(world, player, hand);
    }

    @Override
    public boolean func_77644_a(@Nonnull ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (field_77697_d.nextFloat() <= 0.25f) {
            NuitsIreItem.applyWither(target, attacker, attacker.func_184592_cb().func_77973_b() == AtumItems.NUITS_QUARTER);
        }
        return super.func_77644_a(stack, target, attacker);
    }

    @SubscribeEvent
    public static void onUse(LivingEntityUseItemEvent.Tick event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity instanceof PlayerEntity && entity.func_184586_b(Hand.OFF_HAND).func_77973_b() == AtumItems.NUITS_IRE) {
            isBlocking = true;
        }
    }

    @SubscribeEvent
    public static void onHurt(LivingHurtEvent event) {
        Entity trueSource = event.getSource().func_76364_f();
        if (trueSource instanceof LivingEntity && event.getEntityLiving() instanceof PlayerEntity && isBlocking && field_77697_d.nextFloat() <= 0.25f) {
            NuitsIreItem.applyWither((LivingEntity)trueSource, event.getEntityLiving(), event.getEntityLiving().func_184614_ca().func_77973_b() == AtumItems.NUITS_QUARTER);
            isBlocking = false;
        }
    }

    private static void applyWither(LivingEntity target, LivingEntity attacker, boolean isNuitsQuarterHeld) {
        if (attacker != target) {
            if (target.field_70170_p instanceof ServerWorld) {
                ServerWorld serverWorld = (ServerWorld)target.field_70170_p;
                serverWorld.func_195598_a((IParticleData)AtumParticles.NUIT_WHITE, target.func_226277_ct_() + (field_77697_d.nextDouble() - 0.5) * (double)target.func_213311_cf(), target.func_226278_cu_() + (double)target.func_213302_cg() / 1.5, target.func_226281_cx_() + (field_77697_d.nextDouble() - 0.5) * (double)target.func_213311_cf(), 8, 0.01, 0.0, 0.01, 0.02);
            }
            target.func_195064_c(new EffectInstance(Effects.field_82731_v, 60, isNuitsQuarterHeld ? 2 : 1));
        }
    }
}

