/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.misc;

import com.google.common.collect.Lists;
import com.teammetallurgy.atum.Atum;
import com.teammetallurgy.atum.blocks.wood.AtumTorchUnlitBlock;
import com.teammetallurgy.atum.blocks.wood.AtumWallTorch;
import com.teammetallurgy.atum.blocks.wood.AtumWallTorchUnlitBlock;
import com.teammetallurgy.atum.entity.projectile.arrow.CustomArrow;
import com.teammetallurgy.atum.entity.undead.PharaohEntity;
import com.teammetallurgy.atum.init.AtumBiomes;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumEntities;
import com.teammetallurgy.atum.init.AtumItems;
import com.teammetallurgy.atum.init.AtumParticles;
import com.teammetallurgy.atum.init.AtumSounds;
import com.teammetallurgy.atum.items.LootItem;
import com.teammetallurgy.atum.items.tools.ScepterItem;
import com.teammetallurgy.atum.misc.datagenerator.BlockStatesGenerator;
import com.teammetallurgy.atum.misc.datagenerator.RecipeGenerator;
import com.teammetallurgy.atum.world.biome.AtumBiome;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.item.WallOrFloorItem;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="atum", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AtumRegistry {
    private static final List<Item> ITEMS = Lists.newArrayList();
    private static final List<Block> BLOCKS = Lists.newArrayList();
    public static final List<AtumBiome> BIOMES = Lists.newArrayList();
    private static final List<EntityType<?>> ENTITIES = Lists.newArrayList();
    private static final List<SoundEvent> SOUNDS = Lists.newArrayList();
    private static final List<ParticleType<?>> PARTICLES = Lists.newArrayList();
    public static final List<EntityType<? extends CustomArrow>> ARROWS = Lists.newArrayList();

    public static Item registerItem(@Nonnull Item item, @Nonnull String name) {
        item.setRegistryName(new ResourceLocation("atum", name));
        ITEMS.add(item);
        return item;
    }

    public static LootItem registerRelic(@Nonnull LootItem.Type type) {
        Item.Properties nonDirty = new Item.Properties().func_200917_a(16);
        LootItem dirty = new LootItem(new Item.Properties().func_200917_a(64));
        AtumRegistry.registerItem(dirty, AtumRegistry.getLootName(LootItem.Quality.DIRTY, type));
        AtumRegistry.registerItem(new LootItem(nonDirty), AtumRegistry.getLootName(LootItem.Quality.SILVER, type));
        AtumRegistry.registerItem(new LootItem(nonDirty), AtumRegistry.getLootName(LootItem.Quality.GOLD, type));
        AtumRegistry.registerItem(new LootItem(nonDirty), AtumRegistry.getLootName(LootItem.Quality.SAPPHIRE, type));
        AtumRegistry.registerItem(new LootItem(nonDirty), AtumRegistry.getLootName(LootItem.Quality.RUBY, type));
        AtumRegistry.registerItem(new LootItem(nonDirty), AtumRegistry.getLootName(LootItem.Quality.EMERALD, type));
        AtumRegistry.registerItem(new LootItem(nonDirty), AtumRegistry.getLootName(LootItem.Quality.DIAMOND, type));
        return dirty;
    }

    public static Item registerScepter(PharaohEntity.God god) {
        ScepterItem scepter = new ScepterItem();
        ScepterItem.SCEPTERS.put(god, scepter);
        return AtumRegistry.registerItem((Item)scepter, "scepter_" + god.getName());
    }

    private static String getLootName(@Nonnull LootItem.Quality quality, @Nonnull LootItem.Type type) {
        LootItem.LOOT_ENTRIES.add((Object)new LootItem.LootEntry(quality, quality.getWeight()));
        return "loot_" + quality.func_176610_l() + "_" + type.func_176610_l();
    }

    public static Block registerTorch(@Nonnull Block torch, @Nonnull String name) {
        AtumTorchUnlitBlock unlitTorch = new AtumTorchUnlitBlock();
        AtumWallTorch wallTorchLit = new AtumWallTorch(Block.Properties.func_200950_a((Block)torch).func_222379_b(torch));
        AtumWallTorchUnlitBlock wallTorchUnlit = new AtumWallTorchUnlitBlock((Block)wallTorchLit, Block.Properties.func_200950_a((Block)unlitTorch).func_222379_b((Block)unlitTorch));
        AtumRegistry.registerBaseBlock((Block)wallTorchLit, "wall_" + name);
        AtumRegistry.registerBaseBlock((Block)wallTorchUnlit, "wall_" + name + "_unlit");
        AtumRegistry.registerBlockWithItem((Block)unlitTorch, (BlockItem)new WallOrFloorItem((Block)unlitTorch, (Block)wallTorchUnlit, new Item.Properties()), name + "_unlit");
        AtumTorchUnlitBlock.UNLIT.put(torch, (Block)unlitTorch);
        AtumWallTorchUnlitBlock.UNLIT.put(torch, (Block)wallTorchUnlit);
        AtumTorchUnlitBlock.LIT.put((Block)unlitTorch, torch);
        AtumTorchUnlitBlock.ALL_TORCHES.add(torch);
        AtumTorchUnlitBlock.ALL_TORCHES.add((Block)unlitTorch);
        AtumTorchUnlitBlock.ALL_TORCHES.add((Block)wallTorchLit);
        AtumTorchUnlitBlock.ALL_TORCHES.add((Block)wallTorchUnlit);
        return AtumRegistry.registerBlockWithItem(torch, (BlockItem)new WallOrFloorItem(torch, (Block)wallTorchLit, new Item.Properties().func_200916_a(Atum.GROUP)), name);
    }

    public static Block registerBlock(@Nonnull Block block, @Nonnull String name) {
        return AtumRegistry.registerBlock(block, new Item.Properties(), name);
    }

    public static Block registerBlock(@Nonnull Block block, Supplier<Callable<ItemStackTileEntityRenderer>> ister, @Nullable Item.Properties properties, @Nonnull String name) {
        BlockItem blockItem = new BlockItem(block, properties == null ? new Item.Properties().setISTER(ister) : properties.setISTER(ister).func_200916_a(Atum.GROUP));
        return AtumRegistry.registerBlockWithItem(block, blockItem, name);
    }

    public static Block registerBlock(@Nonnull Block block, @Nullable Item.Properties properties, @Nonnull String name) {
        BlockItem blockItem = new BlockItem(block, properties == null ? new Item.Properties() : properties.func_200916_a(Atum.GROUP));
        return AtumRegistry.registerBlockWithItem(block, blockItem, name);
    }

    public static Block registerBlockWithItem(@Nonnull Block block, BlockItem blockItem, @Nonnull String name) {
        AtumRegistry.registerItem((Item)blockItem, name);
        return AtumRegistry.registerBaseBlock(block, name);
    }

    public static Block registerBaseBlock(@Nonnull Block block, @Nonnull String name) {
        block.setRegistryName(new ResourceLocation("atum", name));
        BLOCKS.add(block);
        return block;
    }

    public static <T extends Entity> EntityType<T> registerMob(String name, int eggPrimary, int eggSecondary, EntityType.Builder<T> builder) {
        EntityType<T> entityType = AtumRegistry.registerEntity(name, builder);
        SpawnEggItem spawnEgg = new SpawnEggItem(entityType, eggPrimary, eggSecondary, new Item.Properties().func_200916_a(Atum.GROUP));
        AtumRegistry.registerItem((Item)spawnEgg, name + "_spawn_egg");
        return entityType;
    }

    public static <T extends Entity> EntityType<T> registerEntity(String name, EntityType.Builder<T> builder) {
        ResourceLocation location = new ResourceLocation("atum", name);
        EntityType entityType = builder.func_206830_a(location.toString());
        entityType.setRegistryName(location);
        ENTITIES.add(entityType);
        return entityType;
    }

    public static <T extends CustomArrow> EntityType<T> registerArrow(String name, EntityType.IFactory<T> factory) {
        EntityType.Builder builder = EntityType.Builder.func_220322_a(factory, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setTrackingRange(4).setUpdateInterval(20);
        EntityType<T> entityType = AtumRegistry.registerEntity(name, builder);
        ARROWS.add(entityType);
        return entityType;
    }

    public static AtumBiome registerBiome(AtumBiome biome, String name) {
        biome.setRegistryName(new ResourceLocation("atum", name));
        BIOMES.add(biome);
        return biome;
    }

    public static SoundEvent registerSound(String name) {
        ResourceLocation resourceLocation = new ResourceLocation("atum", name);
        SoundEvent sound = new SoundEvent(resourceLocation);
        sound.setRegistryName(resourceLocation);
        SOUNDS.add(sound);
        return sound;
    }

    public static BasicParticleType registerParticle(String name) {
        ResourceLocation resourceLocation = new ResourceLocation("atum", name);
        BasicParticleType particleType = new BasicParticleType(false);
        particleType.setRegistryName(resourceLocation);
        PARTICLES.add((ParticleType<?>)particleType);
        return particleType;
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        new AtumItems();
        for (Item item : ITEMS) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        new AtumBlocks();
        for (Block block : BLOCKS) {
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
        AtumBlocks.setBlockInfo();
    }

    @SubscribeEvent
    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        new AtumBiomes();
        for (Biome biome : BIOMES) {
            event.getRegistry().register((IForgeRegistryEntry)biome);
        }
        AtumBiomes.addBiomeTags();
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        new AtumEntities();
        for (EntityType<?> entityType : ENTITIES) {
            event.getRegistry().register(entityType);
        }
        AtumEntities.registerSpawnPlacement();
    }

    @SubscribeEvent
    public static void registerSound(RegistryEvent.Register<SoundEvent> event) {
        new AtumSounds();
        for (SoundEvent sound : SOUNDS) {
            event.getRegistry().register((IForgeRegistryEntry)sound);
        }
    }

    @SubscribeEvent
    public static void registerParticle(RegistryEvent.Register<ParticleType<?>> event) {
        new AtumParticles();
        for (ParticleType<?> particleType : PARTICLES) {
            event.getRegistry().register(particleType);
        }
    }

    @SubscribeEvent
    public static void data(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        if (event.includeClient()) {
            gen.func_200390_a((IDataProvider)new BlockStatesGenerator(gen, event.getExistingFileHelper()));
        }
        if (event.includeServer()) {
            gen.func_200390_a((IDataProvider)new RecipeGenerator(gen));
        }
    }
}

