/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.misc.event;

import com.teammetallurgy.atum.blocks.PortalBlock;
import com.teammetallurgy.atum.blocks.vegetation.FertileSoilBlock;
import com.teammetallurgy.atum.blocks.vegetation.FertileSoilTilledBlock;
import com.teammetallurgy.atum.entity.stone.StoneBaseEntity;
import com.teammetallurgy.atum.entity.undead.PharaohEntity;
import com.teammetallurgy.atum.entity.undead.UndeadBaseEntity;
import com.teammetallurgy.atum.entity.undead.WraithEntity;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumItems;
import com.teammetallurgy.atum.init.AtumLootTables;
import com.teammetallurgy.atum.items.DyeableTexturedArmor;
import com.teammetallurgy.atum.items.artifacts.atum.AtumsBountyItem;
import com.teammetallurgy.atum.misc.AtumConfig;
import com.teammetallurgy.atum.world.dimension.AtumDimensionType;
import com.teammetallurgy.atum.world.teleporter.TeleporterAtumStart;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CauldronBlock;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="atum")
public class AtumEventListener {
    private static final String TAG_ATUM_START = "atum_start";

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        CompoundNBT tag = player.getPersistentData();
        CompoundNBT persistedTag = tag.func_74775_l("PlayerPersisted");
        boolean shouldStartInAtum = (Boolean)AtumConfig.ATUM_START.startInAtum.get() != false && !persistedTag.func_74767_n(TAG_ATUM_START);
        persistedTag.func_74757_a(TAG_ATUM_START, true);
        tag.func_218657_a("PlayerPersisted", (INBT)persistedTag);
        if (shouldStartInAtum && player instanceof ServerPlayerEntity && player.field_70170_p instanceof ServerWorld) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            ServerWorld world = (ServerWorld)serverPlayer.field_70170_p;
            PortalBlock.changeDimension((World)world, serverPlayer, AtumDimensionType.ATUM, new TeleporterAtumStart());
        }
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        World world = player.field_70170_p;
        if (!world.field_72995_K && ((Boolean)AtumConfig.GENERAL.allowCreation.get()).booleanValue() && event.phase == TickEvent.Phase.END && player.field_70173_aa % 20 == 0 && (world.field_73011_w.getDimension().func_186058_p() == DimensionType.field_223227_a_ || world.field_73011_w.func_186058_p() == AtumDimensionType.ATUM)) {
            for (ItemEntity entityItem : world.func_217357_a(ItemEntity.class, player.func_174813_aQ().func_72314_b(10.0, 1.0, 10.0))) {
                BlockState state = world.func_180495_p(entityItem.func_180425_c());
                if (entityItem.func_92059_d().func_77973_b() != AtumItems.SCARAB || state.func_177230_c() != Blocks.field_150355_j && state != AtumBlocks.PORTAL.func_176223_P() || !AtumBlocks.PORTAL.trySpawnPortal(world, entityItem.func_180425_c())) continue;
                entityItem.func_70106_y();
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onPlace(BlockEvent.EntityPlaceEvent event) {
        BlockState state = event.getPlacedBlock();
        if (event.getWorld().func_201675_m().func_186058_p() == AtumDimensionType.ATUM && (state.func_185904_a() == Material.field_151578_c || state.func_177230_c() == Blocks.field_196658_i || state.func_177230_c() == Blocks.field_150391_bh) && state.func_177230_c() != AtumBlocks.FERTILE_SOIL_TILLED) {
            event.getWorld().func_180501_a(event.getPos(), AtumBlocks.SAND.func_176223_P(), 3);
        }
    }

    @SubscribeEvent
    public static void onArmorClean(PlayerInteractEvent.RightClickBlock event) {
        try {
            World world = event.getWorld();
            BlockPos pos = event.getPos();
            PlayerEntity player = event.getPlayer();
            ItemStack stack = player.func_184614_ca();
            LazyOptional lazyTank = FluidUtil.getFluidHandler((World)world, (BlockPos)pos, (Direction)event.getFace());
            if (stack.func_77973_b() instanceof DyeableTexturedArmor && ((DyeableTexturedArmor)stack.func_77973_b()).func_200883_f_(stack)) {
                BlockState state = world.func_180495_p(pos);
                if (state.func_177230_c() instanceof CauldronBlock) {
                    int level = (Integer)state.func_177229_b((IProperty)CauldronBlock.field_176591_a);
                    if (level > 0) {
                        if (!world.field_72995_K) {
                            ((DyeableTexturedArmor)stack.func_77973_b()).func_200884_g(stack);
                            player.func_195066_a(Stats.field_188079_M);
                            ((CauldronBlock)state.func_177230_c()).func_176590_a(world, pos, state, level - 1);
                        }
                        player.func_184185_a(SoundEvents.field_187609_F, 0.16f, 0.66f);
                        event.setUseItem(Event.Result.DENY);
                    }
                } else if (((Boolean)lazyTank.map(f -> f instanceof FluidTank).orElse((Object)false)).booleanValue()) {
                    lazyTank.ifPresent(tank -> {
                        FluidTank fluidTank = (FluidTank)tank;
                        if (fluidTank.getFluid().getFluid().func_207185_a(FluidTags.field_206959_a) && fluidTank.getFluidAmount() >= 250) {
                            if (!world.field_72995_K) {
                                ((DyeableTexturedArmor)stack.func_77973_b()).func_200884_g(stack);
                                player.func_195066_a(Stats.field_188079_M);
                                tank.drain(250, IFluidHandler.FluidAction.EXECUTE);
                            }
                            player.func_184185_a(SoundEvents.field_187609_F, 0.16f, 0.66f);
                            event.setUseItem(Event.Result.ALLOW);
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void onSeedUse(PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity player = event.getPlayer();
        World world = event.getWorld();
        if (player.field_70170_p.field_73011_w.func_186058_p() == AtumDimensionType.ATUM && player.func_184586_b(event.getHand()).func_77973_b() == Items.field_151014_N && world.func_180495_p(event.getPos()).func_177230_c() instanceof FarmlandBlock) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onFallDamage(LivingFallEvent event) {
        if (event.getEntity() instanceof WraithEntity || event.getEntity() instanceof PharaohEntity) {
            event.setDistance(0.0f);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        if (event.getSource().equals(DamageSource.field_76369_e) && (event.getEntity() instanceof UndeadBaseEntity || event.getEntity() instanceof StoneBaseEntity)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onFishLoot(ItemFishedEvent event) {
        World world = event.getPlayer().field_70170_p;
        FishingBobberEntity bobber = event.getHookEntity();
        PlayerEntity angler = bobber.func_190619_l();
        if (angler != null) {
            ItemStack heldStack = angler.func_184586_b(angler.func_184600_cs());
            LootContext.Builder builder = new LootContext.Builder((ServerWorld)world);
            builder.func_186469_a((float)EnchantmentHelper.func_191529_b((ItemStack)heldStack) + angler.func_184817_da()).func_216015_a(LootParameters.field_216284_d, (Object)angler).func_216015_a(LootParameters.field_216281_a, (Object)bobber);
            if (world.field_73011_w.func_186058_p() == AtumDimensionType.ATUM) {
                event.setCanceled(true);
                if (heldStack.func_77973_b() instanceof AtumsBountyItem) {
                    AtumEventListener.catchFish((ServerWorld)world, angler, bobber, builder, AtumLootTables.ATUMS_BOUNTY);
                    angler.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(angler.field_70170_p, angler.func_226277_ct_(), angler.func_226278_cu_() + 0.5, angler.func_226281_cx_() + 0.5, world.field_73012_v.nextInt(6) + 1));
                } else {
                    AtumEventListener.catchFish((ServerWorld)world, angler, bobber, builder, AtumLootTables.FISHING);
                }
            }
        }
    }

    private static void catchFish(ServerWorld world, PlayerEntity angler, FishingBobberEntity bobber, LootContext.Builder builder, ResourceLocation lootTable) {
        List loots = world.func_73046_m().func_200249_aQ().func_186521_a(lootTable).func_216113_a(builder.func_216022_a(LootParameterSets.field_216262_c));
        for (ItemStack loot : loots) {
            ItemEntity fish = new ItemEntity(bobber.field_70170_p, bobber.func_226277_ct_(), bobber.func_226278_cu_(), bobber.func_226281_cx_(), loot);
            double x = angler.func_226277_ct_() - bobber.func_226277_ct_();
            double y = angler.func_226278_cu_() - bobber.func_226278_cu_();
            double z = angler.func_226281_cx_() - bobber.func_226281_cx_();
            double swush = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
            fish.func_213293_j(x * 0.1, y * 0.1 + swush * 0.08, z * 0.1);
            world.func_217376_c((Entity)fish);
        }
    }

    @SubscribeEvent
    public static void onHoeEvent(UseHoeEvent event) {
        World world = event.getContext().func_195991_k();
        BlockPos pos = event.getContext().func_195995_a();
        BlockState state = world.func_180495_p(pos);
        boolean result = false;
        if (state.func_177230_c() instanceof FertileSoilBlock) {
            if (event.getContext().func_195996_i().func_77973_b() == AtumItems.TEFNUTS_BLESSING) {
                world.func_175656_a(pos, (BlockState)((BlockState)AtumBlocks.FERTILE_SOIL_TILLED.func_176223_P().func_206870_a((IProperty)FertileSoilTilledBlock.field_176531_a, (Comparable)Integer.valueOf(7))).func_206870_a((IProperty)FertileSoilTilledBlock.BLESSED, (Comparable)Boolean.valueOf(true)));
            } else {
                world.func_175656_a(pos, AtumBlocks.FERTILE_SOIL_TILLED.func_176223_P());
            }
            result = true;
        }
        if (result) {
            event.setResult(Event.Result.ALLOW);
            world.func_184133_a(null, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }
}

