/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.gen.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.IntegrityProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;

public class DirtyBoneFossilsFeature
extends Feature<NoFeatureConfig> {
    private static final int FOSSIL_AMOUNT = 16;

    public DirtyBoneFossilsFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> config) {
        super(config);
    }

    public boolean place(@Nonnull IWorld world, @Nonnull ChunkGenerator<? extends GenerationSettings> generator, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull NoFeatureConfig config) {
        Rotation[] rotations = Rotation.values();
        Rotation rotation = rotations[rand.nextInt(rotations.length)];
        int size = rand.nextInt(16);
        TemplateManager manager = ((ServerWorld)world.func_201672_e()).func_217485_w().func_186340_h();
        Template template = manager.func_200220_a(new ResourceLocation("atum", "fossils/fossil_" + size));
        ChunkPos chunkPos = new ChunkPos(pos);
        MutableBoundingBox box = new MutableBoundingBox(chunkPos.func_180334_c(), 0, chunkPos.func_180333_d(), chunkPos.func_180332_e(), 256, chunkPos.func_180330_f());
        PlacementSettings settings = new PlacementSettings().func_186220_a(rotation).func_186223_a(box).func_189950_a(rand).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215206_c);
        BlockPos transformedPos = template.func_186257_a(rotation);
        int x = rand.nextInt(16 - transformedPos.func_177958_n());
        int z = rand.nextInt(16 - transformedPos.func_177952_p());
        int height = 256;
        for (int x1 = 0; x1 < transformedPos.func_177958_n(); ++x1) {
            for (int z2 = 0; z2 < transformedPos.func_177952_p(); ++z2) {
                height = Math.min(height, world.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, pos.func_177958_n() + x1 + x, pos.func_177952_p() + z2 + z));
            }
        }
        int y = Math.max(height - 15 - rand.nextInt(10), 10);
        BlockPos genPos = template.func_189961_a(pos.func_177982_a(x, y, z), Mirror.NONE, rotation);
        IntegrityProcessor integrity = new IntegrityProcessor(0.8f);
        settings.func_215219_b().func_215222_a((StructureProcessor)integrity);
        template.func_189962_a(world, genPos, settings, 4);
        return true;
    }
}

