/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.gen.feature;

import com.mojang.datafixers.Dynamic;
import com.teammetallurgy.atum.Atum;
import com.teammetallurgy.atum.blocks.base.ChestBaseBlock;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumEntities;
import com.teammetallurgy.atum.init.AtumLootTables;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityType;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class LimestoneDungeonsFeature
extends Feature<NoFeatureConfig> {
    private static final EntityType<?>[] SPAWNERTYPES = new EntityType[]{EntityType.field_200741_ag, EntityType.field_200725_aD, EntityType.field_200725_aD, EntityType.field_200748_an};
    private static final BlockState CAVE_AIR = Blocks.field_201941_jj.func_176223_P();

    public LimestoneDungeonsFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> config) {
        super(config);
    }

    public boolean place(@Nonnull IWorld world, @Nonnull ChunkGenerator<? extends GenerationSettings> generator, Random rand, @Nonnull BlockPos pos, @Nonnull NoFeatureConfig config) {
        int j = rand.nextInt(2) + 2;
        int k = -j - 1;
        int l = j + 1;
        int k1 = rand.nextInt(2) + 2;
        int l1 = -k1 - 1;
        int i2 = k1 + 1;
        int j2 = 0;
        for (int x = k; x <= l; ++x) {
            for (int y = -1; y <= 4; ++y) {
                for (int z = l1; z <= i2; ++z) {
                    BlockPos checkPos = pos.func_177982_a(x, y, z);
                    Material material = world.func_180495_p(checkPos).func_185904_a();
                    boolean isSolid = material.func_76220_a();
                    if (y == -1 && !isSolid) {
                        return false;
                    }
                    if (y == 4 && !isSolid) {
                        return false;
                    }
                    if (x != k && x != l && z != l1 && z != i2 || y != 0 || !world.func_175623_d(checkPos) || !world.func_175623_d(checkPos.func_177984_a())) continue;
                    ++j2;
                }
            }
        }
        if (j2 >= 1 && j2 <= 5) {
            for (int k3 = k; k3 <= l; ++k3) {
                for (int i4 = 3; i4 >= -1; --i4) {
                    for (int k4 = l1; k4 <= i2; ++k4) {
                        BlockPos genPos = pos.func_177982_a(k3, i4, k4);
                        if (k3 != k && i4 != -1 && k4 != l1 && k3 != l && i4 != 4 && k4 != i2) {
                            if (world.func_180495_p(genPos).func_177230_c() == AtumBlocks.DEADWOOD_CRATE) continue;
                            world.func_180501_a(genPos, CAVE_AIR, 2);
                            continue;
                        }
                        if (genPos.func_177956_o() >= 0 && !world.func_180495_p(genPos.func_177977_b()).func_185904_a().func_76220_a()) {
                            world.func_180501_a(genPos, CAVE_AIR, 2);
                            continue;
                        }
                        if (!world.func_180495_p(genPos).func_185904_a().func_76220_a() || world.func_180495_p(genPos).func_177230_c() == AtumBlocks.DEADWOOD_CRATE) continue;
                        if (i4 == -1 && rand.nextInt(4) != 0) {
                            world.func_180501_a(genPos, AtumBlocks.LIMESTONE_BRICK_CRACKED_BRICK.func_176223_P(), 2);
                            continue;
                        }
                        world.func_180501_a(genPos, AtumBlocks.LIMESTONE_BRICK_LARGE.func_176223_P(), 2);
                    }
                }
            }
            block6: for (int l3 = 0; l3 < 2; ++l3) {
                for (int j4 = 0; j4 < 3; ++j4) {
                    int z;
                    int y;
                    int x = pos.func_177958_n() + rand.nextInt(j * 2 + 1) - j;
                    BlockPos cratePos = new BlockPos(x, y = pos.func_177956_o(), z = pos.func_177952_p() + rand.nextInt(k1 * 2 + 1) - k1);
                    if (!world.func_175623_d(cratePos)) continue;
                    int j3 = 0;
                    for (Direction direction : Direction.Plane.HORIZONTAL) {
                        if (!world.func_180495_p(cratePos.func_177972_a(direction)).func_185904_a().func_76220_a()) continue;
                        ++j3;
                    }
                    if (j3 != true) continue;
                    world.func_180501_a(cratePos, ChestBaseBlock.correctFacing((IBlockReader)world, cratePos, AtumBlocks.DEADWOOD_CRATE.func_176223_P(), AtumBlocks.DEADWOOD_CRATE), 2);
                    LockableLootTileEntity.func_195479_a((IBlockReader)world, (Random)rand, (BlockPos)cratePos, (ResourceLocation)AtumLootTables.CRATE);
                    continue block6;
                }
            }
            world.func_180501_a(pos, Blocks.field_150474_ac.func_176223_P(), 2);
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof MobSpawnerTileEntity) {
                ((MobSpawnerTileEntity)tileEntity).func_145881_a().func_200876_a(this.getRandomDungeonMob(rand));
            } else {
                Atum.LOG.error("Failed to fetch mob spawner entity at ({}, {}, {})", (Object)pos.func_177958_n(), (Object)pos.func_177956_o(), (Object)pos.func_177952_p());
            }
            return true;
        }
        return false;
    }

    private EntityType<?> getRandomDungeonMob(Random rand) {
        int chance = MathHelper.func_76136_a((Random)rand, (int)0, (int)5);
        switch (chance) {
            case 0: {
                return AtumEntities.WRAITH;
            }
            case 1: {
                return AtumEntities.STONEGUARD;
            }
            case 2: {
                return AtumEntities.MUMMY;
            }
            case 3: {
                return AtumEntities.BONESTORM;
            }
            case 4: {
                return AtumEntities.TARANTULA;
            }
        }
        return AtumEntities.FORSAKEN;
    }
}

