/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.gen.layer;

import com.teammetallurgy.atum.world.gen.AtumGenSettings;
import com.teammetallurgy.atum.world.gen.layer.AtumBiomeLayer;
import com.teammetallurgy.atum.world.gen.layer.AtumRiverLayer;
import com.teammetallurgy.atum.world.gen.layer.AtumRiverMixLayer;
import com.teammetallurgy.atum.world.gen.layer.OasisLayer;
import java.util.function.LongFunction;
import net.minecraft.world.WorldType;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.LazyAreaLayerContext;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.layer.EdgeBiomeLayer;
import net.minecraft.world.gen.layer.EdgeLayer;
import net.minecraft.world.gen.layer.HillsLayer;
import net.minecraft.world.gen.layer.IslandLayer;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.LayerUtil;
import net.minecraft.world.gen.layer.SmoothLayer;
import net.minecraft.world.gen.layer.StartRiverLayer;
import net.minecraft.world.gen.layer.ZoomLayer;
import net.minecraft.world.gen.layer.traits.IAreaTransformer1;

public class AtumLayerUtil {
    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> buildAtumLayers(WorldType worldType, AtumGenSettings settings, LongFunction<C> context) {
        IAreaFactory layer = IslandLayer.INSTANCE.func_202823_a((IExtendedNoiseRandom)context.apply(1L));
        layer = ZoomLayer.FUZZY.func_202713_a((IExtendedNoiseRandom)context.apply(2000L), layer);
        layer = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)context.apply(2001L), layer);
        layer = EdgeLayer.CoolWarm.INSTANCE.func_202713_a((IExtendedNoiseRandom)context.apply(2L), layer);
        layer = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)context.apply(2002L), layer);
        layer = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)context.apply(2003L), layer);
        layer = LayerUtil.func_202829_a((long)1000L, (IAreaTransformer1)ZoomLayer.NORMAL, (IAreaFactory)layer, (int)0, context);
        int biomeSize = worldType == WorldType.field_77135_d ? 6 : settings.getBiomeSize();
        int riverSize = settings.getRiverSize();
        IAreaFactory zoomLayer = LayerUtil.func_202829_a((long)1000L, (IAreaTransformer1)ZoomLayer.NORMAL, (IAreaFactory)layer, (int)0, context);
        zoomLayer = StartRiverLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)context.apply(100L), zoomLayer);
        IAreaFactory biomeLayer = AtumLayerUtil.getBiomeLayer(layer, context);
        IAreaFactory zoomLayerNormal = LayerUtil.func_202829_a((long)1000L, (IAreaTransformer1)ZoomLayer.NORMAL, (IAreaFactory)zoomLayer, (int)2, context);
        biomeLayer = HillsLayer.INSTANCE.func_202707_a((IExtendedNoiseRandom)context.apply(1000L), biomeLayer, zoomLayerNormal);
        zoomLayer = LayerUtil.func_202829_a((long)1000L, (IAreaTransformer1)ZoomLayer.NORMAL, (IAreaFactory)zoomLayer, (int)2, context);
        zoomLayer = LayerUtil.func_202829_a((long)1000L, (IAreaTransformer1)ZoomLayer.NORMAL, (IAreaFactory)zoomLayer, (int)riverSize, context);
        zoomLayer = AtumRiverLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)context.apply(1L), zoomLayer);
        zoomLayer = SmoothLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)context.apply(1000L), zoomLayer);
        biomeLayer = OasisLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)context.apply(1001L), biomeLayer);
        for (int size = 0; size < biomeSize; ++size) {
            biomeLayer = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)context.apply(1000 + size), biomeLayer);
        }
        biomeLayer = SmoothLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)context.apply(1000L), biomeLayer);
        biomeLayer = AtumRiverMixLayer.INSTANCE.func_202707_a((IExtendedNoiseRandom)context.apply(100L), biomeLayer, zoomLayer);
        return biomeLayer;
    }

    private static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> getBiomeLayer(IAreaFactory<T> parentLayer, LongFunction<C> context) {
        parentLayer = new AtumBiomeLayer().func_202713_a((IExtendedNoiseRandom)context.apply(200L), parentLayer);
        parentLayer = LayerUtil.func_202829_a((long)1000L, (IAreaTransformer1)ZoomLayer.NORMAL, (IAreaFactory)parentLayer, (int)2, context);
        parentLayer = EdgeBiomeLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)context.apply(1000L), parentLayer);
        return parentLayer;
    }

    public static Layer getNoiseLayer(long seed, WorldType worldType, AtumGenSettings settings) {
        int maxCacheSize = 25;
        IAreaFactory layer = AtumLayerUtil.buildAtumLayers(worldType, settings, p_227473_2_ -> new LazyAreaLayerContext(maxCacheSize, seed, p_227473_2_));
        return new Layer(layer);
    }
}

