/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.teleporter;

import com.teammetallurgy.atum.blocks.PortalBlock;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumPointsOfInterest;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.village.PointOfInterest;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.minecraftforge.common.util.ITeleporter;

public class TeleporterAtum
implements ITeleporter {
    public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
        if (!TeleporterAtum.placeInPortal(destWorld, entity, yaw)) {
            TeleporterAtum.makePortal(destWorld, entity);
            TeleporterAtum.placeInPortal(destWorld, entity, yaw);
            return repositionEntity.apply(false);
        }
        TeleporterAtum.placeInPortal(destWorld, entity, yaw);
        return repositionEntity.apply(false);
    }

    public static boolean placeInPortal(ServerWorld world, Entity entity, float yaw) {
        Vec3d lastPortalVec = entity.func_181014_aG();
        Direction direction = entity.func_181012_aH();
        BlockPattern.PortalInfo portalInfo = TeleporterAtum.placeInExistingPortal(world, new BlockPos(entity), entity.func_213322_ci(), direction, lastPortalVec.field_72450_a, lastPortalVec.field_72448_b, entity instanceof PlayerEntity);
        if (portalInfo == null) {
            return false;
        }
        Vec3d vec3d1 = portalInfo.field_222505_a;
        Vec3d vec3d2 = portalInfo.field_222506_b;
        entity.func_213317_d(vec3d2);
        entity.field_70177_z = yaw + (float)portalInfo.field_222507_c;
        entity.func_225653_b_(vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c);
        return true;
    }

    @Nullable
    public static BlockPattern.PortalInfo placeInExistingPortal(ServerWorld world, @Nonnull BlockPos pos, @Nonnull Vec3d portalPos, @Nonnull Direction direction, double d, double d1, boolean b) {
        PointOfInterestManager poiManager = world.func_217443_B();
        poiManager.func_226347_a_((IWorldReader)world, pos, 128);
        List list = poiManager.func_226353_b_(poi -> poi == AtumPointsOfInterest.PORTAL, pos, 128, PointOfInterestManager.Status.ANY).collect(Collectors.toList());
        Optional<PointOfInterest> optional = list.stream().min(Comparator.comparingDouble(poi -> poi.func_218261_f().func_177951_i((Vec3i)pos)).thenComparingInt(poi -> poi.func_218261_f().func_177956_o()));
        return optional.map(poi -> {
            BlockPos posPos = poi.func_218261_f();
            world.func_72863_F().func_217228_a(TicketType.field_219493_f, new ChunkPos(posPos), 3, (Object)posPos);
            BlockPattern.PatternHelper patternHelper = PortalBlock.createPatternHelper((IWorld)world, posPos);
            return patternHelper.func_222504_a(direction, posPos, d1, portalPos, d);
        }).orElse(null);
    }

    public static void makePortal(ServerWorld world, @Nonnull Entity entity) {
        TeleporterAtum.createPortal((World)world, new BlockPos(MathHelper.func_76128_c((double)entity.func_226277_ct_()), MathHelper.func_76128_c((double)entity.func_226278_cu_()), MathHelper.func_76128_c((double)entity.func_226281_cx_())), entity);
    }

    public static void createPortal(World world, BlockPos pos, @Nullable Entity entity) {
        BlockState portalState = AtumBlocks.PORTAL.func_176223_P();
        while (pos.func_177956_o() > 1 && world.func_175623_d(pos)) {
            pos = pos.func_177977_b();
        }
        while (!(world.func_175623_d(pos.func_177984_a()) || world.func_180495_p(pos).func_177230_c() == AtumBlocks.SAND && world.func_180495_p(pos).func_177230_c() == Blocks.field_150349_c)) {
            pos = pos.func_177984_a();
        }
        BlockState sandState = entity != null && entity.field_71093_bK == DimensionType.field_223227_a_ ? Blocks.field_150322_A.func_176223_P() : AtumBlocks.LIMESTONE_BRICK_LARGE.func_176223_P();
        for (BlockPos basePos : BlockPos.Mutable.func_218278_a((BlockPos)pos.func_177982_a(-2, 0, -2), (BlockPos)pos.func_177982_a(2, 1, 2))) {
            world.func_180501_a(basePos, sandState, 2);
        }
        for (int y = 2; y < 4; ++y) {
            world.func_180501_a(pos.func_177982_a(-2, y, -2), sandState, 2);
            world.func_180501_a(pos.func_177982_a(2, y, -2), sandState, 2);
            world.func_180501_a(pos.func_177982_a(-2, y, 2), sandState, 2);
            world.func_180501_a(pos.func_177982_a(2, y, 2), sandState, 2);
        }
        for (BlockPos portalPos : BlockPos.Mutable.func_218278_a((BlockPos)pos.func_177982_a(-1, 1, -1), (BlockPos)pos.func_177982_a(1, 1, 1))) {
            world.func_180501_a(portalPos, portalState, 2);
        }
        for (BlockPos airPos : BlockPos.Mutable.func_218278_a((BlockPos)pos.func_177982_a(-2, 2, -1), (BlockPos)pos.func_177982_a(2, 3, 1))) {
            world.func_180501_a(airPos, Blocks.field_150350_a.func_176223_P(), 2);
        }
    }
}

