/*
 * Decompiled with CFR 0.152.
 */
package vazkii.akashictome;

import java.util.List;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import vazkii.akashictome.ConfigHandler;
import vazkii.akashictome.ModItems;
import vazkii.akashictome.MorphingHandler;
import vazkii.akashictome.RecipeSerializer;

public class AttachementRecipe
extends SpecialRecipe {
    public AttachementRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public boolean matches(CraftingInventory var1, World var2) {
        boolean foundTool = false;
        boolean foundTarget = false;
        for (int i = 0; i < var1.func_70302_i_(); ++i) {
            ItemStack stack = var1.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (this.isTarget(stack)) {
                if (foundTarget) {
                    return false;
                }
                foundTarget = true;
                continue;
            }
            if (stack.func_77973_b() == ModItems.tome) {
                if (foundTool) {
                    return false;
                }
                foundTool = true;
                continue;
            }
            return false;
        }
        return foundTool && foundTarget;
    }

    public ItemStack getCraftingResult(CraftingInventory var1) {
        String mod;
        CompoundNBT morphData;
        ItemStack tool = ItemStack.field_190927_a;
        ItemStack target = ItemStack.field_190927_a;
        for (int i = 0; i < var1.func_70302_i_(); ++i) {
            ItemStack stack = var1.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() == ModItems.tome) {
                tool = stack;
                continue;
            }
            target = stack;
        }
        ItemStack copy = tool.func_77946_l();
        CompoundNBT cmp = copy.func_77978_p();
        if (cmp == null) {
            cmp = new CompoundNBT();
            copy.func_77982_d(cmp);
        }
        if (!cmp.func_74764_b("akashictome:data")) {
            cmp.func_218657_a("akashictome:data", (INBT)new CompoundNBT());
        }
        if ((morphData = cmp.func_74775_l("akashictome:data")).func_74764_b(mod = MorphingHandler.getModFromStack(target))) {
            return ItemStack.field_190927_a;
        }
        CompoundNBT modCmp = new CompoundNBT();
        target.func_77955_b(modCmp);
        morphData.func_218657_a(mod, (INBT)modCmp);
        return copy;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public boolean isTarget(ItemStack stack) {
        if (stack.func_190926_b() || MorphingHandler.isAkashicTome(stack)) {
            return false;
        }
        String mod = MorphingHandler.getModFromStack(stack);
        if (mod.equals("minecraft")) {
            return false;
        }
        if (((Boolean)ConfigHandler.allItems.get()).booleanValue()) {
            return true;
        }
        if (((List)ConfigHandler.blacklistedMods.get()).contains(mod)) {
            return false;
        }
        ResourceLocation registryNameRL = stack.func_77973_b().getRegistryName();
        String registryName = registryNameRL.toString();
        if (((List)ConfigHandler.whitelistedItems.get()).contains(registryName) || ((List)ConfigHandler.whitelistedItems.get()).contains(registryName + ":" + stack.func_77952_i())) {
            return true;
        }
        String itemName = registryNameRL.func_110623_a().toLowerCase();
        for (String s : (List)ConfigHandler.whitelistedNames.get()) {
            if (!itemName.contains(s.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        return NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return RecipeSerializer.ATTACHMENT;
    }
}

