/*
 * Decompiled with CFR 0.152.
 */
package vazkii.akashictome.client;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import net.minecraft.client.MainWindow;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.model.BookModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import vazkii.akashictome.AkashicTome;
import vazkii.akashictome.MorphingHandler;
import vazkii.akashictome.network.MessageMorphTome;
import vazkii.arl.util.ItemNBTHelper;

public class TomeScreen
extends Screen {
    private static final ResourceLocation BOOK_TEXTURE = new ResourceLocation("akashictome:textures/models/book.png");
    private static final BookModel BOOK_MODEL = new BookModel();
    final ItemStack tome;
    String definedMod;

    public TomeScreen(ItemStack tome) {
        super((ITextComponent)new StringTextComponent(""));
        this.tome = tome;
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        if (p_mouseClicked_5_ == 0 && this.definedMod != null) {
            AkashicTome.sendToServer(new MessageMorphTome(this.definedMod));
            this.minecraft.func_147108_a(null);
            return true;
        }
        return super.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.definedMod = null;
        super.render(mouseX, mouseY, partialTicks);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (this.tome.func_77942_o()) {
            CompoundNBT data = this.tome.func_77978_p().func_74775_l("akashictome:data");
            ArrayList keys = Lists.newArrayList((Iterable)data.func_150296_c());
            Collections.sort(keys);
            for (String s : keys) {
                CompoundNBT cmp = data.func_74775_l(s);
                if (cmp == null) continue;
                ItemStack modStack = ItemStack.func_199557_a((CompoundNBT)cmp);
                stacks.add(modStack);
            }
        }
        MainWindow window = this.minecraft.func_228018_at_();
        int centerX = window.func_198107_o() / 2;
        int centerY = window.func_198087_p() / 2;
        int amountPerRow = 6;
        int rows = stacks.size() / amountPerRow + 1;
        int iconSize = 20;
        int startX = centerX - amountPerRow * iconSize / 2;
        int startY = centerY - rows * iconSize + 45;
        int padding = 4;
        int extra = 2;
        TomeScreen.fill((int)(startX - padding), (int)(startY - padding), (int)(startX + iconSize * amountPerRow + padding), (int)(startY + iconSize * rows + padding), (int)0x22000000);
        TomeScreen.fill((int)(startX - padding - extra), (int)(startY - padding - extra), (int)(startX + iconSize * amountPerRow + padding + extra), (int)(startY + iconSize * rows + padding + extra), (int)0x22000000);
        ItemStack tooltipStack = ItemStack.field_190927_a;
        if (!stacks.isEmpty()) {
            RenderHelper.func_227780_a_();
            for (int i = 0; i < stacks.size(); ++i) {
                int x = startX + i % amountPerRow * iconSize;
                int y = startY + i / amountPerRow * iconSize;
                ItemStack stack = (ItemStack)stacks.get(i);
                if (mouseX > x && mouseY > y && mouseX <= x + 16 && mouseY <= y + 16) {
                    tooltipStack = stack;
                    y -= 2;
                }
                this.minecraft.func_175599_af().func_180450_b(stack, x, y);
            }
            RenderHelper.func_74518_a();
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.matrixMode((int)5889);
        RenderSystem.pushMatrix();
        RenderSystem.loadIdentity();
        int k = (int)this.minecraft.func_228018_at_().func_198100_s();
        RenderSystem.viewport((int)((this.width - 320) / 2 * k), (int)((this.height - 240) / 2 * k), (int)(320 * k), (int)(240 * k));
        RenderSystem.translatef((float)0.0f, (float)-0.9f, (float)0.0f);
        RenderSystem.multMatrix((Matrix4f)Matrix4f.func_195876_a((double)90.0, (float)1.3333334f, (float)9.0f, (float)80.0f));
        RenderSystem.matrixMode((int)5888);
        MatrixStack matrixstack = new MatrixStack();
        matrixstack.func_227860_a_();
        MatrixStack.Entry matrixstack$entry = matrixstack.func_227866_c_();
        matrixstack$entry.func_227870_a_().func_226591_a_();
        matrixstack$entry.func_227872_b_().func_226119_c_();
        matrixstack.func_227861_a_(0.0, (double)3.3f, 1984.0);
        float scale = 20.0f;
        matrixstack.func_227862_a_(scale, scale, scale);
        matrixstack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        matrixstack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(50.0f));
        matrixstack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(270.0f));
        RenderSystem.enableRescaleNormal();
        BOOK_MODEL.func_228247_a_(0.0f, 1.0f, 0.0f, 1.0f);
        IRenderTypeBuffer.Impl irendertypebuffer$impl = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        IVertexBuilder ivertexbuilder = irendertypebuffer$impl.getBuffer(BOOK_MODEL.func_228282_a_(BOOK_TEXTURE));
        BOOK_MODEL.func_225598_a_(matrixstack, ivertexbuilder, 0xF000F0, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        irendertypebuffer$impl.func_228461_a_();
        matrixstack.func_227865_b_();
        RenderSystem.matrixMode((int)5889);
        RenderSystem.viewport((int)0, (int)0, (int)this.minecraft.func_228018_at_().func_198109_k(), (int)this.minecraft.func_228018_at_().func_198091_l());
        RenderSystem.popMatrix();
        RenderSystem.matrixMode((int)5888);
        RenderHelper.func_227784_d_();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!tooltipStack.func_190926_b()) {
            String name = ItemNBTHelper.getString((ItemStack)tooltipStack, (String)"akashictome:displayName", (String)ITextComponent.Serializer.func_150696_a((ITextComponent)tooltipStack.func_200301_q()));
            String tempDefinedMod = MorphingHandler.getModFromStack(tooltipStack);
            String mod = TextFormatting.GRAY + MorphingHandler.getModNameForId(tempDefinedMod);
            tempDefinedMod = ItemNBTHelper.getString((ItemStack)tooltipStack, (String)"akashictome:definedMod", (String)tempDefinedMod);
            String trueName = ITextComponent.Serializer.func_150699_a((String)name).getString();
            vazkii.arl.util.RenderHelper.renderTooltip((int)mouseX, (int)mouseY, Arrays.asList(trueName, mod));
            this.definedMod = tempDefinedMod;
        }
    }
}

