/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.betterburning;

import net.darkhax.betterburning.Configuration;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;

@Mod(value="betterburning")
public class BetterBurning {
    private final Configuration configuration = new Configuration();

    public BetterBurning() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, this.configuration.getSpec());
        MinecraftForge.EVENT_BUS.addListener(this::onLivingDeath);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityJoinWorld);
        MinecraftForge.EVENT_BUS.addListener(this::onLivingTick);
        MinecraftForge.EVENT_BUS.addListener(this::onLivingAttack);
    }

    private void onLivingDeath(LivingDeathEvent event) {
        if (event.getSource().func_76347_k() && this.configuration.shouldDamageSourceCauseFire() && !event.getEntityLiving().func_70027_ad() && !event.getEntity().field_70170_p.field_72995_K) {
            event.getEntityLiving().func_70015_d(1);
        }
    }

    private void onEntityJoinWorld(EntityJoinWorldEvent event) {
        ArrowEntity arrowEntity;
        Entity shooter;
        if (this.configuration.shouldSkeletonsShootFireArrows() && event.getEntity() instanceof ArrowEntity && !event.getEntity().field_70170_p.field_72995_K && (shooter = (arrowEntity = (ArrowEntity)event.getEntity()).func_212360_k()) instanceof AbstractSkeletonEntity && shooter.func_70027_ad() && shooter.func_70089_S() && this.tryPercentage(this.configuration.getSkeletonFlameArrowChance())) {
            arrowEntity.func_70015_d(shooter.func_223314_ad());
        }
    }

    private void onLivingTick(LivingEvent.LivingUpdateEvent event) {
        if (this.configuration.shouldFireResExtinguish() && !event.getEntityLiving().field_70170_p.field_72995_K && event.getEntityLiving().func_70027_ad() && event.getEntityLiving().func_70644_a(Effects.field_76426_n)) {
            event.getEntityLiving().func_70066_B();
        }
    }

    private void onLivingAttack(LivingAttackEvent event) {
        Entity sourceEntity;
        if (this.configuration.shouldFireDamageSpread() && !event.getEntity().field_70170_p.field_72995_K && (sourceEntity = event.getSource().func_76346_g()) instanceof LivingEntity) {
            LivingEntity sourceLiving = (LivingEntity)sourceEntity;
            ItemStack heldItem = sourceLiving.func_184614_ca();
            if (!(sourceLiving instanceof ZombieEntity) && heldItem.func_190926_b() && sourceLiving.func_70027_ad() && this.tryPercentage(this.configuration.getFireDamageSpreadChance())) {
                float damage = Math.max(1.0f, event.getEntityLiving().field_70170_p.func_175649_E(new BlockPos(event.getEntity())).func_180168_b());
                event.getEntityLiving().func_70015_d(2 * (int)damage);
            } else if (heldItem.func_77973_b() == Items.field_151033_d && this.configuration.shouldFlintAndSteelDoFireDamage()) {
                event.getEntityLiving().func_70015_d(this.configuration.getFlintAndSteelFireDamage());
                ServerPlayerEntity player = sourceLiving instanceof ServerPlayerEntity ? (ServerPlayerEntity)sourceLiving : null;
                heldItem.func_96631_a(1, sourceLiving.func_70681_au(), player);
            }
        }
    }

    private boolean tryPercentage(double chance) {
        return Math.random() < chance;
    }
}

