/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.betterburning;

import net.minecraftforge.common.ForgeConfigSpec;

public class Configuration {
    private final ForgeConfigSpec spec;
    private final ForgeConfigSpec.BooleanValue fireResExtinguish;
    private final ForgeConfigSpec.BooleanValue fireFromDamagesource;
    private final ForgeConfigSpec.BooleanValue fireDamageSpreads;
    private final ForgeConfigSpec.DoubleValue fireDamageSpreadChance;
    private final ForgeConfigSpec.BooleanValue flameArrowSkeletons;
    private final ForgeConfigSpec.ConfigValue<Double> flameArrowChance;
    private final ForgeConfigSpec.BooleanValue flintAndSteelDealsFireDamage;
    private final ForgeConfigSpec.IntValue flintAndSteelFireDamage;

    public Configuration() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("General settings for the mod.");
        builder.push("general");
        builder.comment("Should having fire resistance stop things from being on fire visually?");
        this.fireResExtinguish = builder.define("fireResistanceExtinguish", true);
        builder.comment("Fixes some fire related damage sources not causing mobs to drop cooked items?");
        this.fireFromDamagesource = builder.define("fireFromDamagesource", true);
        builder.comment("Should fire damage spread between mobs when they hurt eachother? Zombies already do this and won't be changed.");
        this.fireDamageSpreads = builder.define("fireDamageSpreads", true);
        builder.comment("What is the % chance that fire damage will spread between mobs?");
        this.fireDamageSpreadChance = builder.defineInRange("fireDamageSpreadChance", 0.3, 0.0, 1.0);
        builder.comment("Should skeletons shoot flaming arrows while on fire?");
        this.flameArrowSkeletons = builder.define("flameArrowSkeletons", true);
        builder.comment("What is the % chance skeletons will shoot flaming arrows while on fire?");
        this.flameArrowChance = builder.defineInRange("flameArrowSkeletonChance", 0.7, 0.0, 1.0);
        builder.comment("Should flint and steel deal fire damage when used as a weapon?");
        this.flintAndSteelDealsFireDamage = builder.define("ShouldFlintAndSteelDoFireDamage", true);
        builder.comment("How much fire damage should flint and steel do?");
        this.flintAndSteelFireDamage = builder.defineInRange("flintAndSteelFireDamage", 3, 0, Integer.MAX_VALUE);
        this.spec = builder.build();
    }

    public ForgeConfigSpec getSpec() {
        return this.spec;
    }

    public boolean shouldFireResExtinguish() {
        return (Boolean)this.fireResExtinguish.get();
    }

    public boolean shouldDamageSourceCauseFire() {
        return (Boolean)this.fireFromDamagesource.get();
    }

    public boolean shouldFireDamageSpread() {
        return (Boolean)this.fireDamageSpreads.get();
    }

    public double getFireDamageSpreadChance() {
        return (Double)this.fireDamageSpreadChance.get();
    }

    public boolean shouldSkeletonsShootFireArrows() {
        return (Boolean)this.flameArrowSkeletons.get();
    }

    public double getSkeletonFlameArrowChance() {
        return (Double)this.flameArrowChance.get();
    }

    public boolean shouldFlintAndSteelDoFireDamage() {
        return (Boolean)this.flintAndSteelDealsFireDamage.get();
    }

    public int getFlintAndSteelFireDamage() {
        return (Integer)this.flintAndSteelFireDamage.get();
    }
}

