/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block;

import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.config.WaystoneConfig;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WarpMode;
import net.blay09.mods.waystones.core.WaystoneEditPermissions;
import net.blay09.mods.waystones.core.WaystoneManager;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.blay09.mods.waystones.tileentity.WaystoneTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ObserverBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class WaystoneBlock
extends Block {
    private static final VoxelShape RENDER_SHAPE = VoxelShapes.func_197873_a((double)0.0625, (double)0.0625, (double)0.0625, (double)0.9375, (double)0.9375, (double)0.9375);
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.field_208163_P;

    public WaystoneBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200947_a(SoundType.field_185851_d).func_200948_a(5.0f, 2000.0f));
    }

    public VoxelShape func_196247_c(BlockState p_196247_1_, IBlockReader p_196247_2_, BlockPos p_196247_3_) {
        return RENDER_SHAPE;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
        builder.func_206894_a(new IProperty[]{HALF});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new WaystoneTileEntity();
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader world, BlockPos pos) {
        if (!PlayerWaystoneManager.mayBreakWaystone(player, world, pos)) {
            return -1.0f;
        }
        return super.func_180647_a(state, player, world, pos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        Block blockBelow = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (blockBelow == this) {
            return false;
        }
        Block blockTwoAbove = world.func_180495_p(pos.func_177981_b(2)).func_177230_c();
        BlockState stateAbove = world.func_180495_p(pos.func_177984_a());
        return blockTwoAbove != this && stateAbove.isAir((IBlockReader)world, pos.func_177984_a());
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        if (!PlayerWaystoneManager.mayPlaceWaystone(context.func_195999_j())) {
            return null;
        }
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity waystoneTileEntity;
        BlockPos posAbove = pos.func_177984_a();
        if (!world.field_72995_K) {
            world.func_175656_a(posAbove, (BlockState)this.func_176223_P().func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER));
        }
        if ((waystoneTileEntity = world.func_175625_s(pos)) instanceof WaystoneTileEntity) {
            ((WaystoneTileEntity)waystoneTileEntity).initializeWaystone((IWorld)world, placer, false);
            TileEntity waystoneTileEntityAbove = world.func_175625_s(posAbove);
            if (waystoneTileEntityAbove instanceof WaystoneTileEntity) {
                ((WaystoneTileEntity)waystoneTileEntityAbove).initializeFromBase((WaystoneTileEntity)waystoneTileEntity);
            }
        }
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        WaystoneTileEntity tileEntity = (WaystoneTileEntity)world.func_175625_s(pos);
        if (tileEntity != null) {
            IWaystone waystone = tileEntity.getWaystone();
            WaystoneManager.get().removeWaystone(waystone);
            PlayerWaystoneManager.removeKnownWaystone(waystone);
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
        if (world.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
            world.func_217377_a(pos.func_177984_a(), false);
        } else if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
            world.func_217377_a(pos.func_177977_b(), false);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        WaystoneTileEntity tileEntity = (WaystoneTileEntity)world.func_175625_s(pos);
        if (tileEntity == null) {
            return ActionResultType.FAIL;
        }
        if (player.field_71075_bZ.field_75098_d) {
            ItemStack heldItem = player.func_184586_b(hand);
            if (heldItem.func_77973_b() == Items.field_222068_kQ) {
                if (!world.field_72995_K) {
                    tileEntity.uninitializeWaystone();
                    player.func_146105_b((ITextComponent)new StringTextComponent("Waystone was successfully reset - it will re-initialize once it is next loaded."), false);
                }
                return ActionResultType.SUCCESS;
            }
            if (heldItem.func_77973_b() == Items.field_151055_y) {
                if (!world.field_72995_K) {
                    player.func_146105_b((ITextComponent)new StringTextComponent("Waystone UUID: " + tileEntity.getWaystone().getWaystoneUid()), false);
                }
                return ActionResultType.SUCCESS;
            }
        }
        IWaystone waystone = tileEntity.getWaystone();
        if (player.func_225608_bj_()) {
            WaystoneEditPermissions result = PlayerWaystoneManager.mayEditWaystone(player, world, waystone);
            if (result != WaystoneEditPermissions.ALLOW) {
                if (result.getLangKey() != null) {
                    TranslationTextComponent chatComponent = new TranslationTextComponent(result.getLangKey(), new Object[0]);
                    chatComponent.func_150256_b().func_150238_a(TextFormatting.RED);
                    player.func_146105_b((ITextComponent)chatComponent, true);
                }
                return ActionResultType.SUCCESS;
            }
            if (!world.field_72995_K) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)tileEntity.getWaystoneSettingsContainerProvider(), (BlockPos)pos);
            }
            return ActionResultType.SUCCESS;
        }
        boolean isActivated = PlayerWaystoneManager.isWaystoneActivated(player, waystone);
        if (isActivated) {
            if (!world.field_72995_K) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)tileEntity.getWaystoneSelectionContainerProvider(), it -> {
                    it.writeByte(WarpMode.WAYSTONE_TO_WAYSTONE.ordinal());
                    it.func_179255_a(pos);
                });
            }
        } else {
            PlayerWaystoneManager.activateWaystone(player, waystone);
            if (!world.field_72995_K) {
                StringTextComponent nameComponent = new StringTextComponent(waystone.getName());
                nameComponent.func_150256_b().func_150238_a(TextFormatting.WHITE);
                TranslationTextComponent chatComponent = new TranslationTextComponent("chat.waystones.waystone_activated", new Object[]{nameComponent});
                chatComponent.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                player.func_145747_a((ITextComponent)chatComponent);
                WaystoneSyncManager.sendKnownWaystones(player);
            }
            this.notifyObserversOfActivation(world, pos);
            if (world.field_72995_K) {
                Waystones.proxy.playSound(SoundEvents.field_187802_ec, pos, 1.0f);
                for (int i = 0; i < 32; ++i) {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197623_p, (double)pos.func_177958_n() + 0.5 + (world.field_73012_v.nextDouble() - 0.5) * 2.0, (double)(pos.func_177956_o() + 3), (double)pos.func_177952_p() + 0.5 + (world.field_73012_v.nextDouble() - 0.5) * 2.0, 0.0, -5.0, 0.0);
                    world.func_195594_a((IParticleData)ParticleTypes.field_197623_p, (double)pos.func_177958_n() + 0.5 + (world.field_73012_v.nextDouble() - 0.5) * 2.0, (double)(pos.func_177956_o() + 4), (double)pos.func_177952_p() + 0.5 + (world.field_73012_v.nextDouble() - 0.5) * 2.0, 0.0, -5.0, 0.0);
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    private void notifyObserversOfActivation(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            for (Direction direction : Direction.values()) {
                BlockPos offset = pos.func_177972_a(direction);
                BlockState neighbourState = world.func_180495_p(offset);
                Block neighbourBlock = neighbourState.func_177230_c();
                if (!(neighbourBlock instanceof ObserverBlock) || neighbourState.func_177229_b((IProperty)ObserverBlock.field_176387_N) != direction.func_176734_d() || world.func_205220_G_().func_205359_a(offset, (Object)neighbourBlock)) continue;
                world.func_205220_G_().func_205360_a(offset, (Object)neighbourBlock, 2);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
        if (!((Boolean)WaystoneConfig.CLIENT.disableParticles.get()).booleanValue() && random.nextFloat() < 0.75f) {
            WaystoneTileEntity tileEntity = (WaystoneTileEntity)world.func_175625_s(pos);
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (tileEntity != null && PlayerWaystoneManager.isWaystoneActivated((PlayerEntity)Objects.requireNonNull(player), tileEntity.getWaystone())) {
                world.func_195594_a((IParticleData)ParticleTypes.field_197599_J, (double)pos.func_177958_n() + 0.5 + (random.nextDouble() - 0.5) * 1.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5 + (random.nextDouble() - 0.5) * 1.5, 0.0, 0.0, 0.0);
                world.func_195594_a((IParticleData)ParticleTypes.field_197623_p, (double)pos.func_177958_n() + 0.5 + (random.nextDouble() - 0.5) * 1.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5 + (random.nextDouble() - 0.5) * 1.5, 0.0, 0.0, 0.0);
            }
        }
    }
}

