/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.network.message;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.core.InMemoryPlayerWaystoneData;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.Waystone;
import net.blay09.mods.waystones.core.WaystoneManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class PlayerKnownWaystonesMessage {
    private final List<IWaystone> waystones;

    public PlayerKnownWaystonesMessage(List<IWaystone> waystones) {
        this.waystones = waystones;
    }

    public static void encode(PlayerKnownWaystonesMessage message, PacketBuffer buf) {
        buf.writeShort(message.waystones.size());
        for (IWaystone waystone : message.waystones) {
            buf.func_179252_a(waystone.getWaystoneUid());
            buf.func_180714_a(waystone.getName());
            buf.writeBoolean(waystone.isGlobal());
            buf.writeInt(waystone.getDimensionType().func_186068_a());
            buf.func_179255_a(waystone.getPos());
        }
    }

    public static PlayerKnownWaystonesMessage decode(PacketBuffer buf) {
        int waystoneCount = buf.readShort();
        ArrayList<IWaystone> waystones = new ArrayList<IWaystone>();
        for (int i = 0; i < waystoneCount; ++i) {
            UUID waystoneUid = buf.func_179253_g();
            String name = buf.func_218666_n();
            boolean isGlobal = buf.readBoolean();
            DimensionType dimensionType = DimensionType.func_186069_a((int)buf.readInt());
            if (dimensionType == null) {
                dimensionType = DimensionType.field_223227_a_;
            }
            BlockPos pos = buf.func_179259_c();
            Waystone waystone = new Waystone(waystoneUid, dimensionType, pos, false, null);
            waystone.setName(name);
            waystone.setGlobal(isGlobal);
            waystones.add(waystone);
        }
        return new PlayerKnownWaystonesMessage(waystones);
    }

    public static void handle(PlayerKnownWaystonesMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            InMemoryPlayerWaystoneData playerWaystoneData = (InMemoryPlayerWaystoneData)PlayerWaystoneManager.getPlayerWaystoneData(LogicalSide.CLIENT);
            playerWaystoneData.setWaystones(message.waystones);
            for (IWaystone waystone : message.waystones) {
                WaystoneManager.get().updateWaystone(waystone);
            }
        });
        context.setPacketHandled(true);
    }
}

