/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.worldgen;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.blay09.mods.waystones.block.WaystoneBlock;
import net.blay09.mods.waystones.tileentity.WaystoneTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class WaystoneFeature
extends Feature<NoFeatureConfig> {
    private final BlockState waystoneState;

    public WaystoneFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> configFactory, BlockState waystoneState) {
        super(configFactory);
        this.waystoneState = waystoneState;
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        Direction facing = Direction.values()[2 + rand.nextInt(4)];
        BlockState state = world.func_180495_p(pos);
        BlockPos posAbove = pos.func_177984_a();
        BlockState stateAbove = world.func_180495_p(posAbove);
        if (state.isAir((IBlockReader)world, pos) && stateAbove.isAir((IBlockReader)world, posAbove)) {
            world.func_180501_a(pos, (BlockState)((BlockState)this.waystoneState.func_206870_a(WaystoneBlock.HALF, (Comparable)DoubleBlockHalf.LOWER)).func_206870_a((IProperty)WaystoneBlock.FACING, (Comparable)facing), 2);
            world.func_180501_a(posAbove, (BlockState)((BlockState)this.waystoneState.func_206870_a(WaystoneBlock.HALF, (Comparable)DoubleBlockHalf.UPPER)).func_206870_a((IProperty)WaystoneBlock.FACING, (Comparable)facing), 2);
            WaystoneTileEntity tileEntity = (WaystoneTileEntity)world.func_175625_s(pos);
            if (tileEntity != null) {
                tileEntity.initializeWaystone(world, null, true);
                TileEntity tileEntityAbove = world.func_175625_s(pos.func_177984_a());
                if (tileEntityAbove instanceof WaystoneTileEntity) {
                    ((WaystoneTileEntity)tileEntityAbove).initializeFromBase(tileEntity);
                }
            }
            return true;
        }
        return false;
    }
}

