/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.equiptooltips;

import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.silentchaos512.equiptooltips.Config;
import net.silentchaos512.equiptooltips.EquipmentStats;
import net.silentchaos512.equiptooltips.ItemStat;
import net.silentchaos512.equiptooltips.ItemType;
import net.silentchaos512.utils.MathUtils;

public class TooltipHandler
extends AbstractGui {
    public static final ResourceLocation TEXTURE = new ResourceLocation("equipmenttooltips", "textures/gui/hud.png");
    public static final TooltipHandler INSTANCE = new TooltipHandler();
    private int lastWidth = 0;
    public final boolean isTinkersLoaded;
    private static final String FORMAT_INT = "%d";
    private static final String FORMAT_FLOAT = "%.2f";

    public TooltipHandler() {
        this.isTinkersLoaded = false;
    }

    private static boolean isShiftDown() {
        long handle = Minecraft.func_71410_x().func_228018_at_().func_198092_i();
        return InputMappings.func_216506_a((long)handle, (int)340) || InputMappings.func_216506_a((long)handle, (int)344);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRenderTooltip(RenderTooltipEvent.PostText event) {
        ItemStack stack;
        if (((Boolean)Config.CLIENT.checkShiftKey.get()).booleanValue()) {
            boolean shiftPressed = TooltipHandler.isShiftDown();
            boolean hideOnShift = (Boolean)Config.CLIENT.hideOnShift.get();
            if (hideOnShift && shiftPressed || !hideOnShift && !shiftPressed) {
                return;
            }
        }
        if ((stack = event.getStack()).func_190926_b()) {
            return;
        }
        EquipmentStats hoveredStats = new EquipmentStats(stack);
        if (hoveredStats.getItemType() == ItemType.UNKNOWN) {
            return;
        }
        this.renderBackground(event);
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer fontRenderer = event.getFontRenderer();
        if (mc.field_71439_g == null) {
            return;
        }
        ItemStack currentEquip = TooltipHandler.getEquippedItem((PlayerEntity)mc.field_71439_g, stack, hoveredStats);
        EquipmentStats equippedStats = currentEquip.func_190926_b() ? null : new EquipmentStats(currentEquip);
        double scale = 0.75;
        int x = (int)((double)(event.getX() + (Integer)Config.CLIENT.offsetX.get()) / scale);
        int y = (int)((double)(event.getY() - 16 + (Integer)Config.CLIENT.offsetY.get()) / scale);
        if (((Boolean)Config.CLIENT.positionOnBottom.get()).booleanValue()) {
            y = (int)((double)y + ((double)event.getHeight() / scale + 28.0));
        }
        RenderSystem.pushMatrix();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.scaled((double)scale, (double)scale, (double)scale);
        mc.field_71446_o.func_110577_a(TEXTURE);
        for (ItemStat stat : hoveredStats.getItemType().displayStats) {
            if (!stat.shouldRender(hoveredStats)) continue;
            x = this.renderStat(mc, fontRenderer, x, y, stat, hoveredStats, equippedStats);
        }
        this.lastWidth = (int)((double)x * scale - (double)event.getX());
        RenderSystem.popMatrix();
    }

    private static ItemStack getEquippedItem(PlayerEntity player, ItemStack hoveredItem, EquipmentStats hoveredStats) {
        if (hoveredStats.getItemType() == ItemType.ARMOR) {
            EquipmentSlotType slot = ((ArmorItem)hoveredItem.func_77973_b()).func_185083_B_();
            for (ItemStack itemstack : player.func_184193_aE()) {
                Item item = itemstack.func_77973_b();
                if (itemstack.func_190926_b() || !(item instanceof ArmorItem) || ((ArmorItem)item).func_185083_B_() != slot) continue;
                return itemstack;
            }
        } else if (hoveredStats.getItemType() != ItemType.SGEAR_PART) {
            return player.func_184614_ca();
        }
        return ItemStack.field_190927_a;
    }

    private int renderStat(Minecraft mc, FontRenderer fontRenderer, int x, int y, ItemStat stat, EquipmentStats hovered, @Nullable EquipmentStats equipped) {
        if (!stat.shouldRender(hovered)) {
            return x;
        }
        mc.field_71446_o.func_110577_a(TEXTURE);
        this.blit(x, y, 16 * stat.iconIndex, 240, 16, 16);
        float hoveredStat = hovered.getStat(stat);
        float equippedStat = equipped == null ? stat.defaultValue : equipped.getStat(stat);
        String text = TooltipHandler.formatStat(hoveredStat);
        RenderSystem.pushMatrix();
        fontRenderer.func_175063_a(text, (float)(x += 18), (float)(y + 5), 0xFFFFFF);
        RenderSystem.popMatrix();
        x += fontRenderer.func_78256_a(text);
        mc.field_71446_o.func_110577_a(TEXTURE);
        if (equipped == null || hovered.getItemType() != equipped.getItemType()) {
            x += 5;
        } else if (hoveredStat > equippedStat) {
            this.blit(x, y, 224, 240, 16, 16);
            x += 18;
        } else if (hoveredStat < equippedStat) {
            this.blit(x, y, 240, 240, 16, 16);
            x += 18;
        } else {
            this.blit(x, y, 208, 240, 16, 16);
            x += 18;
        }
        return x;
    }

    private static String formatStat(float value) {
        if (MathUtils.doublesEqual(value, (int)value)) {
            return String.format(FORMAT_INT, (int)value);
        }
        return String.format(FORMAT_FLOAT, Float.valueOf(value));
    }

    private void renderBackground(RenderTooltipEvent.PostText event) {
        int left = event.getX() - 1 + (Integer)Config.CLIENT.offsetX.get();
        int top = event.getY() - 17 + (Integer)Config.CLIENT.offsetY.get();
        int right = Math.max(event.getX() + this.lastWidth, event.getX() + event.getWidth() + 1) + (Integer)Config.CLIENT.offsetX.get();
        int bottom = event.getY() - 4 + (Integer)Config.CLIENT.offsetY.get();
        if (((Boolean)Config.CLIENT.positionOnBottom.get()).booleanValue()) {
            top += event.getHeight() + 21;
            bottom += event.getHeight() + 21;
        }
        TooltipHandler.fill((int)left, (int)top, (int)right, (int)bottom, (int)((Integer)Config.CLIENT.backgroundColor.get()));
    }
}

