/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.gui.element;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.stal111.forbidden_arcanus.gui.GuiManager;
import com.stal111.forbidden_arcanus.gui.forbiddenmicon.ForbiddenmiconScreen;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public abstract class GuiElement {
    private int posX;
    private int posY;
    private final int sizeX;
    private final int sizeY;
    private GuiManager manager;
    private final Minecraft minecraft = Minecraft.func_71410_x();

    public GuiElement(int posX, int posY, int sizeX, int sizeY) {
        this.posX = posX;
        this.posY = posY;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
    }

    public void init() {
    }

    public abstract String getName();

    public List<GuiElement> getChildElements() {
        return this.manager.getElements(this.getName());
    }

    public void addChildElement(GuiElement element) {
        this.manager.addGuiObject(this.getName(), element);
    }

    public abstract void render(int var1, int var2);

    public void renderHoverEffect(int x, int y) {
    }

    public boolean isMouseOver(int x, int y) {
        return x >= this.getPosX() && y >= this.getPosY() && x < this.getEndX() && y < this.getEndY();
    }

    public boolean onClicked(double x, double y) {
        return false;
    }

    public void setGuiManager(GuiManager manager) {
        this.manager = manager;
    }

    public void setPos(int posX, int posY) {
        this.setPosX(posX);
        this.setPosY(posY);
    }

    public void setPosX(int posX) {
        this.posX = posX;
    }

    public int getPosX() {
        return this.posX;
    }

    public void setPosY(int posY) {
        this.posY = posY;
    }

    public int getPosY() {
        return this.posY;
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public int getSizeY() {
        return this.sizeY;
    }

    public int getEndX() {
        return this.posX + this.sizeX;
    }

    public int getEndY() {
        return this.posY + this.sizeY;
    }

    public Minecraft getMinecraft() {
        return this.minecraft;
    }

    public Screen getCurrentScreen() {
        return this.getMinecraft().field_71462_r;
    }

    public void bindTexture(ResourceLocation resourceLocation) {
        this.getMinecraft().func_110434_K().func_110577_a(resourceLocation);
    }

    public void blit(int blitOffset, int startX, int startY, int sizeX, int sizeY, int textureSizeX, int textureSizeY) {
        this.blit(this.getPosX(), this.getPosY(), blitOffset, startX, startY, sizeX, sizeY, textureSizeX, textureSizeY);
    }

    public void blit(int posX, int posY, int blitOffset, int startX, int startY, int sizeX, int sizeY, int textureSizeX, int textureSizeY) {
        AbstractGui.blit((int)posX, (int)posY, (int)blitOffset, (float)startX, (float)startY, (int)sizeX, (int)sizeY, (int)textureSizeX, (int)textureSizeY);
    }

    public void fill(int p_fill_1_, int p_fill_2_, int p_fill_3_, int p_fill_4_, int red, int green, int blue, int alpha) {
        int lvt_6_2_;
        if (p_fill_1_ < p_fill_3_) {
            lvt_6_2_ = p_fill_1_;
            p_fill_1_ = p_fill_3_;
            p_fill_3_ = lvt_6_2_;
        }
        if (p_fill_2_ < p_fill_4_) {
            lvt_6_2_ = p_fill_2_;
            p_fill_2_ = p_fill_4_;
            p_fill_4_ = lvt_6_2_;
        }
        BufferBuilder lvt_10_1_ = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        lvt_10_1_.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        lvt_10_1_.func_227888_a_(TransformationMatrix.func_227983_a_().func_227988_c_(), (float)p_fill_1_, (float)p_fill_4_, 300.0f).func_225586_a_(red, green, blue, alpha).func_181675_d();
        lvt_10_1_.func_227888_a_(TransformationMatrix.func_227983_a_().func_227988_c_(), (float)p_fill_3_, (float)p_fill_4_, 300.0f).func_225586_a_(red, green, blue, alpha).func_181675_d();
        lvt_10_1_.func_227888_a_(TransformationMatrix.func_227983_a_().func_227988_c_(), (float)p_fill_3_, (float)p_fill_2_, 300.0f).func_225586_a_(red, green, blue, alpha).func_181675_d();
        lvt_10_1_.func_227888_a_(TransformationMatrix.func_227983_a_().func_227988_c_(), (float)p_fill_1_, (float)p_fill_2_, 300.0f).func_225586_a_(red, green, blue, alpha).func_181675_d();
        lvt_10_1_.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)lvt_10_1_);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public void renderFancyTooltip(List<String> tooltip, int x, int y) {
        int i = 0;
        for (String s : tooltip) {
            int j = this.getMinecraft().field_71466_p.func_78256_a(s);
            if (j <= i) continue;
            i = j;
        }
        int l1 = x + 12;
        int i2 = y - 12;
        int k = 8;
        if (tooltip.size() > 1) {
            k += 2 + (tooltip.size() - 1) * 10;
        }
        if (l1 + i > ForbiddenmiconScreen.INSTANCE.width) {
            l1 -= 28 + i;
        }
        if (i2 + k + 6 > ForbiddenmiconScreen.INSTANCE.height) {
            i2 = ForbiddenmiconScreen.INSTANCE.height - k - 6;
        }
        this.getMinecraft().func_175599_af().field_77023_b = 300.0f;
        this.bindTexture(ForbiddenmiconScreen.FORBIDDENMICON_GUI_TEXTURES);
        this.blit(l1 - 4, i2 - 4, 300, 153, 236, 10, 7, 256, 512);
        this.blit(l1 - 4, i2 + k - 2, 300, 153, 243, 10, 8, 256, 512);
        this.blit(l1 + i - 6, i2 - 4, 300, 207, 236, 10, 7, 256, 512);
        this.blit(l1 + i - 6, i2 + k - 2, 300, 207, 243, 10, 8, 256, 512);
        this.fill(l1 + 6, i2 - 4, l1 + i - 6, i2 - 3, 104, 103, 101, 255);
        this.fill(l1 + 6, i2 + k + 4, l1 + i - 6, i2 + k + 5, 67, 64, 59, 255);
        this.fill(l1 + 6, i2 - 3, l1 + i - 6, i2 - 2, 210, 203, 185, 255);
        this.fill(l1 + 6, i2 + k + 3, l1 + i - 6, i2 + k + 4, 210, 203, 185, 255);
        this.fill(l1 - 3, i2 + 3, l1 - 4, i2 + k - 1, 104, 103, 101, 255);
        this.fill(l1 + i + 3, i2 + 3, l1 + i + 4, i2 + k - 2, 104, 103, 101, 255);
        this.fill(l1 - 2, i2 + 3, l1 - 3, i2 + k - 1, 210, 203, 185, 255);
        this.fill(l1 + i + 2, i2 + 3, l1 + i + 3, i2 + k - 2, 210, 203, 185, 255);
        this.fill(l1 - 2, i2 - 2, l1 + i + 2, i2 + k + 3, 33, 33, 33, 255);
        MatrixStack matrixstack = new MatrixStack();
        IRenderTypeBuffer.Impl irendertypebuffer$impl = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        matrixstack.func_227861_a_(0.0, 0.0, (double)this.getMinecraft().func_175599_af().field_77023_b);
        Matrix4f matrix4f = matrixstack.func_227866_c_().func_227870_a_();
        for (int k1 = 0; k1 < tooltip.size(); ++k1) {
            String s1 = tooltip.get(k1);
            if (s1 != null) {
                this.getMinecraft().field_71466_p.func_228079_a_(s1, (float)l1, (float)i2, -1, true, matrix4f, (IRenderTypeBuffer)irendertypebuffer$impl, false, 0, 0xF000F0);
            }
            if (k1 == 0) {
                i2 += 2;
            }
            i2 += 10;
        }
        irendertypebuffer$impl.func_228461_a_();
        this.getMinecraft().func_175599_af().field_77023_b = 0.0f;
        RenderSystem.enableDepthTest();
        RenderSystem.enableRescaleNormal();
    }
}

