/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.gui.forbiddenmicon.element.button;

import com.stal111.forbidden_arcanus.gui.element.button.ButtonElement;
import com.stal111.forbidden_arcanus.gui.forbiddenmicon.ForbiddenmiconCategory;
import com.stal111.forbidden_arcanus.gui.forbiddenmicon.ForbiddenmiconScreen;
import java.util.Collections;
import net.minecraft.util.text.TranslationTextComponent;

public class ChangeCategoryButton
extends ButtonElement {
    private final ForbiddenmiconCategory category;
    private final boolean leftSide;

    public ChangeCategoryButton(int posX, int posY, int blitOffset, ForbiddenmiconCategory category, boolean leftSide, ButtonElement.IPressable onPress) {
        super(posX, posY, blitOffset, 130, 220, 18, 14, ForbiddenmiconScreen.FORBIDDENMICON_GUI_TEXTURES, onPress);
        this.category = category;
        this.leftSide = leftSide;
    }

    @Override
    public String getName() {
        return "change_category_button";
    }

    @Override
    public void render(int x, int y) {
        int startX = 130;
        int startY = 220;
        int sizeX = 18;
        int sizeY = 14;
        if (!this.leftSide) {
            startX -= 22;
        }
        if (this.isActivated()) {
            startY -= 32;
            sizeX = 24;
        }
        this.bindTexture(ForbiddenmiconScreen.FORBIDDENMICON_GUI_TEXTURES);
        this.blit(this.getBlitOffset(), startX, startY, sizeX, sizeY, 256, 512);
        this.blit(this.getPosX() + 7, this.getPosY() + 2, this.getBlitOffset() + 1, this.getCategory().getStartX(), this.getCategory().getStartY(), 8, 8, 256, 512);
    }

    @Override
    public void renderHoverEffect(int x, int y) {
        if (x >= this.getPosX() && y >= this.getPosY() && x < this.getPosX() + (this.isActivated() ? 24 : 18) && y < this.getPosY() + this.getSizeY()) {
            if (!this.isActivated()) {
                this.bindTexture(ForbiddenmiconScreen.FORBIDDENMICON_GUI_TEXTURES);
                this.blit(this.getBlitOffset(), this.getStartX(), this.getStartY() - 16, 24, 14, 256, 512);
                this.blit(this.getPosX() + 7, this.getPosY() + 2, this.getBlitOffset() + 1, this.getCategory().getStartX(), this.getCategory().getStartY(), 8, 8, 256, 512);
            }
            this.renderFancyTooltip(Collections.singletonList(new TranslationTextComponent("forbiddenmicon.category." + this.getCategory().toString().toLowerCase(), new Object[0]).func_150254_d()), x, y);
        }
    }

    public ForbiddenmiconCategory getCategory() {
        return this.category;
    }
}

