/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.init;

import com.stal111.forbidden_arcanus.particle.ModBreakingParticle;
import com.stal111.forbidden_arcanus.particle.SoulParticle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.ParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModParticles {
    public static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = new DeferredRegister(ForgeRegistries.PARTICLE_TYPES, "forbidden_arcanus");
    public static final RegistryObject<BasicParticleType> SOUL = ModParticles.register("soul", new BasicParticleType(false));
    public static final RegistryObject<BasicParticleType> ITEM_SEED_BULLET = ModParticles.register("item_seed_bullet", new BasicParticleType(false));

    private static <T extends BasicParticleType> RegistryObject<T> register(String name, T particleType) {
        return PARTICLE_TYPES.register(name, () -> particleType);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void registerParticleTypes(ParticleFactoryRegisterEvent event) {
        if (ModParticles.checkForNonNullWithReflection(SOUL)) {
            Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)SOUL.get(), SoulParticle.Factory::new);
        }
        if (ModParticles.checkForNonNullWithReflection(ITEM_SEED_BULLET)) {
            Minecraft.func_71410_x().field_71452_i.func_199283_a((ParticleType)ITEM_SEED_BULLET.get(), (IParticleFactory)new ModBreakingParticle.Factory());
        }
    }

    private static boolean checkForNonNullWithReflection(RegistryObject<BasicParticleType> registryObject) {
        return ObfuscationReflectionHelper.getPrivateValue(RegistryObject.class, registryObject, (String)"value") != null;
    }
}

