/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.ai.improvements.modifier;

import com.builtbroken.ai.improvements.ConfigMain;
import com.builtbroken.ai.improvements.FixedLookController;
import com.builtbroken.ai.improvements.modifier.ModifierLevel;
import com.builtbroken.ai.improvements.modifier.editor.GenericRemove;
import com.builtbroken.ai.improvements.modifier.filters.FilterLayer;
import com.builtbroken.ai.improvements.modifier.filters.FilterResult;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.FollowSchoolLeaderGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.passive.fish.PufferfishEntity;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="aiimprovements")
public class ModifierSystem {
    public static final FilterLayer editor = new FilterLayer(null);
    public static final ModifierLevel mobEntityEditor = ModifierLevel.newFilter(entity -> entity instanceof MobEntity);
    public static final ModifierLevel fishEditor = ModifierLevel.newFilter(entity -> entity instanceof AbstractFishEntity);
    public static final ModifierLevel squidEditor = ModifierLevel.newFilter(entity -> entity instanceof SquidEntity);

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        editor.handle(event.getEntity());
    }

    public static void init() {
        editor.add(mobEntityEditor);
        ModifierSystem.mobEntityEditor.goalEditor.add(new GenericRemove(goal -> goal instanceof LookAtGoal, ConfigMain.CONFIG.removeLookGoal));
        ModifierSystem.mobEntityEditor.goalEditor.add(new GenericRemove(goal -> goal instanceof LookRandomlyGoal, ConfigMain.CONFIG.removeLookRandom));
        ModifierSystem.mobEntityEditor.filters.add(entity -> ModifierSystem.replaceLookHelper((MobEntity)entity));
        ModifierSystem.mobEntityEditor.filters.add(fishEditor);
        ModifierSystem.fishEditor.goalEditor.add(new GenericRemove(goal -> goal instanceof RandomSwimmingGoal, ConfigMain.CONFIG.removeFishSwim));
        ModifierSystem.fishEditor.goalEditor.add(new GenericRemove(goal -> goal instanceof AvoidEntityGoal, ConfigMain.CONFIG.removeFishAvoidPlayer));
        ModifierSystem.fishEditor.goalEditor.add(new GenericRemove(goal -> goal instanceof PanicGoal, ConfigMain.CONFIG.removeFishPanic));
        ModifierSystem.fishEditor.goalEditor.add(new GenericRemove(goal -> goal instanceof FollowSchoolLeaderGoal, ConfigMain.CONFIG.removeFishFollowLeader));
        ModifierSystem.fishEditor.goalEditor.add(new GenericRemove(goal -> goal instanceof PufferfishEntity.PuffGoal, ConfigMain.CONFIG.removeFishFollowLeader));
        ModifierSystem.mobEntityEditor.filters.add(squidEditor);
        ModifierSystem.squidEditor.goalEditor.add(new GenericRemove(goal -> goal instanceof SquidEntity.MoveRandomGoal, ConfigMain.CONFIG.removeRandomMove));
        ModifierSystem.squidEditor.goalEditor.add(new GenericRemove(goal -> goal instanceof SquidEntity.FleeGoal, ConfigMain.CONFIG.removeRandomMove));
    }

    private static FilterResult replaceLookHelper(MobEntity living) {
        if (((Boolean)ConfigMain.CONFIG.replaceLookController.get()).booleanValue() && (living.func_70671_ap() == null || living.func_70671_ap().getClass() == LookController.class)) {
            LookController oldHelper = living.func_70671_ap();
            living.field_70749_g = new FixedLookController(living);
            if (living.func_70671_ap() instanceof FixedLookController) {
                ((FixedLookController)living.func_70671_ap()).copyDataIntoSelf(oldHelper);
                return FilterResult.MODIFIED;
            }
        }
        return FilterResult.DID_NOTHING;
    }
}

