/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.elements;

import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.config.Constants;
import mezz.jei.gui.textures.JeiSpriteUploader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public class DrawableSprite
implements IDrawableStatic {
    private final JeiSpriteUploader spriteUploader;
    private final ResourceLocation location;
    private final int width;
    private final int height;
    private int trimLeft;
    private int trimRight;
    private int trimTop;
    private int trimBottom;

    public DrawableSprite(JeiSpriteUploader spriteUploader, ResourceLocation location, int width, int height) {
        this.spriteUploader = spriteUploader;
        this.location = location;
        this.width = width;
        this.height = height;
    }

    public DrawableSprite trim(int left, int right, int top, int bottom) {
        this.trimLeft = left;
        this.trimRight = right;
        this.trimTop = top;
        this.trimBottom = bottom;
        return this;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void draw(int xOffset, int yOffset) {
        this.draw(xOffset, yOffset, 0, 0, 0, 0);
    }

    @Override
    public void draw(int xOffset, int yOffset, int maskTop, int maskBottom, int maskLeft, int maskRight) {
        TextureAtlasSprite sprite = this.spriteUploader.func_215282_a(this.location);
        int textureWidth = this.width;
        int textureHeight = this.height;
        Minecraft minecraft = Minecraft.func_71410_x();
        TextureManager textureManager = minecraft.func_110434_K();
        textureManager.func_110577_a(Constants.LOCATION_JEI_GUI_TEXTURE_ATLAS);
        int x = xOffset + (maskLeft += this.trimLeft);
        int y = yOffset + (maskTop += this.trimTop);
        int width = textureWidth - (maskRight += this.trimRight) - maskLeft;
        int height = textureHeight - (maskBottom += this.trimBottom) - maskTop;
        float uSize = sprite.func_94212_f() - sprite.func_94209_e();
        float vSize = sprite.func_94210_h() - sprite.func_94206_g();
        float minU = sprite.func_94209_e() + uSize * ((float)maskLeft / (float)textureWidth);
        float minV = sprite.func_94206_g() + vSize * ((float)maskTop / (float)textureHeight);
        float maxU = sprite.func_94212_f() - uSize * ((float)maskRight / (float)textureWidth);
        float maxV = sprite.func_94210_h() - vSize * ((float)maskBottom / (float)textureHeight);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilder.func_225582_a_((double)x, (double)(y + height), 0.0).func_225583_a_(minU, maxV).func_181675_d();
        bufferBuilder.func_225582_a_((double)(x + width), (double)(y + height), 0.0).func_225583_a_(maxU, maxV).func_181675_d();
        bufferBuilder.func_225582_a_((double)(x + width), (double)y, 0.0).func_225583_a_(maxU, minV).func_181675_d();
        bufferBuilder.func_225582_a_((double)x, (double)y, 0.0).func_225583_a_(minU, minV).func_181675_d();
        tessellator.func_78381_a();
    }
}

