/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.crafter.network;

import java.util.function.Supplier;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsutility.modules.crafter.CraftingRecipe;
import mcjty.rftoolsutility.modules.crafter.blocks.CrafterBaseTE;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketCrafter {
    private BlockPos pos;
    private int recipeIndex;
    private ItemStack[] items;
    private boolean keepOne;
    private CraftingRecipe.CraftMode craftInternal;

    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.writeBoolean(this.keepOne);
        buf.writeByte(this.craftInternal.ordinal());
        buf.writeByte(this.recipeIndex);
        for (ItemStack item : this.items) {
            buf.func_150788_a(item);
        }
    }

    public PacketCrafter() {
    }

    public PacketCrafter(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.keepOne = buf.readBoolean();
        this.craftInternal = CraftingRecipe.CraftMode.values()[buf.readByte()];
        this.recipeIndex = buf.readByte();
        this.items = new ItemStack[10];
        for (int i = 0; i < 10; ++i) {
            this.items[i] = buf.func_150791_c();
        }
    }

    public PacketCrafter(BlockPos pos, int recipeIndex, CraftingInventory inv, ItemStack result, boolean keepOne, CraftingRecipe.CraftMode craftInternal) {
        this.pos = pos;
        this.recipeIndex = recipeIndex;
        this.items = new ItemStack[10];
        for (int i = 0; i < 9; ++i) {
            this.items[i] = inv.func_70301_a(i).func_77946_l();
        }
        this.items[9] = result.func_77946_l();
        this.keepOne = keepOne;
        this.craftInternal = craftInternal;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            World world = ctx.getSender().func_130014_f_();
            if (world.func_175667_e(this.pos)) {
                TileEntity te = world.func_175625_s(this.pos);
                if (!(te instanceof CrafterBaseTE)) {
                    Logging.logError((String)"Wrong type of tile entity (expected CrafterBaseTE)!");
                    return;
                }
                CrafterBaseTE crafterBlockTileEntity = (CrafterBaseTE)te;
                crafterBlockTileEntity.noRecipesWork = false;
                if (this.recipeIndex != -1) {
                    this.updateRecipe(crafterBlockTileEntity);
                }
            }
        });
        ctx.setPacketHandled(true);
    }

    private void updateRecipe(CrafterBaseTE crafterBlockTileEntity) {
        CraftingRecipe recipe = crafterBlockTileEntity.getRecipe(this.recipeIndex);
        recipe.setRecipe(this.items, this.items[9]);
        recipe.setKeepOne(this.keepOne);
        recipe.setCraftMode(this.craftInternal);
        crafterBlockTileEntity.selectRecipe(this.recipeIndex);
        crafterBlockTileEntity.markDirtyClient();
    }
}

