/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.LogicTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsutility.compat.RFToolsUtilityTOPDriver;
import mcjty.rftoolsutility.modules.logic.LogicBlockModule;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class CounterTileEntity
extends LogicTileEntity {
    public static final String CMD_SETCOUNTER = "counter.setCounter";
    public static final String CMD_SETCURRENT = "counter.setCurrent";
    private boolean prevIn = false;
    private int counter = 1;
    private int current = 0;
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Analog").containerSupplier((windowId, player) -> new GenericContainer((ContainerType)LogicBlockModule.CONTAINER_COUNTER.get(), windowId.intValue(), (ContainerFactory)ContainerFactory.EMPTY.get(), this.func_174877_v(), (GenericTileEntity)this)));

    public CounterTileEntity() {
        super((TileEntityType)LogicBlockModule.TYPE_ANALOG.get());
    }

    public static LogicSlabBlock createBlock() {
        return new LogicSlabBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsUtilityTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolsutility:logic/counter")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(CounterTileEntity::new));
    }

    public int getCounter() {
        return this.counter;
    }

    public int getCurrent() {
        return this.current;
    }

    public void setCounter(int counter) {
        this.counter = counter;
        this.current = 0;
        this.markDirtyClient();
    }

    public void setCurrent(int current) {
        this.current = current;
        this.markDirtyClient();
    }

    protected void update() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean pulse = this.powerLevel > 0 && !this.prevIn;
        this.prevIn = this.powerLevel > 0;
        int newout = 0;
        if (pulse) {
            ++this.current;
            if (this.current >= this.counter) {
                this.current = 0;
                newout = 15;
            }
            this.func_70296_d();
            this.setRedstoneState(newout);
        }
    }

    public void func_145839_a(CompoundNBT tagCompound) {
        super.func_145839_a(tagCompound);
        this.powerOutput = tagCompound.func_74767_n("rs") ? 15 : 0;
        this.prevIn = tagCompound.func_74767_n("prevIn");
    }

    public void readInfo(CompoundNBT tagCompound) {
        super.readInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        this.counter = info.func_74762_e("counter");
        if (this.counter == 0) {
            this.counter = 1;
        }
        this.current = info.func_74762_e("current");
    }

    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74757_a("rs", this.powerOutput > 0);
        tagCompound.func_74757_a("prevIn", this.prevIn);
        return tagCompound;
    }

    public void writeInfo(CompoundNBT tagCompound) {
        super.writeInfo(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        info.func_74768_a("counter", this.counter);
        info.func_74768_a("current", this.current);
    }

    public void checkRedstone(World world, BlockPos pos) {
        super.checkRedstone(world, pos);
        this.update();
    }

    public boolean execute(PlayerEntity playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_SETCOUNTER.equals(command)) {
            int counter;
            try {
                counter = Integer.parseInt((String)params.get(TextField.PARAM_TEXT));
            }
            catch (NumberFormatException e) {
                counter = 1;
            }
            this.setCounter(counter);
            return true;
        }
        if (CMD_SETCURRENT.equals(command)) {
            int current;
            try {
                current = Integer.parseInt((String)params.get(TextField.PARAM_TEXT));
            }
            catch (NumberFormatException e) {
                current = 1;
            }
            this.setCurrent(current);
            return true;
        }
        return false;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        if (cap == CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY) {
            return this.screenHandler.cast();
        }
        return super.getCapability(cap, facing);
    }
}

