/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.AutomationFilterItemHander;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.container.NoDirectionItemHander;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.TagSelector;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.LogicTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.CapabilityTools;
import mcjty.lib.varia.InventoryTools;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsutility.compat.RFToolsUtilityTOPDriver;
import mcjty.rftoolsutility.modules.logic.LogicBlockModule;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class InvCheckerTileEntity
extends LogicTileEntity
implements ITickableTileEntity {
    public static final String CMD_SETAMOUNT = "inv.setCounter";
    public static final String CMD_SETSLOT = "inv.setSlot";
    public static final String CMD_SETDAMAGE = "inv.setUseDamage";
    public static final String CMD_SETTAG = "inv.setTag";
    public static final String CONTAINER_INVENTORY = "container";
    public static final int SLOT_ITEMMATCH = 0;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(1).slot(SlotDefinition.ghost(), CONTAINER_INVENTORY, 0, 154, 24).playerSlots(10, 70));
    private final NoDirectionItemHander items = this.createItemHandler();
    private final LazyOptional<AutomationFilterItemHander> itemHandler = LazyOptional.of(() -> new AutomationFilterItemHander(this.items));
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Inventory Checker").containerSupplier((windowId, player) -> new GenericContainer((ContainerType)LogicBlockModule.CONTAINER_INVCHECKER.get(), windowId.intValue(), (ContainerFactory)CONTAINER_FACTORY.get(), this.func_174877_v(), (GenericTileEntity)this)).itemHandler(() -> this.items));
    private int amount = 1;
    private int slot = 0;
    private boolean useDamage = false;
    private Tag<Item> tag = null;
    private int checkCounter = 0;

    public InvCheckerTileEntity() {
        super((TileEntityType)LogicBlockModule.TYPE_INVCHECKER.get());
    }

    public static LogicSlabBlock createBlock() {
        return new LogicSlabBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsUtilityTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolsutility:logic/invchecker")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(InvCheckerTileEntity::new));
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
        this.markDirtyClient();
    }

    public int getSlot() {
        return this.slot;
    }

    public void setSlot(int slot) {
        this.slot = slot;
        this.markDirtyClient();
    }

    public Tag<Item> getTag() {
        return this.tag;
    }

    public void setTag(Tag<Item> tag) {
        this.tag = tag;
        this.markDirtyClient();
    }

    public void setTagByName(String tagName) {
        this.tag = tagName == null ? null : ItemTags.func_199903_a().func_199910_a(new ResourceLocation(tagName));
        this.markDirtyClient();
    }

    public String getTagName() {
        return this.tag == null ? null : this.tag.func_199886_b().toString();
    }

    public boolean isUseDamage() {
        return this.useDamage;
    }

    public void setUseDamage(boolean useDamage) {
        this.useDamage = useDamage;
        this.markDirtyClient();
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        --this.checkCounter;
        if (this.checkCounter > 0) {
            return;
        }
        this.checkCounter = 10;
        this.setRedstoneState(this.checkOutput() ? 15 : 0);
    }

    public boolean checkOutput() {
        Direction inputSide = this.getFacing(this.field_145850_b.func_180495_p(this.func_174877_v())).getInputSide();
        BlockPos inputPos = this.func_174877_v().func_177972_a(inputSide);
        TileEntity te = this.field_145850_b.func_175625_s(inputPos);
        if (InventoryTools.isInventory((TileEntity)te)) {
            return (Boolean)CapabilityTools.getItemCapabilitySafe((TileEntity)te).map(capability -> {
                int nr;
                ItemStack stack;
                if (this.slot >= 0 && this.slot < capability.getSlots() && !(stack = capability.getStackInSlot(this.slot)).func_190926_b() && (nr = this.isItemMatching(stack)) >= this.amount) {
                    if (this.tag != null) {
                        return this.tag.func_199685_a_((Object)stack.func_77973_b());
                    }
                    return true;
                }
                return false;
            }).orElse((Object)false);
        }
        return false;
    }

    private int isItemMatching(ItemStack stack) {
        int nr = 0;
        ItemStack matcher = this.items.getStackInSlot(0);
        if (!matcher.func_190926_b()) {
            if (this.useDamage) {
                if (matcher.func_77969_a(stack)) {
                    nr = stack.func_190916_E();
                }
            } else if (matcher.func_77973_b() == stack.func_77973_b()) {
                nr = stack.func_190916_E();
            }
        } else {
            nr = stack.func_190916_E();
        }
        return nr;
    }

    public void func_145839_a(CompoundNBT tagCompound) {
        super.func_145839_a(tagCompound);
        this.powerOutput = tagCompound.func_74767_n("rs") ? 15 : 0;
    }

    public void readInfo(CompoundNBT tagCompound) {
        super.readInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        this.amount = info.func_74762_e("amount");
        this.slot = info.func_74762_e("slot");
        String tagString = info.func_74779_i("tag");
        if (!tagString.isEmpty()) {
            this.tag = ItemTags.func_199903_a().func_199910_a(new ResourceLocation(tagString));
        }
        this.useDamage = info.func_74767_n("useDamage");
    }

    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74757_a("rs", this.powerOutput > 0);
        return tagCompound;
    }

    public void writeInfo(CompoundNBT tagCompound) {
        super.writeInfo(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        info.func_74768_a("amount", this.amount);
        info.func_74768_a("slot", this.slot);
        if (this.tag != null) {
            info.func_74778_a("tag", this.tag.func_199886_b().toString());
        }
        info.func_74757_a("useDamage", this.useDamage);
    }

    public boolean execute(PlayerEntity playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_SETDAMAGE.equals(command)) {
            this.setUseDamage("Match".equals(params.get(ChoiceLabel.PARAM_CHOICE)));
            return true;
        }
        if (CMD_SETTAG.equals(command)) {
            String tag = (String)params.get(TagSelector.PARAM_TAG);
            this.setTagByName(tag);
            return true;
        }
        if (CMD_SETSLOT.equals(command)) {
            int slot;
            try {
                slot = Integer.parseInt((String)params.get(TextField.PARAM_TEXT));
            }
            catch (NumberFormatException e) {
                slot = 0;
            }
            this.setSlot(slot);
            return true;
        }
        if (CMD_SETAMOUNT.equals(command)) {
            int amount;
            try {
                amount = Integer.parseInt((String)params.get(TextField.PARAM_TEXT));
            }
            catch (NumberFormatException e) {
                amount = 1;
            }
            this.setAmount(amount);
            return true;
        }
        return false;
    }

    private NoDirectionItemHander createItemHandler() {
        return new NoDirectionItemHander((GenericTileEntity)this, (ContainerFactory)CONTAINER_FACTORY.get()){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return false;
            }

            public boolean isItemInsertable(int slot, @Nonnull ItemStack stack) {
                return this.isItemValid(slot, stack);
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        if (cap == CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY) {
            return this.screenHandler.cast();
        }
        return super.getCapability(cap, facing);
    }
}

