/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.DefaultValue;
import mcjty.lib.bindings.IValue;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.rftoolsutility.modules.logic.LogicBlockModule;
import mcjty.rftoolsutility.modules.logic.blocks.RedstoneChannelTileEntity;
import mcjty.rftoolsutility.modules.logic.network.PacketSetChannelName;
import mcjty.rftoolsutility.modules.logic.tools.RedstoneChannels;
import mcjty.rftoolsutility.setup.RFToolsUtilityMessages;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class RedstoneTransmitterTileEntity
extends RedstoneChannelTileEntity {
    private int prevIn = -1;
    private String channelName;
    public static final Key<String> VALUE_NAME = new Key("name", Type.STRING);
    private LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Redstone Receiver").containerSupplier((windowId, player) -> new GenericContainer((ContainerType)LogicBlockModule.CONTAINER_REDSTONE_TRANSMITTER.get(), windowId.intValue(), (ContainerFactory)ContainerFactory.EMPTY.get(), this.func_174877_v(), (GenericTileEntity)this)));

    public IValue<?>[] getValues() {
        return new IValue[]{new DefaultValue(VALUE_NAME, this::getChannelName, this::setChannelName)};
    }

    public void setChannelName(String v) {
        if (this.field_145850_b.field_72995_K) {
            this.channelName = v;
            RFToolsUtilityMessages.INSTANCE.sendToServer((Object)new PacketSetChannelName(this.field_174879_c, this.channelName));
        } else {
            if (this.channel == -1) {
                this.getChannel(true);
            }
            RedstoneChannels channels = RedstoneChannels.getChannels(this.field_145850_b);
            RedstoneChannels.RedstoneChannel ch = channels.getOrCreateChannel(this.channel);
            ch.setName(v);
            channels.func_76185_a();
            this.markDirtyClient();
        }
    }

    private String getChannelName() {
        if (this.field_145850_b.field_72995_K) {
            return this.channelName;
        }
        if (this.channel == -1) {
            return "";
        }
        RedstoneChannels channels = RedstoneChannels.getChannels(this.field_145850_b);
        RedstoneChannels.RedstoneChannel ch = channels.getOrCreateChannel(this.channel);
        return ch.getName();
    }

    public RedstoneTransmitterTileEntity() {
        super((TileEntityType)LogicBlockModule.TYPE_REDSTONE_TRANSMITTER.get());
    }

    public void writeClientDataToNBT(CompoundNBT tagCompound) {
        super.writeClientDataToNBT(tagCompound);
        tagCompound.func_74778_a("channelName", this.getChannelName());
    }

    public void readClientDataFromNBT(CompoundNBT tagCompound) {
        super.readClientDataFromNBT(tagCompound);
        this.channelName = tagCompound.func_74779_i("channelName");
    }

    @Override
    public void setChannel(int channel) {
        super.setChannel(channel);
        this.update();
    }

    public void update() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.channel == -1) {
            return;
        }
        if (this.powerLevel != this.prevIn) {
            this.prevIn = this.powerLevel;
            this.func_70296_d();
            RedstoneChannels channels = RedstoneChannels.getChannels(this.field_145850_b);
            RedstoneChannels.RedstoneChannel ch = channels.getOrCreateChannel(this.channel);
            ch.setValue(this.powerLevel);
            channels.save();
        }
    }

    public void func_145839_a(CompoundNBT tagCompound) {
        super.func_145839_a(tagCompound);
        this.prevIn = tagCompound.func_150297_b("prevIn", 3) ? tagCompound.func_74762_e("prevIn") : (tagCompound.func_74767_n("prevIn") ? 15 : 0);
    }

    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("prevIn", this.prevIn);
        return tagCompound;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        if (cap == CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY) {
            return this.screenHandler.cast();
        }
        return super.getCapability(cap, facing);
    }
}

