/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.LogicTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.DimensionId;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsbase.tools.TickOrderHandler;
import mcjty.rftoolsutility.compat.RFToolsUtilityTOPDriver;
import mcjty.rftoolsutility.modules.logic.LogicBlockModule;
import mcjty.rftoolsutility.modules.logic.tools.SequencerMode;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class SequencerTileEntity
extends LogicTileEntity
implements ITickableTileEntity,
TickOrderHandler.IOrderTicker {
    public static final String CMD_MODE = "sequencer.mode";
    public static final String CMD_FLIPBITS = "sequencer.flipBits";
    public static final String CMD_CLEARBITS = "sequencer.clearBits";
    public static final String CMD_SETDELAY = "sequencer.setDelay";
    public static final String CMD_SETCOUNT = "sequencer.setCount";
    public static final String CMD_SETENDSTATE = "sequencer.setEndState";
    public static final String CMD_SETBIT = "sequencer.setBit";
    public static final Key<Integer> PARAM_BIT = new Key("bit", Type.INTEGER);
    public static final Key<Boolean> PARAM_CHOICE = new Key("choice", Type.BOOLEAN);
    private SequencerMode mode = SequencerMode.MODE_ONCE1;
    private long cycleBits = 0L;
    private int currentStep = -1;
    private int stepCount = 64;
    private boolean endState = false;
    private boolean prevIn = false;
    private int delay = 1;
    private int timer = 0;
    private LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Sequencer").containerSupplier((windowId, player) -> new GenericContainer((ContainerType)LogicBlockModule.CONTAINER_SEQUENCER.get(), windowId.intValue(), (ContainerFactory)ContainerFactory.EMPTY.get(), this.func_174877_v(), (GenericTileEntity)this)));

    public static LogicSlabBlock createBlock() {
        return new LogicSlabBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsUtilityTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolsutility:logic/sequencer")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(SequencerTileEntity::new));
    }

    public SequencerTileEntity() {
        super((TileEntityType)LogicBlockModule.TYPE_SEQUENCER.get());
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
        this.timer = delay;
        this.markDirtyClient();
    }

    public int getStepCount() {
        return this.stepCount;
    }

    public void setStepCount(int stepCount) {
        int n = this.stepCount = stepCount >= 1 && stepCount <= 64 ? stepCount : 64;
        if (this.currentStep >= stepCount) {
            this.currentStep = stepCount - 1;
        }
        this.markDirtyClient();
    }

    public boolean getEndState() {
        return this.endState;
    }

    public void setEndState(boolean endState) {
        this.endState = endState;
        this.markDirtyClient();
    }

    public SequencerMode getMode() {
        return this.mode;
    }

    public void setMode(SequencerMode mode) {
        this.mode = mode;
        switch (mode) {
            case MODE_ONCE1: 
            case MODE_ONCE2: 
            case MODE_LOOP3: 
            case MODE_LOOP4: {
                this.currentStep = -1;
                break;
            }
            case MODE_LOOP1: 
            case MODE_LOOP2: 
            case MODE_STEP: {
                this.currentStep = 0;
            }
        }
        this.markDirtyClient();
    }

    public int getCurrentStep() {
        return this.currentStep;
    }

    public boolean getCycleBit(int bit) {
        return (this.cycleBits >> bit & 1L) == 1L;
    }

    public long getCycleBits() {
        return this.cycleBits;
    }

    public void setCycleBit(int bit, boolean flag) {
        this.cycleBits = flag ? (this.cycleBits |= 1L << bit) : (this.cycleBits &= 1L << bit ^ 0xFFFFFFFFFFFFFFFFL);
        this.markDirtyClient();
    }

    public void flipCycleBits() {
        this.cycleBits ^= 0xFFFFFFFFFFFFFFFFL;
        this.markDirtyClient();
    }

    public void clearCycleBits() {
        this.cycleBits = 0L;
        this.markDirtyClient();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            TickOrderHandler.queue((TickOrderHandler.IOrderTicker)this);
        }
    }

    public TickOrderHandler.Rank getRank() {
        return TickOrderHandler.Rank.RANK_4;
    }

    public void tickServer() {
        boolean pulse = this.powerLevel > 0 && !this.prevIn;
        boolean bl = this.prevIn = this.powerLevel > 0;
        if (pulse) {
            this.handlePulse();
        }
        this.func_70296_d();
        --this.timer;
        if (this.timer > 0) {
            return;
        }
        this.timer = this.delay;
        this.setRedstoneState(this.checkOutput() ? 15 : 0);
        this.handleCycle(this.powerLevel > 0);
    }

    public DimensionId getDimension() {
        return DimensionId.fromWorld((World)this.field_145850_b);
    }

    public boolean checkOutput() {
        return this.currentStep == -1 ? this.endState : this.getCycleBit(this.currentStep);
    }

    private void handleCycle(boolean redstone) {
        switch (this.mode) {
            case MODE_ONCE1: 
            case MODE_ONCE2: {
                if (this.currentStep == -1) break;
                this.nextStepAndStop();
                break;
            }
            case MODE_LOOP1: {
                this.nextStep();
                break;
            }
            case MODE_LOOP2: {
                this.nextStep();
                break;
            }
            case MODE_LOOP3: {
                if (!redstone) break;
                this.nextStep();
                break;
            }
            case MODE_LOOP4: {
                if (redstone) {
                    this.nextStep();
                    break;
                }
                this.currentStep = -1;
                break;
            }
        }
    }

    private void handlePulse() {
        switch (this.mode) {
            case MODE_ONCE1: {
                if (this.currentStep != -1) break;
                this.currentStep = 0;
                break;
            }
            case MODE_ONCE2: {
                this.currentStep = 0;
                break;
            }
            case MODE_LOOP1: {
                break;
            }
            case MODE_LOOP2: {
                this.currentStep = 0;
                break;
            }
            case MODE_LOOP3: 
            case MODE_LOOP4: {
                break;
            }
            case MODE_STEP: {
                this.nextStep();
            }
        }
    }

    private void nextStep() {
        ++this.currentStep;
        if (this.currentStep >= this.stepCount) {
            this.currentStep = 0;
        }
    }

    private void nextStepAndStop() {
        ++this.currentStep;
        if (this.currentStep >= this.stepCount) {
            this.currentStep = -1;
        }
    }

    public void func_145839_a(CompoundNBT tagCompound) {
        super.func_145839_a(tagCompound);
        this.powerOutput = tagCompound.func_74767_n("rs") ? 15 : 0;
        this.currentStep = tagCompound.func_74762_e("step");
        this.prevIn = tagCompound.func_74767_n("prevIn");
        this.timer = tagCompound.func_74762_e("timer");
    }

    public void readInfo(CompoundNBT tagCompound) {
        super.readInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        this.cycleBits = info.func_74763_f("bits");
        int m = info.func_74762_e("mode");
        this.mode = SequencerMode.values()[m];
        this.delay = info.func_74762_e("delay");
        if (this.delay == 0) {
            this.delay = 1;
        }
        this.stepCount = info.func_74762_e("stepCount");
        if (this.stepCount == 0) {
            this.stepCount = 64;
        }
        this.endState = info.func_74767_n("endState");
    }

    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74757_a("rs", this.powerOutput > 0);
        tagCompound.func_74768_a("step", this.currentStep);
        tagCompound.func_74757_a("prevIn", this.prevIn);
        tagCompound.func_74768_a("timer", this.timer);
        return tagCompound;
    }

    public void writeInfo(CompoundNBT tagCompound) {
        super.writeInfo(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        info.func_74772_a("bits", this.cycleBits);
        info.func_74768_a("mode", this.mode.ordinal());
        info.func_74768_a("delay", this.delay);
        info.func_74768_a("stepCount", this.stepCount);
        info.func_74757_a("endState", this.endState);
    }

    public boolean execute(PlayerEntity playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_SETENDSTATE.equals(command)) {
            boolean newChoice = "1".equals(params.get(ImageChoiceLabel.PARAM_CHOICE));
            this.setEndState(newChoice);
            return true;
        }
        if (CMD_FLIPBITS.equals(command)) {
            this.flipCycleBits();
            return true;
        }
        if (CMD_CLEARBITS.equals(command)) {
            this.clearCycleBits();
            return true;
        }
        if (CMD_SETCOUNT.equals(command)) {
            int count;
            try {
                count = Integer.parseInt((String)params.get(TextField.PARAM_TEXT));
            }
            catch (NumberFormatException e) {
                count = 64;
            }
            this.setStepCount(count);
            return true;
        }
        if (CMD_SETDELAY.equals(command)) {
            int delay;
            try {
                delay = Integer.parseInt((String)params.get(TextField.PARAM_TEXT));
            }
            catch (NumberFormatException e) {
                delay = 1;
            }
            this.setDelay(delay);
            return true;
        }
        if (CMD_MODE.equals(command)) {
            SequencerMode newMode = SequencerMode.getMode((String)params.get(ChoiceLabel.PARAM_CHOICE));
            this.setMode(newMode);
            return true;
        }
        if (CMD_SETBIT.equals(command)) {
            int bit = (Integer)params.get(PARAM_BIT);
            boolean choice = (Boolean)params.get(PARAM_CHOICE);
            this.setCycleBit(bit, choice);
            return true;
        }
        return false;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        if (cap == CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY) {
            return this.screenHandler.cast();
        }
        return super.getCapability(cap, facing);
    }
}

