/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.client;

import java.text.DecimalFormat;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolsutility.modules.logic.LogicBlockModule;
import mcjty.rftoolsutility.modules.logic.blocks.AnalogTileEntity;
import mcjty.rftoolsutility.setup.RFToolsUtilityMessages;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.util.ResourceLocation;

public class GuiAnalog
extends GenericGuiContainer<AnalogTileEntity, GenericContainer> {
    private TextField mulEqual;
    private TextField mulLess;
    private TextField mulGreater;
    private TextField addEqual;
    private TextField addLess;
    private TextField addGreater;
    private static final DecimalFormat fmt = new DecimalFormat("#.#");

    public GuiAnalog(AnalogTileEntity te, GenericContainer container, PlayerInventory inventory) {
        super((GenericTileEntity)te, (Container)container, inventory, ((LogicSlabBlock)LogicBlockModule.ANALOG.get()).getManualEntry());
    }

    public static void register() {
        GuiAnalog.register((ContainerType)((ContainerType)LogicBlockModule.CONTAINER_ANALOG.get()), GuiAnalog::new);
    }

    public void init() {
        this.window = new Window((Screen)this, this.tileEntity, RFToolsUtilityMessages.INSTANCE, new ResourceLocation("rftoolsutility", "gui/analog.gui"));
        super.init();
        this.initializeFields();
        this.setupEvents();
    }

    private void initializeFields() {
        this.mulEqual = (TextField)this.window.findChild("mul_eq");
        this.mulLess = (TextField)this.window.findChild("mul_less");
        this.mulGreater = (TextField)this.window.findChild("mul_greater");
        this.addEqual = (TextField)this.window.findChild("add_eq");
        this.addLess = (TextField)this.window.findChild("add_less");
        this.addGreater = (TextField)this.window.findChild("add_greater");
        this.mulEqual.text(fmt.format(((AnalogTileEntity)this.tileEntity).getMulEqual()));
        this.mulLess.text(fmt.format(((AnalogTileEntity)this.tileEntity).getMulLess()));
        this.mulGreater.text(fmt.format(((AnalogTileEntity)this.tileEntity).getMulGreater()));
        this.addEqual.text(String.valueOf(((AnalogTileEntity)this.tileEntity).getAddEqual()));
        this.addLess.text(String.valueOf(((AnalogTileEntity)this.tileEntity).getAddLess()));
        this.addGreater.text(String.valueOf(((AnalogTileEntity)this.tileEntity).getAddGreater()));
    }

    private void setupEvents() {
        this.window.event("update", (source, params) -> this.updateAnalog());
    }

    private static double safeDouble(String f) {
        try {
            return Double.parseDouble(f);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    private static int safeInt(String f) {
        try {
            return Integer.parseInt(f);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private void updateAnalog() {
        this.sendServerCommandTyped(RFToolsUtilityMessages.INSTANCE, "analog.update", TypedMap.builder().put(AnalogTileEntity.PARAM_MUL_EQ, (Object)GuiAnalog.safeDouble(this.mulEqual.getText())).put(AnalogTileEntity.PARAM_MUL_LESS, (Object)GuiAnalog.safeDouble(this.mulLess.getText())).put(AnalogTileEntity.PARAM_MUL_GT, (Object)GuiAnalog.safeDouble(this.mulGreater.getText())).put(AnalogTileEntity.PARAM_ADD_EQ, (Object)GuiAnalog.safeInt(this.addEqual.getText())).put(AnalogTileEntity.PARAM_ADD_LESS, (Object)GuiAnalog.safeInt(this.addLess.getText())).put(AnalogTileEntity.PARAM_ADD_GT, (Object)GuiAnalog.safeInt(this.addGreater.getText())).build());
    }
}

