/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.items;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.rftoolsbase.modules.tablet.items.TabletItem;
import mcjty.rftoolsutility.modules.logic.LogicBlockModule;
import mcjty.rftoolsutility.modules.logic.items.RedstoneInformationItem;
import mcjty.rftoolsutility.modules.logic.network.PacketSendRedstoneData;
import mcjty.rftoolsutility.modules.logic.tools.RedstoneChannels;
import mcjty.rftoolsutility.setup.RFToolsUtilityMessages;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class RedstoneInformationContainer
extends GenericContainer {
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(0));
    private PlayerEntity player;
    private World world;
    private Map<Integer, Pair<String, Integer>> values = null;

    public void sendData(Map<Integer, Pair<String, Integer>> channelData) {
        this.values = channelData;
    }

    public Map<Integer, Pair<String, Integer>> getChannelData() {
        return this.values;
    }

    public static ItemStack getRedstoneInformationItem(PlayerEntity player) {
        ItemStack tabletItem = player.func_184586_b(TabletItem.getHand((PlayerEntity)player));
        if (tabletItem.func_77973_b() instanceof RedstoneInformationItem) {
            return tabletItem;
        }
        return TabletItem.getContainingItem((ItemStack)tabletItem, (int)TabletItem.getCurrentSlot((ItemStack)tabletItem));
    }

    public RedstoneInformationContainer(int id, BlockPos pos, PlayerEntity player) {
        super((ContainerType)LogicBlockModule.CONTAINER_REDSTONE_INFORMATION.get(), id, (ContainerFactory)CONTAINER_FACTORY.get(), pos, null);
        this.player = player;
        this.world = player.func_130014_f_();
    }

    public void setupInventories(IItemHandler itemHandler, PlayerInventory inventory) {
    }

    public void func_75142_b() {
        RedstoneChannels.RedstoneChannel c;
        super.func_75142_b();
        boolean dirty = false;
        RedstoneChannels redstoneChannels = RedstoneChannels.getChannels(this.world);
        ItemStack infoItem = RedstoneInformationContainer.getRedstoneInformationItem(this.player);
        Set<Integer> channels = RedstoneInformationItem.getChannels(infoItem);
        if (this.values == null || this.values.size() != channels.size()) {
            this.values = new HashMap<Integer, Pair<String, Integer>>();
            for (Integer channel : channels) {
                c = redstoneChannels.getChannel(channel);
                if (c == null) continue;
                this.values.put(channel, (Pair<String, Integer>)Pair.of((Object)c.getName(), (Object)c.getValue()));
            }
            dirty = true;
        } else {
            for (Integer channel : channels) {
                c = redstoneChannels.getChannel(channel);
                if (c == null || ((Integer)this.values.get(channel).getRight()).intValue() == c.getValue()) continue;
                this.values.put(channel, (Pair<String, Integer>)Pair.of((Object)c.getName(), (Object)c.getValue()));
                dirty = true;
            }
        }
        if (dirty) {
            PacketSendRedstoneData message = new PacketSendRedstoneData(this.values);
            for (IContainerListener listener : this.field_75149_d) {
                if (!(listener instanceof ServerPlayerEntity)) continue;
                RFToolsUtilityMessages.INSTANCE.sendTo((Object)message, ((ServerPlayerEntity)listener).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
            }
        }
    }
}

