/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.items;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.lib.varia.NBTTools;
import mcjty.rftoolsbase.api.various.ITabletSupport;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsutility.RFToolsUtility;
import mcjty.rftoolsutility.modules.logic.LogicBlockModule;
import mcjty.rftoolsutility.modules.logic.items.RedstoneInformationContainer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class RedstoneInformationItem
extends Item
implements ITabletSupport,
ITooltipSettings {
    public static final ManualEntry MANUAL = ManualHelper.create((String)"rftoolsutility:logic/redstone_information");
    private final TooltipBuilder tooltipBuilder = new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(), TooltipBuilder.parameter((String)"channels", stack -> {
        Set<Integer> channels = RedstoneInformationItem.getChannels(stack);
        List list = channels.stream().sorted().collect(Collectors.toList());
        String s = "";
        String prefix = "";
        for (Integer channel : list) {
            s = s + prefix + channel;
            prefix = ", ";
        }
        return s;
    })});

    public RedstoneInformationItem() {
        super(new Item.Properties().func_200915_b(1).func_200916_a(RFToolsUtility.setup.getTab()));
    }

    public ManualEntry getManualEntry() {
        return MANUAL;
    }

    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(itemStack, world, list, flag);
        this.tooltipBuilder.makeTooltip(this.getRegistryName(), itemStack, list, flag);
    }

    public Item getInstalledTablet() {
        return (Item)LogicBlockModule.TABLET_REDSTONE.get();
    }

    public void openGui(@Nonnull PlayerEntity player, @Nonnull ItemStack tabletItem, @Nonnull ItemStack containingItem) {
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return new StringTextComponent("Redstone Module");
            }

            public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
                return new RedstoneInformationContainer(id, player.func_180425_c(), player);
            }
        });
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            this.openGui(player, stack, stack);
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public static Set<Integer> getChannels(ItemStack stack) {
        return NBTTools.getTag((ItemStack)stack).map(tag -> IntStream.of(tag.func_74759_k("Channels")).boxed().collect(Collectors.toSet())).orElse(Collections.emptySet());
    }

    public static boolean addChannel(ItemStack stack, int channel) {
        Set<Integer> channels = RedstoneInformationItem.getChannels(stack);
        if (!channels.contains(channel)) {
            channels = new HashSet<Integer>(channels);
            channels.add(channel);
            CompoundNBT tag = stack.func_196082_o();
            tag.func_197646_b("Channels", channels.stream().collect(Collectors.toList()));
            return true;
        }
        return false;
    }

    public static void removeChannel(ItemStack stack, int channel) {
        Set<Integer> channels = RedstoneInformationItem.getChannels(stack);
        channels.remove(channel);
        CompoundNBT tag = stack.func_196082_o();
        tag.func_197646_b("Channels", channels.stream().collect(Collectors.toList()));
    }
}

