/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.blocks;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.CapabilityInfusable;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.bindings.DefaultAction;
import mcjty.lib.bindings.IAction;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.rftoolsutility.modules.screen.ScreenConfiguration;
import mcjty.rftoolsutility.modules.screen.ScreenModule;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenBlock;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenTileEntity;
import mcjty.rftoolsutility.modules.screen.modules.ComputerScreenModule;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;

public class ScreenControllerTileEntity
extends GenericTileEntity
implements ITickableTileEntity {
    public static final String ACTION_SCAN = "scan";
    public static final String ACTION_DETACH = "detach";
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(0).playerSlots(10, 70));
    public static final String COMPONENT_NAME = "screen_controller";
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)ScreenConfiguration.CONTROLLER_MAXENERGY.get()).intValue(), (long)((Integer)ScreenConfiguration.CONTROLLER_RECEIVEPERTICK.get()).intValue());
    private final LazyOptional<GenericEnergyStorage> energyHandler = LazyOptional.of(() -> this.energyStorage);
    private final LazyOptional<IInfusable> infusableHandler = LazyOptional.of(() -> new DefaultInfusable((TileEntity)this));
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Screen Controller").containerSupplier((windowId, player) -> new GenericContainer((ContainerType)ScreenModule.CONTAINER_SCREEN_CONTROLLER.get(), windowId.intValue(), (ContainerFactory)CONTAINER_FACTORY.get(), this.func_174877_v(), (GenericTileEntity)this)).energyHandler(() -> this.energyStorage));
    private List<BlockPos> connectedScreens = new ArrayList<BlockPos>();
    private int tickCounter = 20;

    public IAction[] getActions() {
        return new IAction[]{new DefaultAction(ACTION_SCAN, this::scan), new DefaultAction(ACTION_DETACH, this::detach)};
    }

    public ScreenControllerTileEntity() {
        super((TileEntityType)ScreenModule.TYPE_SCREEN_CONTROLLER.get());
    }

    private Object[] getScreenIndex(BlockPos coordinate) {
        int i = 0;
        for (BlockPos connectedScreen : this.connectedScreens) {
            if (connectedScreen.equals((Object)coordinate)) {
                return new Object[]{i};
            }
            ++i;
        }
        return null;
    }

    private Object[] setText(String tag, String text, int color) {
        this.clearText(tag);
        return this.addText(tag, text, color);
    }

    private Object[] addText(String tag, String text, int color) {
        for (BlockPos screen : this.connectedScreens) {
            ScreenTileEntity screenTileEntity;
            List<ComputerScreenModule> computerScreenModules;
            TileEntity te = this.field_145850_b.func_175625_s(screen);
            if (!(te instanceof ScreenTileEntity) || (computerScreenModules = (screenTileEntity = (ScreenTileEntity)te).getComputerModules(tag)) == null) continue;
            for (ComputerScreenModule screenModule : computerScreenModules) {
                screenModule.addText(text, color);
            }
        }
        return null;
    }

    private Object[] clearText(String tag) {
        for (BlockPos screen : this.connectedScreens) {
            ScreenTileEntity screenTileEntity;
            List<ComputerScreenModule> computerScreenModules;
            TileEntity te = this.field_145850_b.func_175625_s(screen);
            if (!(te instanceof ScreenTileEntity) || (computerScreenModules = (screenTileEntity = (ScreenTileEntity)te).getComputerModules(tag)) == null) continue;
            for (ComputerScreenModule screenModule : computerScreenModules) {
                screenModule.clearText();
            }
        }
        return null;
    }

    public void func_145839_a(CompoundNBT tagCompound) {
        super.func_145839_a(tagCompound);
        int[] xes = tagCompound.func_74759_k("screensx");
        int[] yes = tagCompound.func_74759_k("screensy");
        int[] zes = tagCompound.func_74759_k("screensz");
        this.connectedScreens.clear();
        for (int i = 0; i < xes.length; ++i) {
            this.connectedScreens.add(new BlockPos(xes[i], yes[i], zes[i]));
        }
        this.energyStorage.setEnergy(tagCompound.func_74763_f("Energy"));
    }

    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        int[] xes = new int[this.connectedScreens.size()];
        int[] yes = new int[this.connectedScreens.size()];
        int[] zes = new int[this.connectedScreens.size()];
        for (int i = 0; i < this.connectedScreens.size(); ++i) {
            BlockPos c = this.connectedScreens.get(i);
            xes[i] = c.func_177958_n();
            yes[i] = c.func_177956_o();
            zes[i] = c.func_177952_p();
        }
        tagCompound.func_74783_a("screensx", xes);
        tagCompound.func_74783_a("screensy", yes);
        tagCompound.func_74783_a("screensz", zes);
        tagCompound.func_74772_a("Energy", this.energyStorage.getEnergy());
        return tagCompound;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        long rf;
        --this.tickCounter;
        if (this.tickCounter > 0) {
            return;
        }
        this.tickCounter = 20;
        long rememberRf = rf = this.energyStorage.getEnergy();
        boolean fixesAreNeeded = false;
        for (BlockPos c : this.connectedScreens) {
            TileEntity te = this.field_145850_b.func_175625_s(c);
            if (te instanceof ScreenTileEntity) {
                ScreenTileEntity screenTileEntity = (ScreenTileEntity)te;
                int rfModule = screenTileEntity.getTotalRfPerTick() * 20;
                if ((long)rfModule > rf) {
                    screenTileEntity.setPower(false);
                    continue;
                }
                rf -= (long)rfModule;
                screenTileEntity.setPower(true);
                continue;
            }
            fixesAreNeeded = true;
        }
        if (rf < rememberRf) {
            this.energyStorage.consumeEnergy(rememberRf - rf);
        }
        if (fixesAreNeeded) {
            ArrayList<BlockPos> newScreens = new ArrayList<BlockPos>();
            for (BlockPos c : this.connectedScreens) {
                TileEntity te = this.field_145850_b.func_175625_s(c);
                if (!(te instanceof ScreenTileEntity)) continue;
                newScreens.add(c);
            }
            this.connectedScreens = newScreens;
            this.markDirtyClient();
        }
    }

    private void scan() {
        this.detach();
        float factor = ((Float)this.infusableHandler.map(IInfusable::getInfusedFactor).orElse((Object)Float.valueOf(0.0f))).floatValue();
        int radius = 32 + (int)(factor * 32.0f);
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        for (int y = yCoord - radius; y <= yCoord + radius; ++y) {
            if (y < 0 || y >= 256) continue;
            for (int x = xCoord - radius; x <= xCoord + radius; ++x) {
                for (int z = zCoord - radius; z <= zCoord + radius; ++z) {
                    ScreenTileEntity ste;
                    TileEntity te;
                    BlockPos spos = new BlockPos(x, y, z);
                    if (!(this.field_145850_b.func_180495_p(spos).func_177230_c() instanceof ScreenBlock) || !((te = this.field_145850_b.func_175625_s(spos)) instanceof ScreenTileEntity) || (ste = (ScreenTileEntity)te).isConnected() || !ste.isControllerNeeded()) continue;
                    this.connectedScreens.add(spos);
                    ste.setConnected(true);
                }
            }
        }
        this.markDirtyClient();
    }

    public void detach() {
        for (BlockPos c : this.connectedScreens) {
            TileEntity te = this.field_145850_b.func_175625_s(c);
            if (!(te instanceof ScreenTileEntity)) continue;
            ((ScreenTileEntity)te).setPower(false);
            ((ScreenTileEntity)te).setConnected(false);
        }
        this.connectedScreens.clear();
        this.markDirtyClient();
    }

    public List<BlockPos> getConnectedScreens() {
        return this.connectedScreens;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyHandler.cast();
        }
        if (cap == CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY) {
            return this.screenHandler.cast();
        }
        if (cap == CapabilityInfusable.INFUSABLE_CAPABILITY) {
            return this.infusableHandler.cast();
        }
        return super.getCapability(cap, facing);
    }
}

