/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.items.modules;

import mcjty.lib.varia.BlockTools;
import mcjty.lib.varia.CapabilityTools;
import mcjty.lib.varia.DimensionId;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.ModuleTools;
import mcjty.rftoolsbase.api.screens.IModuleGuiBuilder;
import mcjty.rftoolsbase.tools.GenericModuleItem;
import mcjty.rftoolsutility.RFToolsUtility;
import mcjty.rftoolsutility.modules.screen.ScreenConfiguration;
import mcjty.rftoolsutility.modules.screen.modules.ItemStackPlusScreenModule;
import mcjty.rftoolsutility.modules.screen.modulesclient.ItemStackPlusClientScreenModule;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class InventoryPlusModuleItem
extends GenericModuleItem {
    public InventoryPlusModuleItem() {
        super(new Item.Properties().func_200917_a(1).func_200915_b(1).func_200916_a(RFToolsUtility.setup.getTab()));
    }

    protected int getUses(ItemStack stack) {
        return (Integer)ScreenConfiguration.ITEMSTACKPLUS_RFPERTICK.get();
    }

    protected boolean hasGoldMessage(ItemStack stack) {
        return !ModuleTools.hasModuleTarget((ItemStack)stack);
    }

    protected String getInfoString(ItemStack stack) {
        return ModuleTools.getTargetString((ItemStack)stack);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            if (world.field_72995_K) {
                Logging.message((PlayerEntity)player, (String)(TextFormatting.RED + "This is not a valid inventory!"));
            }
            return ActionResultType.SUCCESS;
        }
        CompoundNBT tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new CompoundNBT();
        }
        if (CapabilityTools.getItemCapabilitySafe((TileEntity)te).isPresent()) {
            BlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            String name = "<invalid>";
            if (block != null && !block.isAir(state, (IBlockReader)world, pos)) {
                name = BlockTools.getReadableName((World)world, (BlockPos)pos);
            }
            ModuleTools.setPositionInModule((ItemStack)stack, (DimensionId)DimensionId.fromWorld((World)world), (BlockPos)pos, (String)name);
            if (world.field_72995_K) {
                Logging.message((PlayerEntity)player, (String)("Inventory module is set to block '" + name + "'"));
            }
        } else {
            ModuleTools.clearPositionInModule((ItemStack)stack);
            if (world.field_72995_K) {
                Logging.message((PlayerEntity)player, (String)"Inventory module is cleared");
            }
        }
        stack.func_77982_d(tagCompound);
        return ActionResultType.SUCCESS;
    }

    public Class<ItemStackPlusScreenModule> getServerScreenModule() {
        return ItemStackPlusScreenModule.class;
    }

    public Class<ItemStackPlusClientScreenModule> getClientScreenModule() {
        return ItemStackPlusClientScreenModule.class;
    }

    public String getModuleName() {
        return "Inv";
    }

    public void createGui(IModuleGuiBuilder guiBuilder) {
        guiBuilder.label("Slot 1:").integer("slot1", new String[]{"Slot index to show"}).nl().label("Slot 2:").integer("slot2", new String[]{"Slot index to show"}).nl().label("Slot 3:").integer("slot3", new String[]{"Slot index to show"}).nl().label("Slot 4:").integer("slot4", new String[]{"Slot index to show"}).nl().block("monitor").nl();
    }
}

