/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.modules;

import java.util.Objects;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.DimensionId;
import mcjty.lib.varia.WorldTools;
import mcjty.rftoolsbase.api.machineinfo.CapabilityMachineInformation;
import mcjty.rftoolsbase.api.screens.IScreenDataHelper;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.screens.data.IModuleDataString;
import mcjty.rftoolsutility.modules.screen.ScreenConfiguration;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class MachineInformationScreenModule
implements IScreenModule<IModuleDataString> {
    private int tag;
    protected DimensionId dim = DimensionId.overworld();
    protected BlockPos coordinate = BlockPosTools.INVALID;

    public IModuleDataString getData(IScreenDataHelper helper, World worldObj, long millis) {
        ServerWorld world = WorldTools.getWorld((World)worldObj, (DimensionId)this.dim);
        if (world == null) {
            return null;
        }
        if (!WorldTools.isLoaded((World)world, (BlockPos)this.coordinate)) {
            return null;
        }
        TileEntity te = world.func_175625_s(this.coordinate);
        if (te == null) {
            return null;
        }
        return (IModuleDataString)te.getCapability(CapabilityMachineInformation.MACHINE_INFORMATION_CAPABILITY).map(h -> {
            String info = this.tag < 0 || this.tag >= h.getTagCount() ? "[BAD TAG]" : h.getData(this.tag, millis);
            return helper.createString(info);
        }).orElse(null);
    }

    public void setupFromNBT(CompoundNBT tagCompound, DimensionId dim, BlockPos pos) {
        if (tagCompound != null) {
            this.coordinate = BlockPosTools.INVALID;
            this.tag = tagCompound.func_74762_e("monitorTag");
            if (tagCompound.func_74764_b("monitorx")) {
                this.dim = DimensionId.fromResourceLocation((ResourceLocation)new ResourceLocation(tagCompound.func_74779_i("monitordim")));
                if (Objects.equals(dim, this.dim)) {
                    BlockPos c = new BlockPos(tagCompound.func_74762_e("monitorx"), tagCompound.func_74762_e("monitory"), tagCompound.func_74762_e("monitorz"));
                    int dx = Math.abs(c.func_177958_n() - pos.func_177958_n());
                    int dy = Math.abs(c.func_177956_o() - pos.func_177956_o());
                    int dz = Math.abs(c.func_177952_p() - pos.func_177952_p());
                    if (dx <= 64 && dy <= 64 && dz <= 64) {
                        this.coordinate = c;
                    }
                }
            }
        }
    }

    public int getRfPerTick() {
        return (Integer)ScreenConfiguration.MACHINEINFO_RFPERTICK.get();
    }

    public void mouseClick(World world, int x, int y, boolean clicked, PlayerEntity player) {
    }
}

