/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.modules;

import java.util.Objects;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.DimensionId;
import mcjty.lib.varia.OrientationTools;
import mcjty.lib.varia.WorldTools;
import mcjty.rftoolsbase.api.screens.IScreenDataHelper;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.screens.data.IModuleDataInteger;
import mcjty.rftoolsutility.modules.screen.ScreenConfiguration;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class RedstoneScreenModule
implements IScreenModule<IModuleDataInteger> {
    private int channel = -1;
    private BlockPos coordinate = BlockPosTools.INVALID;
    private DimensionId dim = DimensionId.overworld();
    private Direction side = null;

    public IModuleDataInteger getData(IScreenDataHelper helper, World worldObj, long millis) {
        if (this.channel == -1) {
            ServerWorld world;
            if (!BlockPosTools.INVALID.equals((Object)this.coordinate) && (world = WorldTools.getWorld((World)worldObj, (DimensionId)this.dim)) != null) {
                int powerTo = world.func_175651_c(this.coordinate.func_177972_a(this.side), this.side.func_176734_d());
                return helper.createInteger(powerTo);
            }
            return null;
        }
        return null;
    }

    public void setupFromNBT(CompoundNBT tagCompound, DimensionId dim, BlockPos pos) {
        if (tagCompound != null) {
            this.channel = -1;
            if (tagCompound.func_74764_b("channel")) {
                this.channel = tagCompound.func_74762_e("channel");
            }
            if (tagCompound.func_74764_b("monitorx")) {
                this.side = OrientationTools.DIRECTION_VALUES[tagCompound.func_74762_e("monitorside")];
                this.dim = DimensionId.fromResourceLocation((ResourceLocation)new ResourceLocation(tagCompound.func_74779_i("monitordim")));
                if (Objects.equals(dim, this.dim)) {
                    BlockPos c = new BlockPos(tagCompound.func_74762_e("monitorx"), tagCompound.func_74762_e("monitory"), tagCompound.func_74762_e("monitorz"));
                    int dx = Math.abs(c.func_177958_n() - pos.func_177958_n());
                    int dy = Math.abs(c.func_177956_o() - pos.func_177956_o());
                    int dz = Math.abs(c.func_177952_p() - pos.func_177952_p());
                    if (dx <= 64 && dy <= 64 && dz <= 64) {
                        this.coordinate = c;
                    }
                }
            }
        }
    }

    public int getRfPerTick() {
        return (Integer)ScreenConfiguration.REDSTONE_RFPERTICK.get();
    }

    public void mouseClick(World world, int x, int y, boolean clicked, PlayerEntity player) {
    }
}

