/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.modulesclient;

import com.mojang.blaze3d.matrix.MatrixStack;
import mcjty.lib.varia.DimensionId;
import mcjty.rftoolsbase.api.screens.IClientScreenModule;
import mcjty.rftoolsbase.api.screens.IModuleRenderHelper;
import mcjty.rftoolsbase.api.screens.ITextRenderHelper;
import mcjty.rftoolsbase.api.screens.ModuleRenderInfo;
import mcjty.rftoolsbase.api.screens.TextAlign;
import mcjty.rftoolsbase.api.screens.data.IModuleDataInteger;
import mcjty.rftoolsbase.tools.ScreenTextHelper;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RedstoneClientScreenModule
implements IClientScreenModule<IModuleDataInteger> {
    private String line = "";
    private String yestext = "on";
    private String notext = "off";
    private int color = 0xFFFFFF;
    private int yescolor = 0xFFFFFF;
    private int nocolor = 0xFFFFFF;
    private int dim = 0;
    private boolean analog = false;
    private ITextRenderHelper labelCache = new ScreenTextHelper();

    public IClientScreenModule.TransformMode getTransformMode() {
        return IClientScreenModule.TransformMode.TEXT;
    }

    public int getHeight() {
        return 10;
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, IModuleRenderHelper renderHelper, FontRenderer fontRenderer, int currenty, IModuleDataInteger screenData, ModuleRenderInfo renderInfo) {
        int col;
        String text;
        int xoffset;
        if (!this.line.isEmpty()) {
            this.labelCache.setup(this.line, 160, renderInfo);
            this.labelCache.renderText(matrixStack, buffer, 0, currenty, this.color, renderInfo);
            xoffset = 47;
        } else {
            xoffset = 7;
        }
        if (screenData != null) {
            boolean rs;
            int power = screenData.get();
            boolean bl = rs = power > 0;
            text = this.analog ? Integer.toString(power) : (rs ? this.yestext : this.notext);
            col = rs ? this.yescolor : this.nocolor;
        } else {
            text = "<invalid>";
            col = 0xFF0000;
        }
        renderHelper.renderText(matrixStack, buffer, xoffset, currenty, col, renderInfo, text);
    }

    public void mouseClick(World world, int x, int y, boolean clicked) {
    }

    public void setupFromNBT(CompoundNBT tagCompound, DimensionId dim, BlockPos pos) {
        if (tagCompound != null) {
            this.line = tagCompound.func_74779_i("text");
            if (tagCompound.func_74764_b("yestext")) {
                this.yestext = tagCompound.func_74779_i("yestext");
            }
            if (tagCompound.func_74764_b("notext")) {
                this.notext = tagCompound.func_74779_i("notext");
            }
            this.color = tagCompound.func_74764_b("color") ? tagCompound.func_74762_e("color") : 0xFFFFFF;
            this.yescolor = tagCompound.func_74764_b("yescolor") ? tagCompound.func_74762_e("yescolor") : 0xFFFFFF;
            this.nocolor = tagCompound.func_74764_b("nocolor") ? tagCompound.func_74762_e("nocolor") : 0xFFFFFF;
            if (tagCompound.func_74764_b("align")) {
                String alignment = tagCompound.func_74779_i("align");
                this.labelCache.align(TextAlign.get((String)alignment));
            } else {
                this.labelCache.align(TextAlign.ALIGN_LEFT);
            }
            this.analog = tagCompound.func_74767_n("analog");
        }
    }

    public boolean needsServerData() {
        return true;
    }
}

