/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.spawner;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mcjty.rftoolsutility.setup.Config;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.loading.FileUtils;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class SpawnerConfiguration {
    public static final String CATEGORY_SPAWNER = "spawner";
    public static final String CATEGORY_MOBDATA = "mobdata";
    public static final ResourceLocation LIVING = new ResourceLocation("rftoolsutility", "living/living");
    public static final ResourceLocation LOWYIELD = new ResourceLocation("rftoolsutility", "living/lowyield");
    public static final ResourceLocation HIGHYIELD = new ResourceLocation("rftoolsutility", "living/highyield");
    public static final ResourceLocation AVERAGEYIELD = new ResourceLocation("rftoolsutility", "living/averageyield");
    public static final Tag<Item> TAG_LIVING = SpawnerConfiguration.tagItem(LIVING);
    public static final Tag<Item> TAG_LOWYIELD = SpawnerConfiguration.tagItem(LOWYIELD);
    public static final Tag<Item> TAG_HIGHYIELD = SpawnerConfiguration.tagItem(HIGHYIELD);
    public static final Tag<Item> TAG_AVERAGEYIELD = SpawnerConfiguration.tagItem(AVERAGEYIELD);
    private static final Map<String, MobData> mobData = new HashMap<String, MobData>();
    private static final Map<String, MobData> defaultMobData = new HashMap<String, MobData>();
    private static MobData unknownMobDefault;
    public static final int MATERIALTYPE_KEY = 0;
    public static final int MATERIALTYPE_BULK = 1;
    public static final int MATERIALTYPE_LIVING = 2;
    public static int SPAWNER_MAXENERGY;
    public static int SPAWNER_RECEIVEPERTICK;
    public static int BEAMER_MAXENERGY;
    public static int BEAMER_RECEIVEPERTICK;
    public static int beamRfPerObject;
    public static int beamBlocksPerSend;
    public static int maxBeamDistance;
    public static int maxMatterStorage;
    public static ForgeConfigSpec.IntValue maxMobInjections;

    private static Tag<Item> tagItem(ResourceLocation id) {
        return new ItemTags.Wrapper(id);
    }

    public static void initMobConfigs(ForgeConfigSpec.Builder SERVER_BUILDER) {
        SERVER_BUILDER.comment("Settings for the spawner system").push(CATEGORY_MOBDATA);
        SpawnerConfiguration.setupDefaultMobData();
        HashMap<String, List> byMod = new HashMap<String, List>();
        for (Map.Entry entry : ForgeRegistries.ENTITIES.getEntries()) {
            EntityType type = (EntityType)entry.getValue();
            if (type.func_220339_d() == EntityClassification.MISC) continue;
            ResourceLocation id = (ResourceLocation)entry.getKey();
            byMod.computeIfAbsent(id.func_110624_b(), s -> new ArrayList());
            ((List)byMod.get(id.func_110624_b())).add(id);
        }
        for (Map.Entry entry : byMod.entrySet()) {
            SERVER_BUILDER.push((String)entry.getKey());
            for (ResourceLocation id : (List)entry.getValue()) {
                SERVER_BUILDER.push(id.func_110623_a());
                MobData data = defaultMobData.getOrDefault(id.toString(), unknownMobDefault);
                ForgeConfigSpec.ConfigValue item1 = SERVER_BUILDER.define("item1", (Object)data.getItem1().serialize());
                ForgeConfigSpec.ConfigValue item2 = SERVER_BUILDER.define("item2", (Object)data.getItem2().serialize());
                ForgeConfigSpec.ConfigValue item3 = SERVER_BUILDER.define("item3", (Object)data.getItem3().serialize());
                ForgeConfigSpec.IntValue spawnRf = SERVER_BUILDER.defineInRange("spawnRf", data.getSpawnRf(), 0, Integer.MAX_VALUE);
                data = new UnresolvedMobData((ForgeConfigSpec.ConfigValue<String>)item1, (ForgeConfigSpec.ConfigValue<String>)item2, (ForgeConfigSpec.ConfigValue<String>)item3, spawnRf);
                mobData.put(id.toString(), data);
                SERVER_BUILDER.pop();
            }
            SERVER_BUILDER.pop();
        }
        SERVER_BUILDER.pop();
    }

    private static void setupDefaultMobData() {
        defaultMobData.put(EntityType.field_200791_e.getRegistryName().toString(), MobData.create().spawnRf(100).item1(MobSpawnAmount.create(Ingredient.func_199805_a((Tag)Tags.Items.FEATHERS), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.2f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 10.0f)));
        defaultMobData.put(EntityType.field_200792_f.getRegistryName().toString(), MobData.create().spawnRf(1000).item1(MobSpawnAmount.create(Ingredient.func_199805_a((Tag)Tags.Items.RODS_BLAZE), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221691_cH}), 0.5f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 30.0f)));
        defaultMobData.put(EntityType.field_200794_h.getRegistryName().toString(), MobData.create().spawnRf(500).item1(MobSpawnAmount.create(Ingredient.func_199805_a((Tag)Tags.Items.STRING), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.2f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 10.0f)));
        defaultMobData.put(EntityType.field_200795_i.getRegistryName().toString(), MobData.create().spawnRf(500).item1(MobSpawnAmount.create(Ingredient.func_199805_a((Tag)Tags.Items.FEATHERS), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.2f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 15.0f)));
        defaultMobData.put(EntityType.field_200783_W.getRegistryName().toString(), MobData.create().spawnRf(800).item1(MobSpawnAmount.create(Ingredient.func_199805_a((Tag)Tags.Items.FEATHERS), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.2f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 15.0f)));
        defaultMobData.put(EntityType.field_200796_j.getRegistryName().toString(), MobData.create().spawnRf(800).item1(MobSpawnAmount.create(Ingredient.func_199805_a((Tag)Tags.Items.LEATHER), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.2f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 20.0f)));
        defaultMobData.put(EntityType.field_200797_k.getRegistryName().toString(), MobData.create().spawnRf(800).item1(MobSpawnAmount.create(Ingredient.func_199805_a((Tag)Tags.Items.GUNPOWDER), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.5f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 20.0f)));
        defaultMobData.put(EntityType.field_200802_p.getRegistryName().toString(), MobData.create().spawnRf(100000).item1(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151062_by}), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221828_dx}), 100.0f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 200.0f)));
        defaultMobData.put(EntityType.field_200803_q.getRegistryName().toString(), MobData.create().spawnRf(2000).item1(MobSpawnAmount.create(Ingredient.func_199805_a((Tag)Tags.Items.ENDER_PEARLS), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221828_dx}), 0.5f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 40.0f)));
        defaultMobData.put(EntityType.field_200811_y.getRegistryName().toString(), MobData.create().spawnRf(2000).item1(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151073_bk}), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150424_aL}), 1.0f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 50.0f)));
        defaultMobData.put(EntityType.field_200762_B.getRegistryName().toString(), MobData.create().spawnRf(1000).item1(MobSpawnAmount.create(Ingredient.func_199805_a((Tag)Tags.Items.LEATHER), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.5f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 30.0f)));
        defaultMobData.put(EntityType.field_200742_ah.getRegistryName().toString(), MobData.create().spawnRf(1000).item1(MobSpawnAmount.create(Ingredient.func_199805_a((Tag)Tags.Items.BONES), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.5f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 30.0f)));
        defaultMobData.put(EntityType.field_200769_I.getRegistryName().toString(), MobData.create().spawnRf(1000).item1(MobSpawnAmount.create(Ingredient.func_199805_a((Tag)Tags.Items.LEATHER), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.5f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 30.0f)));
        defaultMobData.put(EntityType.field_220354_ax.getRegistryName().toString(), MobData.create().spawnRf(1200).item1(MobSpawnAmount.create(Ingredient.func_199805_a((Tag)Tags.Items.LEATHER), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.5f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 30.0f)));
        defaultMobData.put(EntityType.field_200779_S.getRegistryName().toString(), MobData.create().spawnRf(1000).item1(MobSpawnAmount.create(Ingredient.func_199805_a((Tag)Tags.Items.LEATHER), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.5f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 30.0f)));
        defaultMobData.put(EntityType.field_200798_l.getRegistryName().toString(), MobData.create().spawnRf(1000).item1(MobSpawnAmount.create(Ingredient.func_199805_a((Tag)Tags.Items.LEATHER), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.5f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 30.0f)));
        defaultMobData.put(EntityType.field_220353_aa.getRegistryName().toString(), MobData.create().spawnRf(1000).item1(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_222068_kQ}), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.5f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 30.0f)));
        defaultMobData.put(EntityType.field_226289_e_.getRegistryName().toString(), MobData.create().spawnRf(1000).item1(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_226639_pY_}), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.5f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 30.0f)));
        defaultMobData.put(EntityType.field_200726_aE.getRegistryName().toString(), MobData.create().spawnRf(1000).item1(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151078_bh}), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.5f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 30.0f)));
        defaultMobData.put(EntityType.field_200757_aw.getRegistryName().toString(), MobData.create().spawnRf(2000).item1(MobSpawnAmount.create(Ingredient.func_199805_a((Tag)Tags.Items.INGOTS_IRON), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 6.0f)).item3(MobSpawnAmount.create(Ingredient.func_199805_a((Tag)ItemTags.field_226159_I_), 0.5f)));
        defaultMobData.put(EntityType.field_200771_K.getRegistryName().toString(), MobData.create().spawnRf(600).item1(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151064_bs}), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150424_aL}), 0.2f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 10.0f)));
        defaultMobData.put(EntityType.field_200780_T.getRegistryName().toString(), MobData.create().spawnRf(800).item1(MobSpawnAmount.create(Ingredient.func_199805_a((Tag)Tags.Items.LEATHER), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 1.0f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 20.0f)));
        defaultMobData.put(EntityType.field_200781_U.getRegistryName().toString(), MobData.create().spawnRf(800).item1(MobSpawnAmount.create(Ingredient.func_199805_a((Tag)ItemTags.field_206964_G), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 1.0f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 20.0f)));
        defaultMobData.put(EntityType.field_220360_g.getRegistryName().toString(), MobData.create().spawnRf(800).item1(MobSpawnAmount.create(Ingredient.func_199805_a((Tag)ItemTags.field_206964_G), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 1.0f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 20.0f)));
        defaultMobData.put(EntityType.field_220356_B.getRegistryName().toString(), MobData.create().spawnRf(800).item1(MobSpawnAmount.create(Ingredient.func_199805_a((Tag)Tags.Items.BONES), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 1.0f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 20.0f)));
        defaultMobData.put(EntityType.field_200784_X.getRegistryName().toString(), MobData.create().spawnRf(800).item1(MobSpawnAmount.create(Ingredient.func_199805_a((Tag)Tags.Items.LEATHER), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.2f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 20.0f)));
        defaultMobData.put(EntityType.field_200737_ac.getRegistryName().toString(), MobData.create().spawnRf(800).item1(MobSpawnAmount.create(Ingredient.func_199805_a((Tag)ItemTags.field_199904_a), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.2f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 20.0f)));
        defaultMobData.put(EntityType.field_200741_ag.getRegistryName().toString(), MobData.create().spawnRf(800).item1(MobSpawnAmount.create(Ingredient.func_199805_a((Tag)Tags.Items.BONES), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.5f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 20.0f)));
        defaultMobData.put(EntityType.field_200743_ai.getRegistryName().toString(), MobData.create().spawnRf(600).item1(MobSpawnAmount.create(Ingredient.func_199805_a((Tag)Tags.Items.SLIMEBALLS), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.5f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 15.0f)));
        defaultMobData.put(EntityType.field_200745_ak.getRegistryName().toString(), MobData.create().spawnRf(600).item1(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151126_ay}), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 1.0f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 15.0f)));
        defaultMobData.put(EntityType.field_200748_an.getRegistryName().toString(), MobData.create().spawnRf(500).item1(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151007_F}), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.2f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 15.0f)));
        defaultMobData.put(EntityType.field_200749_ao.getRegistryName().toString(), MobData.create().spawnRf(500).item1(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_196136_br}), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.5f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 10.0f)));
        defaultMobData.put(EntityType.field_200756_av.getRegistryName().toString(), MobData.create().spawnRf(2000).item1(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151122_aG}), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 5.0f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 30.0f)));
        defaultMobData.put(EntityType.field_200727_aF.getRegistryName().toString(), MobData.create().spawnRf(1500).item1(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151078_bh}), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 5.0f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 30.0f)));
        defaultMobData.put(EntityType.field_220351_aK.getRegistryName().toString(), MobData.create().spawnRf(20000).item1(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221651_bN}), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 5.0f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 40.0f)));
        defaultMobData.put(EntityType.field_200759_ay.getRegistryName().toString(), MobData.create().spawnRf(1200).item1(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151069_bo}), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 1.0f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 30.0f)));
        defaultMobData.put(EntityType.field_200760_az.getRegistryName().toString(), MobData.create().spawnRf(20000).item1(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151156_bN}), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150425_aM}), 0.5f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 100.0f)));
        defaultMobData.put(EntityType.field_200724_aC.getRegistryName().toString(), MobData.create().spawnRf(800).item1(MobSpawnAmount.create(Ingredient.func_199805_a((Tag)Tags.Items.BONES), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.5f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 20.0f)));
        defaultMobData.put(EntityType.field_200785_Y.getRegistryName().toString(), MobData.create().spawnRf(1200).item1(MobSpawnAmount.create(Ingredient.func_199805_a((Tag)Tags.Items.NUGGETS_GOLD), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150424_aL}), 0.5f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 20.0f)));
        defaultMobData.put(EntityType.field_220350_aJ.getRegistryName().toString(), MobData.create().spawnRf(1000).item1(MobSpawnAmount.create(Ingredient.func_199805_a((Tag)Tags.Items.GEMS_EMERALD), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.2f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 20.0f)));
        defaultMobData.put(EntityType.field_200758_ax.getRegistryName().toString(), MobData.create().spawnRf(1000).item1(MobSpawnAmount.create(Ingredient.func_199805_a((Tag)Tags.Items.GEMS_EMERALD), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.2f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 20.0f)));
        defaultMobData.put(EntityType.field_200806_t.getRegistryName().toString(), MobData.create().spawnRf(2000).item1(MobSpawnAmount.create(Ingredient.func_199805_a((Tag)Tags.Items.GEMS_EMERALD), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.2f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 20.0f)));
        defaultMobData.put(EntityType.field_200764_D.getRegistryName().toString(), MobData.create().spawnRf(2000).item1(MobSpawnAmount.create(Ingredient.func_199805_a((Tag)Tags.Items.GEMS_EMERALD), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.2f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 20.0f)));
        defaultMobData.put(EntityType.field_220352_aU.getRegistryName().toString(), MobData.create().spawnRf(4000).item1(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151141_av}), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.2f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 60.0f)));
        defaultMobData.put(EntityType.field_203097_aH.getRegistryName().toString(), MobData.create().spawnRf(1000).item1(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_204840_eX}), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.2f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 20.0f)));
        defaultMobData.put(EntityType.field_200725_aD.getRegistryName().toString(), MobData.create().spawnRf(800).item1(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151078_bh}), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.2f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 20.0f)));
        defaultMobData.put(EntityType.field_204724_o.getRegistryName().toString(), MobData.create().spawnRf(800).item1(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151078_bh}), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.2f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 90.0f)));
        defaultMobData.put(EntityType.field_200812_z.getRegistryName().toString(), MobData.create().spawnRf(1500).item1(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151078_bh}), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.2f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 20.0f)));
        defaultMobData.put(EntityType.field_200763_C.getRegistryName().toString(), MobData.create().spawnRf(800).item1(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151078_bh}), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.2f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 20.0f)));
        defaultMobData.put(EntityType.field_200761_A.getRegistryName().toString(), MobData.create().spawnRf(1000).item1(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_179562_cC}), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.2f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 30.0f)));
        defaultMobData.put(EntityType.field_200800_n.getRegistryName().toString(), MobData.create().spawnRf(5000).item1(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_179562_cC}), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.2f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 60.0f)));
        defaultMobData.put(EntityType.field_200738_ad.getRegistryName().toString(), MobData.create().spawnRf(600).item1(MobSpawnAmount.create(Ingredient.func_199805_a((Tag)Tags.Items.ENDER_PEARLS), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150377_bs}), 0.2f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 20.0f)));
        defaultMobData.put(EntityType.field_200804_r.getRegistryName().toString(), MobData.create().spawnRf(400).item1(MobSpawnAmount.create(Ingredient.func_199805_a((Tag)Tags.Items.ENDER_PEARLS), 0.05f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150377_bs}), 0.2f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 10.0f)));
        defaultMobData.put(EntityType.field_200740_af.getRegistryName().toString(), MobData.create().spawnRf(400).item1(MobSpawnAmount.create(Ingredient.func_199805_a((Tag)Tags.Items.INGOTS_IRON), 0.05f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.2f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 10.0f)));
        defaultMobData.put(EntityType.field_200736_ab.getRegistryName().toString(), MobData.create().spawnRf(300).item1(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_179560_bq}), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.2f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 10.0f)));
        defaultMobData.put(EntityType.field_200786_Z.getRegistryName().toString(), MobData.create().spawnRf(1500).item1(MobSpawnAmount.create(Ingredient.func_199805_a((Tag)ItemTags.field_206964_G), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.2f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 20.0f)));
        defaultMobData.put(EntityType.field_205137_n.getRegistryName().toString(), MobData.create().spawnRf(1500).item1(MobSpawnAmount.create(Ingredient.func_199805_a((Tag)ItemTags.field_206964_G), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.2f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 20.0f)));
        defaultMobData.put(EntityType.field_203778_ae.getRegistryName().toString(), MobData.create().spawnRf(1000).item1(MobSpawnAmount.create(Ingredient.func_199805_a((Tag)ItemTags.field_206964_G), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.2f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 20.0f)));
        defaultMobData.put(EntityType.field_203780_j.getRegistryName().toString(), MobData.create().spawnRf(1000).item1(MobSpawnAmount.create(Ingredient.func_199805_a((Tag)ItemTags.field_206964_G), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.2f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 20.0f)));
        defaultMobData.put(EntityType.field_203779_Z.getRegistryName().toString(), MobData.create().spawnRf(1000).item1(MobSpawnAmount.create(Ingredient.func_199805_a((Tag)ItemTags.field_206964_G), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.2f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 20.0f)));
        defaultMobData.put(EntityType.field_204262_at.getRegistryName().toString(), MobData.create().spawnRf(1000).item1(MobSpawnAmount.create(Ingredient.func_199805_a((Tag)ItemTags.field_206964_G), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.2f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 20.0f)));
        defaultMobData.put(EntityType.field_200755_au.getRegistryName().toString(), MobData.create().spawnRf(1000).item1(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151040_l}), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.2f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 20.0f)));
        defaultMobData.put(EntityType.field_203099_aq.getRegistryName().toString(), MobData.create().spawnRf(1500).item1(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221600_aB}), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221582_j, Items.field_221550_C, Items.field_221548_A}), 0.2f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 20.0f)));
        defaultMobData.put(EntityType.field_200722_aA.getRegistryName().toString(), MobData.create().spawnRf(1500).item1(MobSpawnAmount.create(Ingredient.func_199805_a((Tag)Tags.Items.BONES), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150424_aL}), 0.5f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 30.0f)));
        defaultMobData.put(EntityType.field_200750_ap.getRegistryName().toString(), MobData.create().spawnRf(800).item1(MobSpawnAmount.create(Ingredient.func_199805_a((Tag)Tags.Items.BONES), 0.1f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150424_aL}), 0.5f)).item3(MobSpawnAmount.create(Ingredient.field_193370_a, 20.0f)));
    }

    public static void init(ForgeConfigSpec.Builder SERVER_BUILDER, ForgeConfigSpec.Builder CLIENT_BUILDER) {
        SERVER_BUILDER.comment("Settings for the spawner system").push(CATEGORY_SPAWNER);
        CLIENT_BUILDER.comment("Settings for the spawner system").push(CATEGORY_SPAWNER);
        maxMobInjections = SERVER_BUILDER.comment("Maximum amount of injections we need to do a full mob extraction.").defineInRange("maxMobInjections", 10, 1, Integer.MAX_VALUE);
        CLIENT_BUILDER.pop();
        SERVER_BUILDER.pop();
        unknownMobDefault = MobData.create().item1(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221598_z}), 1.0f)).item2(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221598_z}), 1.0f)).item3(MobSpawnAmount.create(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221598_z}), 1.0f)).spawnRf(50000);
    }

    public static void onWorldLoad(WorldEvent.Load event) {
        if (!event.getWorld().func_201670_d()) {
            SpawnerConfiguration.initMobDataConfig();
        }
    }

    public static void initMobDataConfig() {
        ForgeConfigSpec.Builder SERVER_BUILDER = new ForgeConfigSpec.Builder();
        SpawnerConfiguration.initMobConfigs(SERVER_BUILDER);
        ForgeConfigSpec configSpec = SERVER_BUILDER.build();
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        Path serverConfig = server.func_71254_M().func_186352_b(server.func_71270_I(), "serverconfig").toPath();
        FileUtils.getOrCreateDirectory((Path)serverConfig, (String)"serverconfig");
        Config.loadConfig(configSpec, serverConfig.resolve("rftoolsutility-mobdata.toml"));
    }

    public static MobData getMobData(String id) {
        MobData mobData = SpawnerConfiguration.mobData.get(id);
        if (!mobData.isResoled()) {
            mobData = mobData.resolve();
            SpawnerConfiguration.mobData.put(id, mobData);
        }
        return mobData;
    }

    static {
        SPAWNER_MAXENERGY = 200000;
        SPAWNER_RECEIVEPERTICK = 2000;
        BEAMER_MAXENERGY = 200000;
        BEAMER_RECEIVEPERTICK = 1000;
        beamRfPerObject = 2000;
        beamBlocksPerSend = 1;
        maxBeamDistance = 8;
        maxMatterStorage = 6400;
    }

    public static class UnresolvedMobData
    extends MobData {
        private final ForgeConfigSpec.ConfigValue<String> item1;
        private final ForgeConfigSpec.ConfigValue<String> item2;
        private final ForgeConfigSpec.ConfigValue<String> item3;
        private final ForgeConfigSpec.IntValue spawnRf;

        public UnresolvedMobData(ForgeConfigSpec.ConfigValue<String> item1, ForgeConfigSpec.ConfigValue<String> item2, ForgeConfigSpec.ConfigValue<String> item3, ForgeConfigSpec.IntValue spawnRf) {
            this.item1 = item1;
            this.item2 = item2;
            this.item3 = item3;
            this.spawnRf = spawnRf;
        }

        @Override
        public boolean isResoled() {
            return false;
        }

        @Override
        public MobData resolve() {
            return MobData.create().item1(MobSpawnAmount.create((String)this.item1.get())).item2(MobSpawnAmount.create((String)this.item2.get())).item3(MobSpawnAmount.create((String)this.item3.get())).spawnRf((Integer)this.spawnRf.get());
        }
    }

    public static class MobData {
        private MobSpawnAmount item1;
        private MobSpawnAmount item2;
        private MobSpawnAmount item3;
        private int spawnRf;

        public static MobData create() {
            return new MobData();
        }

        public boolean isResoled() {
            return true;
        }

        public MobData resolve() {
            return this;
        }

        public MobData item1(MobSpawnAmount item1) {
            this.item1 = item1;
            return this;
        }

        public MobData item2(MobSpawnAmount item2) {
            this.item2 = item2;
            return this;
        }

        public MobData item3(MobSpawnAmount item3) {
            this.item3 = item3;
            return this;
        }

        public MobData spawnRf(int spawnRf) {
            this.spawnRf = spawnRf;
            return this;
        }

        public MobSpawnAmount getItem1() {
            return this.item1;
        }

        public MobSpawnAmount getItem2() {
            return this.item2;
        }

        public MobSpawnAmount getItem3() {
            return this.item3;
        }

        public MobSpawnAmount getItem(int index) {
            switch (index) {
                case 0: {
                    return this.item1;
                }
                case 1: {
                    return this.item2;
                }
                case 2: {
                    return this.item3;
                }
            }
            throw new IllegalStateException("Bad index for MobData.getItem()!");
        }

        public int getSpawnRf() {
            return this.spawnRf;
        }
    }

    public static class MobSpawnAmount {
        private final Ingredient object;
        private final float amount;

        public MobSpawnAmount(Ingredient object, float amount) {
            this.object = object;
            this.amount = amount;
        }

        public static MobSpawnAmount create(Ingredient object, float amount) {
            return new MobSpawnAmount(object, amount);
        }

        public static MobSpawnAmount create(String object) {
            Ingredient ingredient;
            int index = object.indexOf(58);
            if (index == -1) {
                throw new IllegalStateException("Bad formatted config for mob data!");
            }
            String amountString = object.substring(0, index);
            Float amount = Float.valueOf(Float.parseFloat(amountString));
            if ("<living>".equals(object = object.substring(index + 1))) {
                ingredient = Ingredient.field_193370_a;
            } else {
                JsonParser parser = new JsonParser();
                JsonElement element = parser.parse(object.replaceAll("'", "\""));
                ingredient = Ingredient.func_199802_a((JsonElement)element);
            }
            return new MobSpawnAmount(ingredient, amount.floatValue());
        }

        public Ingredient getObject() {
            return this.object;
        }

        public String serialize() {
            if (this.object.func_203189_d()) {
                return Float.toString(this.amount) + ":<living>";
            }
            return Float.toString(this.amount) + ":" + this.object.func_200304_c().toString().replaceAll("\"", "'");
        }

        public float getAmount() {
            return this.amount;
        }

        public Float match(ItemStack stack) {
            if (this.object.func_203189_d()) {
                Item item = stack.func_77973_b();
                Set tags = item.getTags();
                if (tags.contains(HIGHYIELD)) {
                    return Float.valueOf(1.5f);
                }
                if (tags.contains(AVERAGEYIELD)) {
                    return Float.valueOf(1.0f);
                }
                if (tags.contains(LOWYIELD)) {
                    return Float.valueOf(0.5f);
                }
                return Float.valueOf(0.0f);
            }
            if (this.object.test(stack)) {
                return Float.valueOf(1.0f);
            }
            return null;
        }
    }
}

