/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.blocks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.CapabilityInfusable;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.DimensionId;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.OrientationTools;
import mcjty.lib.varia.WorldTools;
import mcjty.rftoolsutility.modules.teleporter.TeleportConfiguration;
import mcjty.rftoolsutility.modules.teleporter.TeleportationTools;
import mcjty.rftoolsutility.modules.teleporter.TeleporterModule;
import mcjty.rftoolsutility.modules.teleporter.blocks.MatterReceiverTileEntity;
import mcjty.rftoolsutility.modules.teleporter.blocks.MatterTransmitterTileEntity;
import mcjty.rftoolsutility.modules.teleporter.client.GuiDialingDevice;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestination;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestinationClientInfo;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestinations;
import mcjty.rftoolsutility.modules.teleporter.data.TransmitterInfo;
import mcjty.rftoolsutility.playerprops.PlayerExtendedProperties;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class DialingDeviceTileEntity
extends GenericTileEntity {
    public static final String CMD_TELEPORT = "tp";
    public static final String CMD_GETRECEIVERS = "getReceivers";
    public static final String CLIENTCMD_GETRECEIVERS = "getReceivers";
    public static final String CMD_DIAL = "dial";
    public static final String CMD_DIALONCE = "dialOnce";
    public static final Key<Integer> PARAM_STATUS = new Key("status", Type.INTEGER);
    public static final String CMD_FAVORITE = "dialer.favorite";
    public static final String CMD_SHOWFAVORITE = "dialer.showFavorite";
    public static final Key<String> PARAM_PLAYER = new Key("player", Type.STRING);
    public static final Key<UUID> PARAM_PLAYER_UUID = new Key("playerUuid", Type.UUID);
    public static final Key<BlockPos> PARAM_POS = new Key("pos", Type.BLOCKPOS);
    public static final Key<String> PARAM_DIMENSION = new Key("dimension", Type.STRING);
    public static final Key<BlockPos> PARAM_TRANSMITTER = new Key("transmitter", Type.BLOCKPOS);
    public static final Key<String> PARAM_TRANS_DIMENSION = new Key("transDimension", Type.STRING);
    public static final Key<Boolean> PARAM_FAVORITE = new Key("favorite", Type.BOOLEAN);
    public static final String CMD_GETTRANSMITTERS = "getTransmitters";
    public static final String CLIENTCMD_GETTRANSMITTERS = "getTransmitters";
    public static final String CMD_CHECKSTATUS = "checkStatus";
    public static final int DIAL_RECEIVER_BLOCKED_MASK = 1;
    public static final int DIAL_TRANSMITTER_BLOCKED_MASK = 2;
    public static final int DIAL_INVALID_DESTINATION_MASK = 4;
    public static final int DIAL_DIALER_POWER_LOW_MASK = 8;
    public static final int DIAL_RECEIVER_POWER_LOW_MASK = 16;
    public static final int DIAL_TRANSMITTER_NOACCESS = 32;
    public static final int DIAL_RECEIVER_NOACCESS = 64;
    public static final int DIAL_INTERRUPTED = 128;
    public static final int DIAL_INVALID_SOURCE_MASK = 256;
    public static final int DIAL_DIMENSION_POWER_LOW_MASK = 512;
    public static final int DIAL_INVALID_TRANSMITTER = 1024;
    public static final int DIAL_OK = 0;
    public static final String COMPONENT_NAME = "dialing_device";
    private boolean showOnlyFavorites = false;
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)TeleportConfiguration.DIALER_MAXENERGY.get()).intValue(), (long)((Integer)TeleportConfiguration.DIALER_RECEIVEPERTICK.get()).intValue());
    private final LazyOptional<GenericEnergyStorage> energyHandler = LazyOptional.of(() -> this.energyStorage);
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Dialing Device").containerSupplier((windowId, player) -> new GenericContainer((ContainerType)TeleporterModule.CONTAINER_DIALING_DEVICE.get(), windowId.intValue(), (ContainerFactory)ContainerFactory.EMPTY.get(), this.func_174877_v(), (GenericTileEntity)this)).energyHandler(() -> this.energyStorage));
    private final LazyOptional<IInfusable> infusableHandler = LazyOptional.of(() -> new DefaultInfusable((TileEntity)this));

    public DialingDeviceTileEntity() {
        super((TileEntityType)TeleporterModule.TYPE_DIALING_DEVICE.get());
    }

    public static String calculateDistance(World world, TransmitterInfo transmitterInfo, TeleportDestination teleportDestination) {
        if (!world.func_201675_m().func_186058_p().equals(teleportDestination.getDimension())) {
            return "dimension warp";
        }
        BlockPos c1 = transmitterInfo.getCoordinate();
        BlockPos c2 = teleportDestination.getCoordinate();
        double dist = new Vec3d((double)c1.func_177958_n(), (double)c1.func_177956_o(), (double)c1.func_177952_p()).func_72438_d(new Vec3d((double)c2.func_177958_n(), (double)c2.func_177956_o(), (double)c2.func_177952_p()));
        return Integer.toString((int)dist);
    }

    public static boolean isMatterBoosterAvailable(World world, BlockPos pos) {
        for (Direction facing : OrientationTools.DIRECTION_VALUES) {
            if (!TeleporterModule.MATTER_BOOSTER.equals((Object)world.func_180495_p(pos.func_177972_a(facing)).func_177230_c())) continue;
            return true;
        }
        return false;
    }

    public static boolean isDestinationAnalyzerAvailable(World world, BlockPos pos) {
        for (Direction facing : OrientationTools.DIRECTION_VALUES) {
            if (!TeleporterModule.DESTINATION_ANALYZER.equals((Object)world.func_180495_p(pos.func_177972_a(facing)).func_177230_c())) continue;
            return true;
        }
        return false;
    }

    public boolean isShowOnlyFavorites() {
        return this.showOnlyFavorites;
    }

    public void setShowOnlyFavorites(boolean showOnlyFavorites) {
        this.showOnlyFavorites = showOnlyFavorites;
        this.markDirtyClient();
    }

    public void func_145839_a(CompoundNBT tagCompound) {
        super.func_145839_a(tagCompound);
        this.energyStorage.setEnergy(tagCompound.func_74763_f("Energy"));
        CompoundNBT info = tagCompound.func_74775_l("Info");
        this.showOnlyFavorites = info.func_74767_n("showFav");
    }

    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        this.getOrCreateInfo(tagCompound).func_74757_a("showFav", this.showOnlyFavorites);
        tagCompound.func_74772_a("Energy", this.energyStorage.getEnergy());
        return tagCompound;
    }

    private List<TeleportDestinationClientInfo> searchReceivers(UUID player) {
        TeleportDestinations destinations = TeleportDestinations.get(this.field_145850_b);
        return new ArrayList<TeleportDestinationClientInfo>(destinations.getValidDestinations(this.field_145850_b, player));
    }

    public List<TransmitterInfo> searchTransmitters() {
        int x = this.func_174877_v().func_177958_n();
        int y = this.func_174877_v().func_177956_o();
        int z = this.func_174877_v().func_177952_p();
        int hrange = (Integer)TeleportConfiguration.horizontalDialerRange.get();
        int vrange = (Integer)TeleportConfiguration.verticalDialerRange.get();
        ArrayList<TransmitterInfo> transmitters = new ArrayList<TransmitterInfo>();
        for (int dy = -vrange; dy <= vrange; ++dy) {
            int yy = y + dy;
            if (yy < 0 || yy >= this.field_145850_b.func_217301_I()) continue;
            for (int dz = -hrange; dz <= hrange; ++dz) {
                int zz = z + dz;
                for (int dx = -hrange; dx <= hrange; ++dx) {
                    int xx = x + dx;
                    if (dx == 0 && dy == 0 && dz == 0) continue;
                    BlockPos c = new BlockPos(xx, yy, zz);
                    BlockState state = this.field_145850_b.func_180495_p(c);
                    TileEntity tileEntity = this.field_145850_b.func_175625_s(c);
                    if (!(tileEntity instanceof MatterTransmitterTileEntity)) continue;
                    MatterTransmitterTileEntity matterTransmitterTileEntity = (MatterTransmitterTileEntity)tileEntity;
                    transmitters.add(new TransmitterInfo(c, matterTransmitterTileEntity.getName(), matterTransmitterTileEntity.getTeleportDestination()));
                }
            }
        }
        return transmitters;
    }

    private void changeFavorite(String playerName, BlockPos receiver, DimensionId dimension, boolean favorite) {
        List list = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v();
        for (ServerPlayerEntity entity : list) {
            if (!playerName.equals(entity.func_200200_C_())) continue;
            PlayerExtendedProperties.getFavoriteDestinations((PlayerEntity)entity).ifPresent(h -> h.setDestinationFavorite(new GlobalCoordinate(receiver, dimension), favorite));
            return;
        }
    }

    private int dial(UUID player, BlockPos transmitter, DimensionId transDim, BlockPos coordinate, DimensionId dimension, boolean once) {
        return TeleportationTools.dial(this.field_145850_b, this, player, transmitter, transDim, coordinate, dimension, once);
    }

    private int checkStatus(BlockPos c, DimensionId dim) {
        int s;
        int defaultCost = (Integer)TeleportConfiguration.rfPerCheck.get();
        int cost = (Integer)this.infusableHandler.map(inf -> (int)((float)defaultCost * (2.0f - inf.getInfusedFactor()) / 2.0f)).orElse((Object)defaultCost);
        if (this.energyStorage.getEnergy() < (long)cost) {
            s = 8;
        } else {
            this.energyStorage.consumeEnergy((long)cost);
            s = 0;
        }
        if (s != 0) {
            return s;
        }
        ServerWorld w = WorldTools.loadWorld((DimensionId)dim);
        if (w == null) {
            TeleportDestinations destinations = TeleportDestinations.get(this.field_145850_b);
            destinations.cleanupInvalid();
            return 4;
        }
        TileEntity tileEntity = w.func_175625_s(c);
        if (!(tileEntity instanceof MatterReceiverTileEntity)) {
            TeleportDestinations destinations = TeleportDestinations.get(this.field_145850_b);
            destinations.cleanupInvalid();
            return 4;
        }
        MatterReceiverTileEntity matterReceiverTileEntity = (MatterReceiverTileEntity)tileEntity;
        return matterReceiverTileEntity.checkStatus();
    }

    @Nonnull
    public <T> List<T> executeWithResultList(String command, TypedMap args, Type<T> type) {
        List rc = super.executeWithResultList(command, args, type);
        if (!rc.isEmpty()) {
            return rc;
        }
        if ("getReceivers".equals(command)) {
            UUID player = (UUID)args.get(PARAM_PLAYER_UUID);
            return type.convert(this.searchReceivers(player));
        }
        if ("getTransmitters".equals(command)) {
            return type.convert(this.searchTransmitters());
        }
        return Collections.emptyList();
    }

    public boolean execute(PlayerEntity playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return rc;
        }
        if (CMD_FAVORITE.equals(command)) {
            String player = (String)params.get(PARAM_PLAYER);
            BlockPos receiver = (BlockPos)params.get(PARAM_POS);
            String dimension = (String)params.get(PARAM_DIMENSION);
            boolean favorite = (Boolean)params.get(PARAM_FAVORITE);
            this.changeFavorite(player, receiver, DimensionId.fromResourceLocation((ResourceLocation)new ResourceLocation(dimension)), favorite);
            return true;
        }
        if (CMD_SHOWFAVORITE.equals(command)) {
            boolean favorite = (Boolean)params.get(PARAM_FAVORITE);
            this.setShowOnlyFavorites(favorite);
            return true;
        }
        return false;
    }

    public TypedMap executeWithResult(String command, TypedMap args) {
        TypedMap rc = super.executeWithResult(command, args);
        if (rc != null) {
            return rc;
        }
        if (CMD_CHECKSTATUS.equals(command)) {
            BlockPos c = (BlockPos)args.get(PARAM_POS);
            String dim = (String)args.get(PARAM_DIMENSION);
            return TypedMap.builder().put(PARAM_STATUS, (Object)this.checkStatus(c, DimensionId.fromResourceLocation((ResourceLocation)new ResourceLocation(dim)))).build();
        }
        if (CMD_DIAL.equals(command)) {
            UUID player = (UUID)args.get(PARAM_PLAYER_UUID);
            BlockPos transmitter = (BlockPos)args.get(PARAM_TRANSMITTER);
            String transDim = (String)args.get(PARAM_TRANS_DIMENSION);
            BlockPos c = (BlockPos)args.get(PARAM_POS);
            String dim = (String)args.get(PARAM_DIMENSION);
            return TypedMap.builder().put(PARAM_STATUS, (Object)this.dial(player, transmitter, DimensionId.fromResourceLocation((ResourceLocation)new ResourceLocation(transDim)), c, DimensionId.fromResourceLocation((ResourceLocation)new ResourceLocation(dim)), false)).build();
        }
        if (CMD_DIALONCE.equals(command)) {
            UUID player = (UUID)args.get(PARAM_PLAYER_UUID);
            BlockPos transmitter = (BlockPos)args.get(PARAM_TRANSMITTER);
            String transDim = (String)args.get(PARAM_TRANS_DIMENSION);
            BlockPos c = (BlockPos)args.get(PARAM_POS);
            String dim = (String)args.get(PARAM_DIMENSION);
            return TypedMap.builder().put(PARAM_STATUS, (Object)this.dial(player, transmitter, DimensionId.fromResourceLocation((ResourceLocation)new ResourceLocation(transDim)), c, DimensionId.fromResourceLocation((ResourceLocation)new ResourceLocation(dim)), true)).build();
        }
        return null;
    }

    public <T> boolean receiveListFromServer(String command, List<T> list, Type<T> type) {
        boolean rc = super.receiveListFromServer(command, list, type);
        if (rc) {
            return true;
        }
        if ("getReceivers".equals(command)) {
            GuiDialingDevice.fromServer_receivers = Type.create(TeleportDestinationClientInfo.class).convert(list);
            return true;
        }
        if ("getTransmitters".equals(command)) {
            GuiDialingDevice.fromServer_transmitters = Type.create(TransmitterInfo.class).convert(list);
            return true;
        }
        return false;
    }

    public boolean receiveDataFromServer(String command, @Nonnull TypedMap result) {
        boolean rc = super.receiveDataFromServer(command, result);
        if (rc) {
            return true;
        }
        if (CMD_CHECKSTATUS.equals(command)) {
            GuiDialingDevice.fromServer_receiverStatus = (Integer)result.get(PARAM_STATUS);
            return true;
        }
        if (CMD_DIAL.equals(command) || CMD_DIALONCE.equals(command)) {
            GuiDialingDevice.fromServer_dialResult = (Integer)result.get(PARAM_STATUS);
            return true;
        }
        return false;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyHandler.cast();
        }
        if (cap == CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY) {
            return this.screenHandler.cast();
        }
        if (cap == CapabilityInfusable.INFUSABLE_CAPABILITY) {
            return this.infusableHandler.cast();
        }
        return super.getCapability(cap, facing);
    }
}

