/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.blocks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.CapabilityInfusable;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.bindings.DefaultValue;
import mcjty.lib.bindings.IValue;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.DimensionId;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.rftoolsutility.modules.teleporter.TeleportConfiguration;
import mcjty.rftoolsutility.modules.teleporter.TeleporterModule;
import mcjty.rftoolsutility.modules.teleporter.client.GuiMatterReceiver;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestination;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestinations;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;

public class MatterReceiverTileEntity
extends GenericTileEntity
implements ITickableTileEntity {
    public static final String CMD_ADDPLAYER = "receiver.addPlayer";
    public static final String CMD_DELPLAYER = "receiver.delPlayer";
    public static final Key<String> PARAM_PLAYER = new Key("player", Type.STRING);
    public static final String CMD_GETPLAYERS = "getPlayers";
    public static final String CLIENTCMD_GETPLAYERS = "getPlayers";
    private String name = null;
    private boolean privateAccess = false;
    private final Set<String> allowedPlayers = new HashSet<String>();
    private int id = -1;
    public static final Key<String> VALUE_NAME = new Key("name", Type.STRING);
    public static final Key<Boolean> VALUE_PRIVATE = new Key("private", Type.BOOLEAN);
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)TeleportConfiguration.RECEIVER_MAXENERGY.get()).intValue(), (long)((Integer)TeleportConfiguration.RECEIVER_RECEIVEPERTICK.get()).intValue());
    private final LazyOptional<GenericEnergyStorage> energyHandler = LazyOptional.of(() -> this.energyStorage);
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Matter Receiver").containerSupplier((windowId, player) -> new GenericContainer((ContainerType)TeleporterModule.CONTAINER_MATTER_RECEIVER.get(), windowId.intValue(), (ContainerFactory)ContainerFactory.EMPTY.get(), this.func_174877_v(), (GenericTileEntity)this)).energyHandler(() -> this.energyStorage));
    private final LazyOptional<IInfusable> infusableHandler = LazyOptional.of(() -> new DefaultInfusable((TileEntity)this));
    private BlockPos cachedPos;

    public IValue<?>[] getValues() {
        return new IValue[]{new DefaultValue(VALUE_NAME, this::getName, this::setName), new DefaultValue(VALUE_PRIVATE, this::isPrivateAccess, this::setPrivateAccess)};
    }

    public MatterReceiverTileEntity() {
        super((TileEntityType)TeleporterModule.TYPE_MATTER_RECEIVER.get());
    }

    public String getName() {
        return this.name == null ? "" : this.name;
    }

    public int getOrCalculateID() {
        if (this.id == -1) {
            TeleportDestinations destinations = TeleportDestinations.get(this.field_145850_b);
            GlobalCoordinate gc = new GlobalCoordinate(this.func_174877_v(), this.field_145850_b);
            this.id = destinations.getNewId(gc);
            destinations.save();
            this.setId(this.id);
        }
        return this.id;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
        this.markDirtyClient();
    }

    public void setName(String name) {
        this.name = name;
        TeleportDestinations destinations = TeleportDestinations.get(this.field_145850_b);
        TeleportDestination destination = destinations.getDestination(this.func_174877_v(), DimensionId.fromWorld((World)this.field_145850_b));
        if (destination != null) {
            destination.setName(name);
            destinations.save();
        }
        this.markDirtyClient();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.checkStateServer();
        }
    }

    public void consumeEnergy(long amount) {
        this.energyStorage.consumeEnergy(amount);
    }

    private void checkStateServer() {
        if (!this.func_174877_v().equals((Object)this.cachedPos)) {
            TeleportDestinations destinations = TeleportDestinations.get(this.field_145850_b);
            destinations.removeDestination(this.cachedPos, DimensionId.fromWorld((World)this.field_145850_b));
            this.cachedPos = this.func_174877_v();
            GlobalCoordinate gc = new GlobalCoordinate(this.func_174877_v(), this.field_145850_b);
            if (this.id == -1) {
                this.id = destinations.getNewId(gc);
            } else {
                destinations.assignId(gc, this.id);
            }
            destinations.addDestination(gc);
            destinations.save();
            this.func_70296_d();
        }
    }

    public void updateDestination() {
        GlobalCoordinate gc;
        TeleportDestinations destinations = TeleportDestinations.get(this.field_145850_b);
        TeleportDestination destination = destinations.getDestination((gc = new GlobalCoordinate(this.func_174877_v(), this.field_145850_b)).getCoordinate(), gc.getDimension());
        if (destination != null) {
            destination.setName(this.name);
            if (this.id == -1) {
                this.id = destinations.getNewId(gc);
                this.func_70296_d();
            } else {
                destinations.assignId(gc, this.id);
            }
            destinations.save();
        }
        this.markDirtyClient();
    }

    public boolean isPrivateAccess() {
        return this.privateAccess;
    }

    public void setPrivateAccess(boolean privateAccess) {
        this.privateAccess = privateAccess;
        this.markDirtyClient();
    }

    public boolean checkAccess(UUID player) {
        if (!this.privateAccess) {
            return true;
        }
        PlayerEntity playerByUuid = this.field_145850_b.func_217371_b(player);
        return this.allowedPlayers.contains(playerByUuid.func_145748_c_().func_150254_d());
    }

    public List<String> getAllowedPlayers() {
        return new ArrayList<String>(this.allowedPlayers);
    }

    public void addPlayer(String player) {
        if (!this.allowedPlayers.contains(player)) {
            this.allowedPlayers.add(player);
            this.markDirtyClient();
        }
    }

    public void delPlayer(String player) {
        if (this.allowedPlayers.contains(player)) {
            this.allowedPlayers.remove(player);
            this.markDirtyClient();
        }
    }

    public int checkStatus() {
        BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v().func_177984_a());
        Block block = state.func_177230_c();
        if (!block.isAir(state, (IBlockReader)this.field_145850_b, this.func_174877_v().func_177984_a())) {
            return 1;
        }
        block = this.field_145850_b.func_180495_p(this.func_174877_v().func_177981_b(2)).func_177230_c();
        if (!block.isAir(state, (IBlockReader)this.field_145850_b, this.func_174877_v().func_177981_b(2))) {
            return 1;
        }
        if (this.getStoredPower() < (Integer)TeleportConfiguration.rfPerTeleportReceiver.get()) {
            return 16;
        }
        return 0;
    }

    private int getStoredPower() {
        return this.energyStorage.getEnergyStored();
    }

    public void func_145839_a(CompoundNBT tagCompound) {
        super.func_145839_a(tagCompound);
        this.cachedPos = new BlockPos(tagCompound.func_74762_e("cachedX"), tagCompound.func_74762_e("cachedY"), tagCompound.func_74762_e("cachedZ"));
        this.readRestorableFromNBT(tagCompound);
    }

    public void readRestorableFromNBT(CompoundNBT tagCompound) {
        this.energyStorage.setEnergy(tagCompound.func_74763_f("Energy"));
        CompoundNBT info = tagCompound.func_74775_l("Info");
        this.name = info.func_74779_i("tpName");
        this.privateAccess = info.func_74767_n("private");
        this.allowedPlayers.clear();
        ListNBT playerList = info.func_150295_c("players", 8);
        for (int i = 0; i < playerList.size(); ++i) {
            this.allowedPlayers.add(playerList.func_150307_f(i));
        }
        this.id = info.func_74764_b("destinationId") ? info.func_74762_e("destinationId") : -1;
    }

    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        if (this.cachedPos != null) {
            tagCompound.func_74768_a("cachedX", this.cachedPos.func_177958_n());
            tagCompound.func_74768_a("cachedY", this.cachedPos.func_177956_o());
            tagCompound.func_74768_a("cachedZ", this.cachedPos.func_177952_p());
        }
        this.writeRestorableToNBT(tagCompound);
        return tagCompound;
    }

    public void writeRestorableToNBT(CompoundNBT tagCompound) {
        tagCompound.func_74772_a("Energy", this.energyStorage.getEnergy());
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        if (this.name != null && !this.name.isEmpty()) {
            info.func_74778_a("tpName", this.name);
        }
        info.func_74757_a("private", this.privateAccess);
        ListNBT playerTagList = new ListNBT();
        for (String player : this.allowedPlayers) {
            playerTagList.add((Object)StringNBT.func_229705_a_((String)player));
        }
        info.func_218657_a("players", (INBT)playerTagList);
        info.func_74768_a("destinationId", this.id);
    }

    public boolean execute(PlayerEntity playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_ADDPLAYER.equals(command)) {
            String playerName = (String)params.get(PARAM_PLAYER);
            this.addPlayer(playerName);
            return true;
        }
        if (CMD_DELPLAYER.equals(command)) {
            String playerName = (String)params.get(PARAM_PLAYER);
            this.delPlayer(playerName);
            return true;
        }
        return false;
    }

    @Nonnull
    public <T> List<T> executeWithResultList(String command, TypedMap args, Type<T> type) {
        List rc = super.executeWithResultList(command, args, type);
        if (!rc.isEmpty()) {
            return rc;
        }
        if ("getPlayers".equals(command)) {
            return type.convert(this.getAllowedPlayers());
        }
        return Collections.emptyList();
    }

    public <T> boolean receiveListFromServer(String command, List<T> list, Type<T> type) {
        boolean rc = super.receiveListFromServer(command, list, type);
        if (rc) {
            return true;
        }
        if ("getPlayers".equals(command)) {
            GuiMatterReceiver.storeAllowedPlayersForClient(Type.STRING.convert(list));
            return true;
        }
        return false;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyHandler.cast();
        }
        if (cap == CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY) {
            return this.screenHandler.cast();
        }
        if (cap == CapabilityInfusable.INFUSABLE_CAPABILITY) {
            return this.infusableHandler.cast();
        }
        return super.getCapability(cap, facing);
    }
}

