/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.blocks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.CapabilityInfusable;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.bindings.DefaultValue;
import mcjty.lib.bindings.IValue;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.Cached;
import mcjty.lib.varia.DimensionId;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.WorldTools;
import mcjty.rftoolsbase.api.machineinfo.CapabilityMachineInformation;
import mcjty.rftoolsbase.api.machineinfo.IMachineInformation;
import mcjty.rftoolsutility.modules.teleporter.TeleportConfiguration;
import mcjty.rftoolsutility.modules.teleporter.TeleportationTools;
import mcjty.rftoolsutility.modules.teleporter.TeleporterModule;
import mcjty.rftoolsutility.modules.teleporter.blocks.DialingDeviceTileEntity;
import mcjty.rftoolsutility.modules.teleporter.blocks.MatterReceiverTileEntity;
import mcjty.rftoolsutility.modules.teleporter.client.GuiMatterTransmitter;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestination;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestinations;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class MatterTransmitterTileEntity
extends GenericTileEntity
implements ITickableTileEntity {
    public static final String CMD_ADDPLAYER = "transmitter.addPlayer";
    public static final String CMD_DELPLAYER = "transmitter.delPlayer";
    public static final Key<String> PARAM_PLAYER = new Key("player", Type.STRING);
    public static final String CMD_GETPLAYERS = "getPlayers";
    public static final String CLIENTCMD_GETPLAYERS = "getPlayers";
    private TeleportDestination teleportDestination = null;
    private Integer teleportId = null;
    private boolean once = false;
    private String name = null;
    private boolean privateAccess = false;
    private boolean beamHidden = false;
    private Set<String> allowedPlayers = new HashSet<String>();
    private int status = 0;
    private UUID teleportingPlayer = null;
    private int teleportTimer = 0;
    private int cooldownTimer = 0;
    private int totalTicks;
    private int goodTicks;
    private int badTicks;
    private int rfPerTick = 0;
    private int checkReceiverStatusCounter = 20;
    private final Cached<AxisAlignedBB> beamBox = Cached.of(this::createBeamBox);
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)TeleportConfiguration.TRANSMITTER_MAXENERGY.get()).intValue(), (long)((Integer)TeleportConfiguration.TRANSMITTER_RECEIVEPERTICK.get()).intValue());
    private final LazyOptional<GenericEnergyStorage> energyHandler = LazyOptional.of(() -> this.energyStorage);
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Matter Transmitter").containerSupplier((windowId, player) -> new GenericContainer((ContainerType)TeleporterModule.CONTAINER_MATTER_TRANSMITTER.get(), windowId.intValue(), (ContainerFactory)ContainerFactory.EMPTY.get(), this.func_174877_v(), (GenericTileEntity)this)).energyHandler(() -> this.energyStorage));
    private final LazyOptional<IInfusable> infusableHandler = LazyOptional.of(() -> new DefaultInfusable((TileEntity)this));
    private final LazyOptional<IMachineInformation> infoHandler = LazyOptional.of(this::createMachineInfo);
    public static final Key<String> VALUE_NAME = new Key("name", Type.STRING);
    public static final Key<Boolean> VALUE_PRIVATE = new Key("private", Type.BOOLEAN);
    public static final Key<Boolean> VALUE_BEAM = new Key("beam", Type.BOOLEAN);

    public IValue<?>[] getValues() {
        return new IValue[]{new DefaultValue(VALUE_NAME, this::getName, this::setName), new DefaultValue(VALUE_PRIVATE, this::isPrivateAccess, this::setPrivateAccess), new DefaultValue(VALUE_BEAM, this::isBeamHidden, this::setBeamHidden)};
    }

    public MatterTransmitterTileEntity() {
        super((TileEntityType)TeleporterModule.TYPE_MATTER_TRANSMITTER.get());
    }

    public String getName() {
        return this.name == null ? "" : this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.markDirtyClient();
    }

    public boolean isPrivateAccess() {
        return this.privateAccess;
    }

    public void setPrivateAccess(boolean privateAccess) {
        this.privateAccess = privateAccess;
        this.markDirtyClient();
    }

    public boolean isBeamHidden() {
        return this.beamHidden;
    }

    public void setBeamHidden(boolean b) {
        this.beamHidden = b;
        this.markDirtyClient();
    }

    public boolean isOnce() {
        return this.once;
    }

    public boolean checkAccess(String player) {
        if (!this.privateAccess) {
            return true;
        }
        return this.allowedPlayers.contains(player);
    }

    public boolean checkAccess(UUID player) {
        if (!this.privateAccess) {
            return true;
        }
        ServerPlayerEntity entity = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_177451_a(player);
        if (entity == null) {
            return false;
        }
        return this.allowedPlayers.contains(entity.func_145748_c_().func_150254_d());
    }

    public int getStatus() {
        return this.status;
    }

    public List<String> getAllowedPlayers() {
        return new ArrayList<String>(this.allowedPlayers);
    }

    public void addPlayer(String player) {
        if (!this.allowedPlayers.contains(player)) {
            this.allowedPlayers.add(player);
            this.markDirtyClient();
        }
    }

    public void delPlayer(String player) {
        if (this.allowedPlayers.contains(player)) {
            this.allowedPlayers.remove(player);
            this.markDirtyClient();
        }
    }

    public void func_145839_a(CompoundNBT tagCompound) {
        super.func_145839_a(tagCompound);
        this.teleportTimer = tagCompound.func_74762_e("tpTimer");
        this.cooldownTimer = tagCompound.func_74762_e("cooldownTimer");
        this.totalTicks = tagCompound.func_74762_e("totalTicks");
        this.goodTicks = tagCompound.func_74762_e("goodTicks");
        this.badTicks = tagCompound.func_74762_e("badTicks");
        this.teleportingPlayer = tagCompound.func_186855_b("tpPlayer") ? tagCompound.func_186857_a("tpPlayer") : null;
        this.status = tagCompound.func_74762_e("status");
        this.rfPerTick = tagCompound.func_74762_e("rfPerTick");
    }

    protected void readInfo(CompoundNBT tagCompound) {
        super.readInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        this.name = info.func_74779_i("tpName");
        BlockPos c = BlockPosTools.read((CompoundNBT)info, (String)"dest");
        if (c == null) {
            this.teleportDestination = null;
        } else {
            String dim = info.func_74779_i("dim");
            this.teleportDestination = new TeleportDestination(c, DimensionId.fromResourceLocation((ResourceLocation)new ResourceLocation(dim)));
        }
        this.teleportId = info.func_74764_b("destId") ? Integer.valueOf(info.func_74762_e("destId")) : null;
        this.privateAccess = info.func_74767_n("private");
        this.beamHidden = info.func_74767_n("hideBeam");
        this.once = info.func_74767_n("once");
        this.allowedPlayers.clear();
        ListNBT playerList = info.func_150295_c("players", 8);
        for (int i = 0; i < playerList.size(); ++i) {
            String player = playerList.func_150307_f(i);
            this.allowedPlayers.add(player);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("tpTimer", this.teleportTimer);
        tagCompound.func_74768_a("cooldownTimer", this.cooldownTimer);
        tagCompound.func_74768_a("totalTicks", this.totalTicks);
        tagCompound.func_74768_a("goodTicks", this.goodTicks);
        tagCompound.func_74768_a("badTicks", this.badTicks);
        if (this.teleportingPlayer != null) {
            tagCompound.func_186854_a("tpPlayer", this.teleportingPlayer);
        }
        tagCompound.func_74768_a("status", this.status);
        tagCompound.func_74768_a("rfPerTick", this.rfPerTick);
        return tagCompound;
    }

    protected void writeInfo(CompoundNBT tagCompound) {
        BlockPos c;
        super.writeInfo(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        if (this.name != null && !this.name.isEmpty()) {
            info.func_74778_a("tpName", this.name);
        }
        if (this.teleportDestination != null && (c = this.teleportDestination.getCoordinate()) != null) {
            BlockPosTools.write((CompoundNBT)info, (String)"dest", (BlockPos)c);
            info.func_74778_a("dim", this.teleportDestination.getDimension().getRegistryName().toString());
        }
        if (this.teleportId != null) {
            info.func_74768_a("destId", this.teleportId.intValue());
        }
        info.func_74757_a("private", this.privateAccess);
        info.func_74757_a("hideBeam", this.beamHidden);
        info.func_74757_a("once", this.once);
        ListNBT playerTagList = new ListNBT();
        for (String player : this.allowedPlayers) {
            playerTagList.add((Object)StringNBT.func_229705_a_((String)player));
        }
        info.func_218657_a("players", (INBT)playerTagList);
    }

    public boolean isDialed() {
        return this.teleportId != null || this.teleportDestination != null;
    }

    public Integer getTeleportId() {
        if (this.isDialed() && this.teleportId == null) {
            this.getTeleportDestination();
        }
        return this.teleportId;
    }

    public TeleportDestination getTeleportDestination() {
        if (this.teleportId != null) {
            TeleportDestinations teleportDestinations = TeleportDestinations.get(this.field_145850_b);
            GlobalCoordinate gc = teleportDestinations.getCoordinateForId(this.teleportId);
            if (gc == null) {
                return null;
            }
            return teleportDestinations.getDestination(gc.getCoordinate(), gc.getDimension());
        }
        return this.teleportDestination;
    }

    public void setTeleportDestination(TeleportDestination teleportDestination, boolean once) {
        this.teleportDestination = null;
        this.teleportId = null;
        this.once = once;
        if (teleportDestination != null) {
            TeleportDestinations destinations = TeleportDestinations.get(this.field_145850_b);
            Integer id = destinations.getIdForCoordinate(new GlobalCoordinate(teleportDestination.getCoordinate(), teleportDestination.getDimension()));
            if (id == null) {
                this.teleportDestination = teleportDestination;
            } else {
                this.teleportId = id;
            }
        }
        this.markDirtyClient();
    }

    private void consumeIdlePower() {
        if ((Integer)TeleportConfiguration.rfMatterIdleTick.get() > 0 && this.teleportingPlayer == null) {
            if (this.energyStorage.getEnergyStored() >= (Integer)TeleportConfiguration.rfMatterIdleTick.get()) {
                this.energyStorage.consumeEnergy((long)((Integer)TeleportConfiguration.rfMatterIdleTick.get()).intValue());
            } else {
                this.setTeleportDestination(null, false);
            }
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        if (this.isDialed()) {
            this.consumeIdlePower();
            --this.checkReceiverStatusCounter;
            if (this.checkReceiverStatusCounter <= 0) {
                this.checkReceiverStatusCounter = 20;
                int newstatus = DialingDeviceTileEntity.isDestinationAnalyzerAvailable(this.field_145850_b, this.func_174877_v()) ? this.checkReceiverStatus() : 0;
                if (newstatus != this.status) {
                    this.status = newstatus;
                    this.markDirtyClient();
                }
            }
        }
        if (this.isCoolingDown()) {
            return;
        }
        if (this.teleportingPlayer == null) {
            if (this.isDestinationValid()) {
                this.searchForNearestPlayer();
            }
        } else if (this.teleportDestination == null && this.teleportId == null) {
            PlayerEntity player = this.field_145850_b.func_217371_b(this.teleportingPlayer);
            if (player != null) {
                Logging.warn((PlayerEntity)player, (String)"The destination vanished! Aborting.");
            }
            this.clearTeleport(80);
        } else if (this.isPlayerOutsideBeam()) {
            this.clearTeleport(80);
        } else {
            int rf = this.rfPerTick;
            if (this.energyStorage.getEnergyStored() < rf) {
                this.handleEnergyShortage();
            } else {
                this.func_70296_d();
                this.energyStorage.consumeEnergy((long)rf);
                ++this.goodTicks;
                --this.teleportTimer;
                if (this.teleportTimer <= 0) {
                    this.performTeleport();
                }
            }
        }
    }

    private int checkReceiverStatus() {
        TileEntity tileEntity;
        BlockPos c;
        boolean exists;
        TeleportDestination destination = this.getTeleportDestination();
        if (destination == null) {
            return 1;
        }
        DimensionId dimension = destination.getDimension();
        ServerWorld w = WorldTools.getWorld((World)this.field_145850_b, (DimensionId)dimension);
        if (w == null) {
            if ((Integer)TeleportConfiguration.matterTransmitterLoadWorld.get() == -1) {
                return 2;
            }
            w = WorldTools.loadWorld((DimensionId)dimension);
            this.checkReceiverStatusCounter = (Integer)TeleportConfiguration.matterTransmitterLoadWorld.get();
        }
        if (!(exists = WorldTools.isLoaded((World)w, (BlockPos)(c = destination.getCoordinate())))) {
            if ((Integer)TeleportConfiguration.matterTransmitterLoadChunk.get() == -1) {
                return 2;
            }
            this.checkReceiverStatusCounter = (Integer)TeleportConfiguration.matterTransmitterLoadChunk.get();
        }
        if (!((tileEntity = w.func_175625_s(c)) instanceof MatterReceiverTileEntity)) {
            return 1;
        }
        MatterReceiverTileEntity matterReceiverTileEntity = (MatterReceiverTileEntity)tileEntity;
        int status = matterReceiverTileEntity.checkStatus();
        return status == 0 ? 0 : 1;
    }

    private void clearTeleport(int cooldown) {
        this.func_70296_d();
        TeleportationTools.applyBadEffectIfNeeded(this.field_145850_b.func_217371_b(this.teleportingPlayer), 0, this.badTicks, this.totalTicks, false);
        this.cooldownTimer = cooldown;
        this.teleportingPlayer = null;
    }

    private boolean isDestinationValid() {
        return this.teleportId != null || this.teleportDestination != null && this.teleportDestination.isValid();
    }

    private boolean isCoolingDown() {
        this.func_70296_d();
        --this.cooldownTimer;
        if (this.cooldownTimer > 0) {
            return true;
        }
        this.cooldownTimer = 0;
        return false;
    }

    private AxisAlignedBB createBeamBox() {
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        return new AxisAlignedBB((double)xCoord, (double)(yCoord + 1), (double)zCoord, (double)(xCoord + 1), (double)(yCoord + 3), (double)(zCoord + 1));
    }

    private void searchForNearestPlayer() {
        List l = this.field_145850_b.func_217357_a(PlayerEntity.class, (AxisAlignedBB)this.beamBox.get());
        Entity nearestPlayer = this.findNearestPlayer(l);
        if (nearestPlayer == null) {
            this.cooldownTimer = 5;
            return;
        }
        AxisAlignedBB playerBB = nearestPlayer.func_174813_aQ();
        if (playerBB == null) {
            this.cooldownTimer = 5;
            return;
        }
        if (playerBB.func_72326_a((AxisAlignedBB)this.beamBox.get())) {
            this.startTeleportation(nearestPlayer);
        } else {
            this.cooldownTimer = 5;
        }
    }

    private Entity findNearestPlayer(List<Entity> l) {
        Entity nearestPlayer = null;
        double dmax = Double.MAX_VALUE;
        for (Entity entity : l) {
            double d1;
            PlayerEntity player;
            if (!(entity instanceof PlayerEntity) || (player = (PlayerEntity)entity).func_184218_aH() || player.func_184207_aI() || player.func_200200_C_() == null || this.isPrivateAccess() && !this.allowedPlayers.contains(player.func_145748_c_().func_150254_d()) || !((d1 = entity.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 1.5, (double)this.func_174877_v().func_177952_p() + 0.5)) <= dmax)) continue;
            nearestPlayer = entity;
            dmax = d1;
        }
        return nearestPlayer;
    }

    private void performTeleport() {
        boolean boostNeeded;
        PlayerEntity player;
        boolean boosted;
        if (!this.isDestinationStillValid()) {
            PlayerEntity player2 = this.field_145850_b.func_217371_b(this.teleportingPlayer);
            if (player2 != null) {
                TeleportationTools.applyBadEffectIfNeeded(player2, 10, this.badTicks, this.totalTicks, false);
                Logging.warn((PlayerEntity)player2, (String)"Missing destination!");
            }
            this.clearTeleport(200);
            return;
        }
        TeleportDestination dest = this.getTeleportDestination();
        if (this.once) {
            this.setTeleportDestination(null, false);
        }
        if ((boosted = DialingDeviceTileEntity.isMatterBoosterAvailable(this.field_145850_b, this.func_174877_v())) && this.energyStorage.getEnergyStored() < (Integer)TeleportConfiguration.rfBoostedTeleport.get()) {
            boosted = false;
        }
        if ((player = this.field_145850_b.func_217371_b(this.teleportingPlayer)) != null && (boostNeeded = TeleportationTools.performTeleport(player, dest, this.badTicks, this.totalTicks, boosted))) {
            this.energyStorage.consumeEnergy((long)((Integer)TeleportConfiguration.rfBoostedTeleport.get()).intValue());
        }
        this.teleportingPlayer = null;
    }

    private boolean isDestinationStillValid() {
        TeleportDestination dest = this.getTeleportDestination();
        return TeleportDestinations.get(this.field_145850_b).isDestinationValid(dest);
    }

    private void handleEnergyShortage() {
        this.func_70296_d();
        ++this.badTicks;
        if (TeleportationTools.mustInterrupt(this.badTicks, this.totalTicks)) {
            PlayerEntity player = this.field_145850_b.func_217371_b(this.teleportingPlayer);
            if (player != null) {
                Logging.warn((PlayerEntity)player, (String)"Power failure during transit!");
            }
            this.clearTeleport(200);
        }
    }

    private boolean isPlayerOutsideBeam() {
        PlayerEntity player = this.field_145850_b.func_217371_b(this.teleportingPlayer);
        if (player == null) {
            return true;
        }
        AxisAlignedBB playerBB = player.func_174813_aQ();
        if (playerBB == null) {
            return true;
        }
        if (!playerBB.func_72326_a((AxisAlignedBB)this.beamBox.get())) {
            Logging.message((PlayerEntity)player, (String)"Teleportation was interrupted!");
            return true;
        }
        return false;
    }

    public void startTeleportation(Entity entity) {
        if (this.cooldownTimer > 0) {
            return;
        }
        if (this.teleportingPlayer != null) {
            return;
        }
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        if (player.func_184218_aH() || player.func_184207_aI()) {
            this.cooldownTimer = 80;
            return;
        }
        TeleportDestination dest = this.teleportDestination;
        if (this.teleportId != null) {
            dest = this.getTeleportDestination();
        }
        if (dest != null && dest.isValid()) {
            DimensionId dstId;
            int defaultCost = TeleportationTools.calculateRFCost(this.field_145850_b, this.func_174877_v(), dest);
            int cost = (Integer)this.infusableHandler.map(inf -> (int)((float)defaultCost * (4.0f - inf.getInfusedFactor()) / 4.0f)).orElse((Object)defaultCost);
            if (this.energyStorage.getEnergyStored() < cost) {
                Logging.warn((PlayerEntity)player, (String)"Not enough power to start the teleport!");
                this.cooldownTimer = 80;
                return;
            }
            DimensionId srcId = DimensionId.fromWorld((World)this.field_145850_b);
            if (!TeleportationTools.checkValidTeleport(player, srcId, dstId = dest.getDimension())) {
                this.cooldownTimer = 80;
                return;
            }
            Logging.message((PlayerEntity)player, (String)"Start teleportation...");
            this.teleportingPlayer = player.func_110124_au();
            int defaultTeleportTimer = TeleportationTools.calculateTime(this.field_145850_b, this.func_174877_v(), dest);
            int teleportTimer = (Integer)this.infusableHandler.map(inf -> (int)((float)defaultTeleportTimer * (1.2f - inf.getInfusedFactor()) / 1.2f)).orElse((Object)defaultTeleportTimer);
            int defaultRf = (Integer)TeleportConfiguration.rfTeleportPerTick.get();
            int rf = (Integer)this.infusableHandler.map(inf -> (int)((float)defaultRf * (4.0f - inf.getInfusedFactor()) / 4.0f)).orElse((Object)defaultRf);
            int totalRfUsed = cost + rf * (teleportTimer + 1);
            this.rfPerTick = totalRfUsed / (teleportTimer + 1);
            this.totalTicks = teleportTimer;
            this.goodTicks = 0;
            this.badTicks = 0;
        } else {
            Logging.warn((PlayerEntity)player, (String)"Something is wrong with the destination!");
        }
    }

    public boolean execute(PlayerEntity playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_ADDPLAYER.equals(command)) {
            this.addPlayer((String)params.get(PARAM_PLAYER));
            return true;
        }
        if (CMD_DELPLAYER.equals(command)) {
            this.delPlayer((String)params.get(PARAM_PLAYER));
            return true;
        }
        return false;
    }

    @Nonnull
    public <T> List<T> executeWithResultList(String command, TypedMap args, Type<T> type) {
        List rc = super.executeWithResultList(command, args, type);
        if (!rc.isEmpty()) {
            return rc;
        }
        if ("getPlayers".equals(command)) {
            return type.convert(this.getAllowedPlayers());
        }
        return Collections.emptyList();
    }

    public <T> boolean receiveListFromServer(String command, List<T> list, Type<T> type) {
        boolean rc = super.receiveListFromServer(command, list, type);
        if (rc) {
            return true;
        }
        if ("getPlayers".equals(command)) {
            GuiMatterTransmitter.storeAllowedPlayersForClient(Type.STRING.convert(list));
            return true;
        }
        return false;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v(), this.func_174877_v().func_177982_a(1, 4, 1));
    }

    private IMachineInformation createMachineInfo() {
        return new IMachineInformation(){
            private final String[] TAGS = new String[]{"dim", "coord", "name"};
            private final String[] TAG_DESCRIPTIONS = new String[]{"The dimension this transmitter is dialed too", "The coordinate this transmitter is dialed too", "The name of the destination"};

            public int getTagCount() {
                return this.TAGS.length;
            }

            public String getTagName(int index) {
                return this.TAGS[index];
            }

            public String getTagDescription(int index) {
                return this.TAG_DESCRIPTIONS[index];
            }

            public String getData(int index, long millis) {
                TeleportDestination destination = MatterTransmitterTileEntity.this.getTeleportDestination();
                if (destination == null) {
                    return "<not dialed>";
                }
                switch (index) {
                    case 0: {
                        return destination.getDimension().getRegistryName().toString();
                    }
                    case 1: {
                        return destination.getCoordinate().toString();
                    }
                    case 2: {
                        return destination.getName();
                    }
                }
                return null;
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyHandler.cast();
        }
        if (cap == CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY) {
            return this.screenHandler.cast();
        }
        if (cap == CapabilityInfusable.INFUSABLE_CAPABILITY) {
            return this.infusableHandler.cast();
        }
        if (cap == CapabilityMachineInformation.MACHINE_INFORMATION_CAPABILITY) {
            return this.infoHandler.cast();
        }
        return super.getCapability(cap, facing);
    }
}

