/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.VerticalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolsutility.modules.teleporter.TeleporterModule;
import mcjty.rftoolsutility.modules.teleporter.blocks.MatterReceiverTileEntity;
import mcjty.rftoolsutility.modules.teleporter.network.PacketGetPlayers;
import mcjty.rftoolsutility.setup.RFToolsUtilityMessages;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;

public class GuiMatterReceiver
extends GenericGuiContainer<MatterReceiverTileEntity, GenericContainer> {
    public static final int MATTER_WIDTH = 180;
    public static final int MATTER_HEIGHT = 160;
    public static final String ACCESS_PRIVATE = "Private";
    public static final String ACCESS_PUBLIC = "Public";
    private EnergyBar energyBar;
    private ChoiceLabel privateSetting;
    private WidgetList allowedPlayers;
    private Button addButton;
    private Button delButton;
    private TextField nameField;
    private List<String> players = null;
    private int listDirty = 0;
    private static Set<String> fromServer_allowedPlayers = new HashSet<String>();

    public static void storeAllowedPlayersForClient(List<String> players) {
        fromServer_allowedPlayers = new HashSet<String>(players);
    }

    public GuiMatterReceiver(MatterReceiverTileEntity matterReceiverTileEntity, GenericContainer container, PlayerInventory inventory) {
        super((GenericTileEntity)matterReceiverTileEntity, (Container)container, inventory, ((BaseBlock)TeleporterModule.MATTER_RECEIVER.get()).getManualEntry());
        this.field_146999_f = 180;
        this.field_147000_g = 160;
    }

    public static void register() {
        GuiMatterReceiver.register((ContainerType)((ContainerType)TeleporterModule.CONTAINER_MATTER_RECEIVER.get()), GuiMatterReceiver::new);
    }

    public void init() {
        super.init();
        this.energyBar = ((EnergyBar)((EnergyBar)((EnergyBar)new EnergyBar().filledRectThickness(1)).horizontal().desiredHeight(12)).desiredWidth(80)).showText(false);
        TextField textField = (TextField)((TextField)new TextField().name("name")).tooltips(new String[]{"Use this name to", "identify this receiver", "in the dialer"});
        Panel namePanel = (Panel)((Panel)Widgets.horizontal().children(new Widget[]{Widgets.label((String)"Name:"), textField})).desiredHeight(16);
        this.privateSetting = ((ChoiceLabel)((ChoiceLabel)((ChoiceLabel)new ChoiceLabel().choices(new String[]{ACCESS_PUBLIC, ACCESS_PRIVATE}).desiredHeight(14)).desiredWidth(60)).name("private")).choiceTooltip(ACCESS_PUBLIC, new String[]{"Everyone can dial to this receiver"}).choiceTooltip(ACCESS_PRIVATE, new String[]{"Only people in the access list below", "can dial to this receiver"});
        Panel privatePanel = (Panel)((Panel)Widgets.horizontal().children(new Widget[]{Widgets.label((String)"Access:"), this.privateSetting})).desiredHeight(16);
        this.allowedPlayers = (WidgetList)new WidgetList().name("allowedplayers");
        Slider allowedPlayerSlider = ((Slider)new Slider().desiredWidth(10)).vertical().scrollableName("allowedplayers");
        Panel allowedPlayersPanel = (Panel)((Panel)Widgets.horizontal((int)3, (int)1).children(new Widget[]{this.allowedPlayers, allowedPlayerSlider})).filledBackground(-6381922);
        this.nameField = new TextField();
        this.addButton = (Button)((Button)((Button)((Button)Widgets.button((String)"Add").channel("addplayer")).desiredHeight(13)).desiredWidth(34)).tooltips(new String[]{"Add a player to the access list"});
        this.delButton = (Button)((Button)((Button)((Button)Widgets.button((String)"Del").channel("delplayer")).desiredHeight(13)).desiredWidth(34)).tooltips(new String[]{"Remove the selected player", "from the access list"});
        Panel buttonPanel = (Panel)((Panel)Widgets.horizontal().children(new Widget[]{this.nameField, this.addButton, this.delButton})).desiredHeight(16);
        Panel toplevel = (Panel)((Panel)new Panel().filledRectThickness(2)).layout((Layout)((VerticalLayout)((VerticalLayout)new VerticalLayout().setHorizontalMargin(3)).setVerticalMargin(3)).setSpacing(1)).children(new Widget[]{this.energyBar, namePanel, privatePanel, allowedPlayersPanel, buttonPanel});
        toplevel.bounds(this.field_147003_i, this.field_147009_r, 180, 160);
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
        this.minecraft.field_195559_v.func_197967_a(true);
        this.listDirty = 0;
        this.requestPlayers();
        this.window.bind(RFToolsUtilityMessages.INSTANCE, "name", this.tileEntity, MatterReceiverTileEntity.VALUE_NAME.getName());
        this.window.bind(RFToolsUtilityMessages.INSTANCE, "private", this.tileEntity, MatterReceiverTileEntity.VALUE_PRIVATE.getName());
        this.window.event("addplayer", (source, params) -> this.addPlayer());
        this.window.event("delplayer", (source, params) -> this.delPlayer());
    }

    private void addPlayer() {
        this.sendServerCommandTyped(RFToolsUtilityMessages.INSTANCE, "receiver.addPlayer", TypedMap.builder().put(MatterReceiverTileEntity.PARAM_PLAYER, (Object)this.nameField.getText()).build());
        this.listDirty = 0;
    }

    private void delPlayer() {
        this.sendServerCommandTyped(RFToolsUtilityMessages.INSTANCE, "receiver.delPlayer", TypedMap.builder().put(MatterReceiverTileEntity.PARAM_PLAYER, (Object)this.nameField.getText()).build());
        this.listDirty = 0;
    }

    private void requestPlayers() {
        RFToolsUtilityMessages.INSTANCE.sendToServer((Object)new PacketGetPlayers(((MatterReceiverTileEntity)this.tileEntity).func_174877_v(), "getPlayers", "getPlayers"));
    }

    private void populatePlayers() {
        ArrayList<String> newPlayers = new ArrayList<String>(fromServer_allowedPlayers);
        Collections.sort(newPlayers);
        if (newPlayers.equals(this.players)) {
            return;
        }
        this.players = new ArrayList<String>(newPlayers);
        this.allowedPlayers.removeChildren();
        for (String player : this.players) {
            this.allowedPlayers.children(new Widget[]{((Label)Widgets.label((String)player).color(StyleConfig.colorTextInListNormal)).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)});
        }
    }

    private void requestListsIfNeeded() {
        --this.listDirty;
        if (this.listDirty <= 0) {
            this.requestPlayers();
            this.listDirty = 20;
        }
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.requestListsIfNeeded();
        this.populatePlayers();
        this.enableButtons();
        this.drawWindow();
        this.updateEnergyBar(this.energyBar);
    }

    private void enableButtons() {
        boolean isPrivate = ACCESS_PRIVATE.equals(this.privateSetting.getCurrentChoice());
        this.allowedPlayers.enabled(isPrivate);
        this.nameField.enabled(isPrivate);
        int isPlayerSelected = this.allowedPlayers.getSelected();
        this.delButton.enabled(isPrivate && isPlayerSelected != -1);
        String name = this.nameField.getText();
        this.addButton.enabled(isPrivate && name != null && !name.isEmpty());
    }
}

