/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.DimensionId;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.WorldTools;
import mcjty.lib.worlddata.AbstractWorldData;
import mcjty.rftoolsutility.modules.teleporter.blocks.MatterReceiverTileEntity;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestination;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestinationClientInfo;
import mcjty.rftoolsutility.playerprops.FavoriteDestinationsProperties;
import mcjty.rftoolsutility.playerprops.PlayerExtendedProperties;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class TeleportDestinations
extends AbstractWorldData<TeleportDestinations> {
    private static final String TPDESTINATIONS_NAME = "TPDestinations";
    private final Map<GlobalCoordinate, TeleportDestination> destinations = new HashMap<GlobalCoordinate, TeleportDestination>();
    private final Map<Integer, GlobalCoordinate> destinationById = new HashMap<Integer, GlobalCoordinate>();
    private final Map<GlobalCoordinate, Integer> destinationIdByCoordinate = new HashMap<GlobalCoordinate, Integer>();
    private int lastId = 0;

    public TeleportDestinations() {
        super(TPDESTINATIONS_NAME);
    }

    public static String getDestinationName(TeleportDestinations destinations, int receiverId) {
        String name;
        GlobalCoordinate coordinate = destinations.getCoordinateForId(receiverId);
        if (coordinate == null) {
            name = "?";
        } else {
            TeleportDestination destination = destinations.getDestination(coordinate);
            if (destination == null) {
                name = "?";
            } else {
                name = destination.getName();
                if (name == null || name.isEmpty()) {
                    name = BlockPosTools.toString((BlockPos)destination.getCoordinate()) + " (" + destination.getDimension().getName() + ")";
                }
            }
        }
        return name;
    }

    public void cleanupInvalid() {
        HashSet<GlobalCoordinate> keys = new HashSet<GlobalCoordinate>(this.destinations.keySet());
        for (GlobalCoordinate key : keys) {
            ServerWorld transWorld = WorldTools.loadWorld((DimensionId)key.getDimension());
            boolean removed = false;
            if (transWorld == null) {
                Logging.log((String)("Receiver on dimension " + key.getDimension() + " removed because world can't be loaded!"));
                removed = true;
            } else {
                TileEntity te;
                BlockPos c = key.getCoordinate();
                try {
                    te = transWorld.func_175625_s(c);
                }
                catch (Exception e) {
                    te = null;
                }
                if (!(te instanceof MatterReceiverTileEntity)) {
                    Logging.log((String)("Receiver at " + c + " on dimension " + key.getDimension().getName() + " removed because there is no receiver there!"));
                    removed = true;
                }
            }
            if (!removed) continue;
            this.destinations.remove(key);
        }
    }

    public static TeleportDestinations get(World world) {
        return (TeleportDestinations)TeleportDestinations.getData((World)world, TeleportDestinations::new, (String)TPDESTINATIONS_NAME);
    }

    public Collection<TeleportDestinationClientInfo> getValidDestinations(World worldObj, UUID player) {
        FavoriteDestinationsProperties properties = null;
        if (player != null) {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            List list = server.func_184103_al().func_181057_v();
            for (ServerPlayerEntity entity : list) {
                if (!player.equals(entity.func_110124_au())) continue;
                properties = (FavoriteDestinationsProperties)PlayerExtendedProperties.getFavoriteDestinations((PlayerEntity)entity).map(h -> h).orElse(null);
                break;
            }
        }
        ArrayList<TeleportDestinationClientInfo> result = new ArrayList<TeleportDestinationClientInfo>();
        for (TeleportDestination destination : this.destinations.values()) {
            TileEntity te;
            TeleportDestinationClientInfo destinationClientInfo = new TeleportDestinationClientInfo(destination);
            BlockPos c = destination.getCoordinate();
            ServerWorld world = WorldTools.loadWorld((DimensionId)destination.getDimension());
            String dimName = null;
            if (world != null) {
                dimName = DimensionId.fromWorld((World)world).getName();
            }
            dimName = dimName == null || dimName.trim().isEmpty() ? "Id " + destination.getDimension().getInternalId() : dimName + " (" + destination.getDimension().getInternalId() + ")";
            destinationClientInfo.setDimensionName(dimName);
            if (world != null && (te = world.func_175625_s(c)) instanceof MatterReceiverTileEntity) {
                MatterReceiverTileEntity matterReceiverTileEntity = (MatterReceiverTileEntity)te;
                if (player != null && !matterReceiverTileEntity.checkAccess(player)) continue;
            }
            if (properties != null) {
                destinationClientInfo.setFavorite(properties.isDestinationFavorite(new GlobalCoordinate(c, destination.getDimension())));
            }
            result.add(destinationClientInfo);
        }
        Collections.sort(result);
        return result;
    }

    public boolean isDestinationValid(TeleportDestination destination) {
        GlobalCoordinate key = new GlobalCoordinate(destination.getCoordinate(), destination.getDimension());
        return this.destinations.containsKey(key);
    }

    public void assignId(GlobalCoordinate key, int id) {
        this.destinationById.put(id, key);
        this.destinationIdByCoordinate.put(key, id);
    }

    public int getNewId(GlobalCoordinate key) {
        if (this.destinationIdByCoordinate.containsKey(key)) {
            return this.destinationIdByCoordinate.get(key);
        }
        ++this.lastId;
        this.destinationById.put(this.lastId, key);
        this.destinationIdByCoordinate.put(key, this.lastId);
        return this.lastId;
    }

    public Integer getIdForCoordinate(GlobalCoordinate key) {
        return this.destinationIdByCoordinate.get(key);
    }

    public GlobalCoordinate getCoordinateForId(int id) {
        return this.destinationById.get(id);
    }

    public TeleportDestination addDestination(GlobalCoordinate key) {
        if (!this.destinations.containsKey(key)) {
            TeleportDestination teleportDestination = new TeleportDestination(key.getCoordinate(), key.getDimension());
            this.destinations.put(key, teleportDestination);
        }
        return this.destinations.get(key);
    }

    public void removeDestinationsInDimension(DimensionId dimension) {
        HashSet<GlobalCoordinate> keysToRemove = new HashSet<GlobalCoordinate>();
        for (Map.Entry<GlobalCoordinate, TeleportDestination> entry : this.destinations.entrySet()) {
            if (!entry.getKey().getDimension().equals((Object)dimension)) continue;
            keysToRemove.add(entry.getKey());
        }
        for (GlobalCoordinate key : keysToRemove) {
            this.removeDestination(key.getCoordinate(), key.getDimension());
        }
    }

    public void removeDestination(BlockPos coordinate, DimensionId dimension) {
        if (coordinate == null) {
            return;
        }
        GlobalCoordinate key = new GlobalCoordinate(coordinate, dimension);
        this.destinations.remove(key);
        Integer id = this.destinationIdByCoordinate.get(key);
        if (id != null) {
            this.destinationById.remove(id);
            this.destinationIdByCoordinate.remove(key);
        }
    }

    public TeleportDestination getDestination(GlobalCoordinate coordinate) {
        return this.destinations.get(coordinate);
    }

    public TeleportDestination getDestination(BlockPos coordinate, DimensionId dimension) {
        return this.destinations.get(new GlobalCoordinate(coordinate, dimension));
    }

    public void func_76184_a(CompoundNBT tagCompound) {
        this.destinations.clear();
        this.destinationById.clear();
        this.destinationIdByCoordinate.clear();
        this.lastId = tagCompound.func_74762_e("lastId");
        this.readDestinationsFromNBT(tagCompound);
    }

    private void readDestinationsFromNBT(CompoundNBT tagCompound) {
        ListNBT lst = tagCompound.func_150295_c("destinations", 10);
        for (int i = 0; i < lst.size(); ++i) {
            CompoundNBT tc = lst.func_150305_b(i);
            BlockPos c = new BlockPos(tc.func_74762_e("x"), tc.func_74762_e("y"), tc.func_74762_e("z"));
            String dims = tc.func_74779_i("dim");
            DimensionId dim = DimensionId.fromResourceLocation((ResourceLocation)new ResourceLocation(dims));
            String name = tc.func_74779_i("name");
            TeleportDestination destination = new TeleportDestination(c, dim);
            destination.setName(name);
            GlobalCoordinate gc = new GlobalCoordinate(c, dim);
            this.destinations.put(gc, destination);
            if (!tc.func_74764_b("id")) continue;
            int id = tc.func_74762_e("id");
            this.destinationById.put(id, gc);
            this.destinationIdByCoordinate.put(gc, id);
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT tagCompound) {
        TeleportDestinations.writeDestinationsToNBT(tagCompound, this.destinations.values(), this.destinationIdByCoordinate);
        tagCompound.func_74768_a("lastId", this.lastId);
        return tagCompound;
    }

    private static void writeDestinationsToNBT(CompoundNBT tagCompound, Collection<TeleportDestination> destinations, Map<GlobalCoordinate, Integer> coordinateToInteger) {
        ListNBT lst = new ListNBT();
        for (TeleportDestination destination : destinations) {
            Integer id;
            CompoundNBT tc = new CompoundNBT();
            BlockPos c = destination.getCoordinate();
            tc.func_74768_a("x", c.func_177958_n());
            tc.func_74768_a("y", c.func_177956_o());
            tc.func_74768_a("z", c.func_177952_p());
            tc.func_74778_a("dim", destination.getDimension().getRegistryName().toString());
            tc.func_74778_a("name", destination.getName());
            if (coordinateToInteger != null && (id = coordinateToInteger.get(new GlobalCoordinate(c, destination.getDimension()))) != null) {
                tc.func_74768_a("id", id.intValue());
            }
            lst.add((Object)tc);
        }
        tagCompound.func_218657_a("destinations", (INBT)lst);
    }
}

