/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import mcjty.lib.McJtyLib;
import mcjty.lib.network.IClientCommandHandler;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsutility.modules.teleporter.data.TransmitterInfo;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketTransmittersReady {
    public BlockPos pos;
    public List<TransmitterInfo> list;
    public String command;

    public PacketTransmittersReady() {
    }

    public PacketTransmittersReady(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.command = buf.func_150789_c(Short.MAX_VALUE);
        int size = buf.readInt();
        if (size != -1) {
            this.list = new ArrayList<TransmitterInfo>(size);
            for (int i = 0; i < size; ++i) {
                TransmitterInfo item = new TransmitterInfo(buf);
                this.list.add(item);
            }
        } else {
            this.list = null;
        }
    }

    public PacketTransmittersReady(BlockPos pos, String command, List<TransmitterInfo> list) {
        this.pos = pos;
        this.command = command;
        this.list = new ArrayList<TransmitterInfo>();
        this.list.addAll(list);
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.func_180714_a(this.command);
        if (this.list == null) {
            buf.writeInt(-1);
        } else {
            buf.writeInt(this.list.size());
            for (TransmitterInfo item : this.list) {
                item.toBytes(buf);
            }
        }
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            TileEntity te = McJtyLib.proxy.getClientWorld().func_175625_s(this.pos);
            if (!(te instanceof IClientCommandHandler)) {
                Logging.log((String)"createInventoryReadyPacket: TileEntity is not a ClientCommandHandler!");
                return;
            }
            IClientCommandHandler clientCommandHandler = (IClientCommandHandler)te;
            if (!clientCommandHandler.receiveListFromServer(this.command, this.list, Type.create(TransmitterInfo.class))) {
                Logging.log((String)("Command " + this.command + " was not handled!"));
            }
        });
        ctx.setPacketHandled(true);
    }
}

